package org.apache.maven.archiva.repository.project;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.model.ArchivaProjectModel;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

/**
 * ProjectModelWriter 
 *
 * @version $Id: ProjectModelWriter.java 718864 2008-11-19 06:33:35Z brett $
 */
public interface ProjectModelWriter
{
    /**
     * Write a project model out to disk.
     * 
     * @param model the model to write.
     * @param pomFile the (pom) file on disk to write to.
     * @throws ProjectModelException if there was a problem with the model itself.
     * @throws IOException if there was a problem writing the pom file.
     */
    public void write( ArchivaProjectModel model, File pomFile )
        throws ProjectModelException, IOException;

    /**
     * Write a project model out to a {@link Writer}.
     * 
     * @param model the model to write.
     * @param writer the writer (stream) to write to.
     * @throws ProjectModelException if there was a problem with the model itself.
     * @throws IOException if there was a problem writing the pom file.
     */
    public void write( ArchivaProjectModel model, Writer writer )
        throws ProjectModelException, IOException;
}
