package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.model.ArchivaProjectModel;
import org.apache.maven.archiva.model.Dependency;
import org.apache.maven.archiva.model.VersionedReference;

/**
 * WagonManagerMemoryRepository
 * 
 * MemoryRepository for testing <code>org.apache.maven.wagon:wagon-manager:2.0-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: WagonManagerMemoryRepository.java 547277 2007-06-14 15:25:42Z joakime $
 */
public class WagonManagerMemoryRepository
   extends AbstractMemoryRepository
{
   public void initialize()
   {
      ArchivaProjectModel model;
      Dependency dep;

      model = toModel( "org.apache.maven.wagon:wagon-manager:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ftp:2.0-SNAPSHOT::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-external:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-webdav:2.0-SNAPSHOT::jar", "test" ) );
      dep = toDependency( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-1::jar", "test" );
      addExclusion( dep, "org.codehaus.plexus:plexus-component-api" );
      model.addDependency( dep );
      model.addDependency( toDependency( "org.mortbay.jetty:jetty:6.0.2::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-test:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-6::jar" );
      addExclusion( dep, "plexus:plexus-utils" );
      addExclusion( dep, "org.codehaus.plexus:plexus-container-default" );
      addExclusion( dep, "classworlds:classworlds" );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven:maven-parent:5" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-test:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh-common:2.0-SNAPSHOT::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-6::jar" );
      addExclusion( dep, "plexus:plexus-utils" );
      addExclusion( dep, "org.codehaus.plexus:plexus-container-default" );
      addExclusion( dep, "classworlds:classworlds" );
      model.addDependencyManagement( dep );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-parent:5" );
      model.setParentProject( toParent( "org.apache:apache:3" ) );
      addModel( model );

      model = toModel( "org.apache:apache:3" );
      addModel( model );

      model = toModel( "junit:junit:3.8.1" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.11" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.11" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:2.0-SNAPSHOT" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-common-test:2.0-SNAPSHOT" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-common:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:2.0-SNAPSHOT::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-interactivity:1.0-alpha-6" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-interactivity:1.0-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.9" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.9" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.10" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.10" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-16" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-16" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.9" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.8" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.8" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-16" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "jmock:jmock:1.0.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.4" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0.3" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0.3" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.4" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus:1.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-utils:1.0.4" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "classworlds:classworlds:1.1-alpha-2" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ftp:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "commons-net:commons-net:1.4.1::jar" ) );
      dep = toDependency( "org.codehaus.plexus:plexus-ftpd:1.0-alpha-1::jar", "test" );
      addExclusion( dep, "plexus:plexus-container-default" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "commons-net:commons-net:1.4.1" );
      model.addDependency( toDependency( "oro:oro:2.0.8::jar" ) );
      addModel( model );

      model = toModel( "oro:oro:2.0.8" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-ftpd:1.0-alpha-1" );
      model.addDependency( toDependency( "concurrent:concurrent:1.3.4::jar", "compile" ) );
      model.addDependency( toDependency( "cornerstone-threads:cornerstone-threads-api:1.0::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "cornerstone-sockets:cornerstone-sockets-api:1.0::jar", "compile" ) );
      model.addDependency( toDependency( "cornerstone-connection:cornerstone-connection-impl:1.0::jar", "compile" ) );
      model.addDependency( toDependency( "excalibur-pool:excalibur-pool-impl:2.0::jar", "compile" ) );
      model.addDependency( toDependency( "excalibur-thread:excalibur-thread:1.1.1::jar", "compile" ) );
      model.addDependency( toDependency( "cornerstone-sockets:cornerstone-sockets-impl:1.0::jar", "compile" ) );
      model.addDependency( toDependency( "cornerstone-connection:cornerstone-connection-api:1.0::jar", "compile" ) );
      model.addDependency( toDependency( "commons-collections:commons-collections:3.0::jar", "compile" ) );
      model.addDependency( toDependency( "avalon:avalon-framework:4.1.4::jar", "compile" ) );
      model.addDependency( toDependency( "cornerstone-threads:cornerstone-threads-impl:1.0::jar", "compile" ) );
      model.addDependency( toDependency( "excalibur-pool:excalibur-pool-api:2.0::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-avalon-personality:0.13::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-container-default:1.0-alpha-2::jar", "compile" ) );
      addModel( model );

      model = toModel( "concurrent:concurrent:1.3.4" );
      addModel( model );

      model = toModel( "cornerstone-threads:cornerstone-threads-api:1.0" );
      addModel( model );

      model = toModel( "cornerstone-sockets:cornerstone-sockets-api:1.0" );
      addModel( model );

      model = toModel( "cornerstone-connection:cornerstone-connection-impl:1.0" );
      addModel( model );

      model = toModel( "excalibur-pool:excalibur-pool-impl:2.0" );
      addModel( model );

      model = toModel( "excalibur-thread:excalibur-thread:1.1.1" );
      addModel( model );

      model = toModel( "cornerstone-sockets:cornerstone-sockets-impl:1.0" );
      addModel( model );

      model = toModel( "cornerstone-connection:cornerstone-connection-api:1.0" );
      addModel( model );

      model = toModel( "commons-collections:commons-collections:3.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "avalon:avalon-framework:4.1.4" );
      addModel( model );

      model = toModel( "cornerstone-threads:cornerstone-threads-impl:1.0" );
      addModel( model );

      model = toModel( "excalibur-pool:excalibur-pool-api:2.0" );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-avalon-personality:0.13" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "avalon:avalon-framework:4.1.4::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-container-default:1.0-alpha-2::jar", "compile" ) );
      addModel( model );

      model = toModel( "plexus:plexus-container-default:1.0-alpha-2" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-http-shared:2.0-SNAPSHOT::jar" ) );
      dep = toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" );
      addExclusion( dep, "plexus:plexus-container-default" );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-shared:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "jtidy:jtidy:4aug2000r7-dev::jar" ) );
      addModel( model );

      model = toModel( "jtidy:jtidy:4aug2000r7-dev" );
      addModel( model );

      model = toModel( "plexus:plexus-jetty-httpd:1.0-beta-1" );
      model.setParentProject( toParent( "plexus:plexus-components:1.0" ) );
      model.addDependency( toDependency( "jetty:jetty:4.2.10::jar" ) );
      model.addDependency( toDependency( "servletapi:servletapi:2.3::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-components:1.0" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0" ) );
      model.addDependency( toDependency( "plexus:plexus-container-default:1.0-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-root:1.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "jetty:jetty:4.2.10" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar", "runtime" ) );
      addModel( model );

      model = toModel( "javax.servlet:servlet-api:2.3" );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.3" );
      model.setRelocation( new VersionedReference() );
      model.getRelocation().setGroupId( "javax.servlet" );
      model.getRelocation().setArtifactId( "servlet-api" );
      model.getRelocation().setVersion( "2.3" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.27::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-6::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:2.0-SNAPSHOT::jar", "test" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.27" );
      dep = toDependency( "com.jcraft:jzlib:1.0.7::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "com.jcraft:jzlib:1.0.7" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh-external:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common:2.0-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-ssh-common-test:2.0-SNAPSHOT::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-webdav:2.0-SNAPSHOT" );
      model.setParentProject( toParent( "org.apache.maven.wagon:wagon-providers:2.0-SNAPSHOT" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" ) );
      model.addDependency( toDependency( "slide:slide-webdavlib:2.1::jar" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.4::jar", "runtime" ) );
      model.addDependency( toDependency( "it.could:webdav:0.4::jar", "test" ) );
      addModel( model );

      model = toModel( "slide:slide-webdavlib:2.1" );
      model.addDependency( toDependency( "commons-httpclient:commons-httpclient:2.0.2::jar" ) );
      model.addDependency( toDependency( "jdom:jdom:1.0::jar" ) );
      model.addDependency( toDependency( "de.zeigermann.xml:xml-im-exporter:1.1::jar" ) );
      addModel( model );

      model = toModel( "commons-httpclient:commons-httpclient:2.0.2" );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.3" );
      dep = toDependency( "log4j:log4j:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      addModel( model );

      model = toModel( "log4j:log4j:1.2.6" );
      addModel( model );

      model = toModel( "logkit:logkit:1.0.1" );
      addModel( model );

      model = toModel( "junit:junit:3.7" );
      addModel( model );

      model = toModel( "jdom:jdom:1.0" );
      dep = toDependency( "xerces:xercesImpl:2.6.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:1.0.b2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "jaxen:jaxen:1.0-FCS::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "saxpath:saxpath:1.0-FCS::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xalan:xalan:2.5.0::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "xerces:xercesImpl:2.6.0" );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:1.0.b2" );
      addModel( model );

      model = toModel( "jaxen:jaxen:1.0-FCS" );
      addModel( model );

      model = toModel( "saxpath:saxpath:1.0-FCS" );
      addModel( model );

      model = toModel( "xalan:xalan:2.5.0" );
      addModel( model );

      model = toModel( "de.zeigermann.xml:xml-im-exporter:1.1" );
      addModel( model );

      model = toModel( "commons-logging:commons-logging:1.0.4" );
      dep = toDependency( "log4j:log4j:1.2.6::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "logkit:logkit:1.0.1::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      model.addDependency( toDependency( "junit:junit:3.7::jar", "test" ) );
      dep = toDependency( "avalon-framework:avalon-framework:4.1.3::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "avalon-framework:avalon-framework:4.1.3" );
      addModel( model );

      model = toModel( "it.could:webdav:0.4" );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar", "runtime" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.webdav:plexus-webdav-providers-parent:1.0-alpha-1" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      model.addDependency( toDependency( "it.could:webdav:0.4::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-providers-parent:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.webdav:plexus-webdav-parent:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-api:1.0-alpha-1::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus.webdav:plexus-webdav-test:1.0-alpha-1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-parent:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-components:1.1.8" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-components:1.1.8" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-15::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-15::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-component-api:1.0-alpha-15" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-15" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-6::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-containers:1.0-alpha-15" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-6::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-15::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-6" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus:1.0.9" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-15" );
      model.setParentProject( toParent( "org.codehaus.plexus:plexus-containers:1.0-alpha-15" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-15::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.3::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-6::jar" ) );
      model.addDependency( toDependency( "jmock:jmock:1.0.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-api:1.0-alpha-1" );
      model.setParentProject( toParent( "org.codehaus.plexus.webdav:plexus-webdav-parent:1.0-alpha-1" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-16::jar" ) );
      model.addDependency( toDependency( "javax.servlet:servlet-api:2.3::jar" ) );
      model.addDependency( toDependency( "commons-lang:commons-lang:2.1::jar" ) );
      addModel( model );

      model = toModel( "commons-lang:commons-lang:2.1" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus.webdav:plexus-webdav-test:1.0-alpha-1" );
      addModel( model );

      model = toModel( "org.mortbay.jetty:jetty:6.0.2" );
      model.setParentProject( toParent( "org.mortbay.jetty:project:6.0.2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.mortbay.jetty:jetty-util:6.0.2::jar" ) );
      model.addDependency( toDependency( "org.mortbay.jetty:servlet-api-2.5:6.0.2::jar" ) );
      addModel( model );

      model = toModel( "org.mortbay.jetty:project:6.0.2" );
      model.addDependencyManagement( toDependency( "org.apache.maven:maven-plugin-tools-api:2.0::jar" ) );
      model.addDependencyManagement( toDependency( "junit:junit:3.8.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.slf4j:jcl104-over-slf4j:1.0.1::jar" ) );
      model.addDependencyManagement( toDependency( "org.slf4j:slf4j-simple:1.0.1::jar" ) );
      model.addDependencyManagement( toDependency( "mx4j:mx4j:3.0.1::jar" ) );
      model.addDependencyManagement( toDependency( "mx4j:mx4j-tools:3.0.1::jar" ) );
      model.addDependencyManagement( toDependency( "xerces:xercesImpl:${xerces-version}::jar" ) );
      model.addDependencyManagement( toDependency( "commons-el:commons-el:1.0::jar" ) );
      model.addDependencyManagement( toDependency( "ant:ant:1.6.5::jar" ) );
      model.addDependencyManagement( toDependency( "javax.mail:mail:1.4::jar" ) );
      model.addDependencyManagement( toDependency( "javax.activation:activation:1.1::jar" ) );
      model.addProperty( "jasper-version", "5.5.15" );
      model.addProperty( "junit-version", "3.8.1" );
      model.addProperty( "ant-version", "1.6.5" );
      model.addProperty( "mail-version", "1.4" );
      model.addProperty( "commons-el-version", "1.0" );
      model.addProperty( "slf4j-version", "1.0.1" );
      model.addProperty( "eclipse-compiler-version", "3.1.1" );
      model.addProperty( "mx4j-version", "3.0.1" );
      model.addProperty( "jta-spec-version", "1.0.1B-rc4" );
      model.addProperty( "activation-version", "1.1" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-tools-api:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven-plugin-tools:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-project:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-descriptor:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-tools:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven:2.0" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependencyManagement( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-5::jar" ) );
      model.addDependencyManagement( toDependency( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-5::jar" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-ssh:1.0-alpha-5" );
      model.addDependency( toDependency( "com.jcraft:jsch:0.1.23::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "compile" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar", "compile" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5::jar", "test" ) );
      addModel( model );

      model = toModel( "com.jcraft:jsch:0.1.23" );
      addModel( model );

      model = toModel( "plexus:plexus-utils:1.0.2" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0.3" ) );
      addModel( model );

      model = toModel( "plexus:plexus-root:1.0.3" );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar", "compile" ) );
      addModel( model );

      model = toModel( "org.codehaus.plexus:plexus-container-default:1.0-alpha-7" );
      model.setParentProject( toParent( "plexus:plexus-containers:1.0.2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "compile" ) );
      model.addDependency( toDependency( "plexus:plexus-utils:1.0.2::jar" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar" ) );
      addModel( model );

      model = toModel( "plexus:plexus-containers:1.0.2" );
      model.setParentProject( toParent( "plexus:plexus-root:1.0.3" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5" );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-file:1.0-alpha-5" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven.wagon:wagon-http-lightweight:1.0-alpha-5" );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar", "compile" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar", "compile" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      model.addDependency( toDependency( "servletapi:servletapi:2.3::jar", "test" ) );
      model.addDependency( toDependency( "classworlds:classworlds:1.1-alpha-2::jar", "test" ) );
      model.addDependency( toDependency( "jetty:jetty:4.2.10::jar", "test" ) );
      model.addDependency( toDependency( "plexus:plexus-jetty-httpd:1.0-beta-1::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-test:1.0-alpha-5::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-project:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-test:2.0::jar", "test" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-profile:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact-manager:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-test:2.0" );
      addModel( model );

      model = toModel( "org.apache.maven:maven-profile:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-model:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-model:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact-manager:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-repository-metadata:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-file:1.0-alpha-5::jar", "test" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      model.addDependency( toDependency( "org.apache.maven.wagon:wagon-provider-api:1.0-alpha-5::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-repository-metadata:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-artifact:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-utils:1.0.4::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar", "test" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-descriptor:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-plugin-api:2.0::jar" ) );
      model.addDependency( toDependency( "org.apache.maven:maven-artifact:2.0::jar" ) );
      model.addDependency( toDependency( "org.codehaus.plexus:plexus-container-default:1.0-alpha-8::jar" ) );
      addModel( model );

      model = toModel( "org.apache.maven:maven-plugin-api:2.0" );
      model.setParentProject( toParent( "org.apache.maven:maven:2.0" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      addModel( model );

      model = toModel( "org.slf4j:jcl104-over-slf4j:1.0.1" );
      addModel( model );

      model = toModel( "org.slf4j:slf4j-simple:1.0.1" );
      addModel( model );

      model = toModel( "mx4j:mx4j:3.0.1" );
      addModel( model );

      model = toModel( "mx4j:mx4j-tools:3.0.1" );
      addModel( model );

      model = toModel( "xerces:xercesImpl:${xerces-version}" );
      addModel( model );

      model = toModel( "commons-el:commons-el:1.0" );
      model.addDependency( toDependency( "servletapi:servletapi:2.4-20040521::jar", "provided" ) );
      model.addDependency( toDependency( "jspapi:jsp-api:2.0-20040521::jar", "provided" ) );
      model.addDependency( toDependency( "commons-logging:commons-logging:1.0.3::jar" ) );
      addModel( model );

      model = toModel( "servletapi:servletapi:2.4-20040521" );
      addModel( model );

      model = toModel( "jspapi:jsp-api:2.0-20040521" );
      addModel( model );

      model = toModel( "ant:ant:1.6.5" );
      dep = toDependency( "xerces:xerces-impl:2.6.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      dep = toDependency( "xml-apis:xml-apis:2.6.2::jar" );
      dep.setOptional( true );
      model.addDependency( dep );
      addModel( model );

      model = toModel( "xerces:xerces-impl:2.6.2" );
      addModel( model );

      model = toModel( "xml-apis:xml-apis:2.6.2" );
      addModel( model );

      model = toModel( "javax.mail:mail:1.4" );
      model.addDependency( toDependency( "javax.activation:activation:1.1::jar" ) );
      addModel( model );

      model = toModel( "javax.activation:activation:1.1" );
      addModel( model );

      model = toModel( "org.mortbay.jetty:jetty-util:6.0.2" );
      model.setParentProject( toParent( "org.mortbay.jetty:project:6.0.2" ) );
      model.addDependency( toDependency( "junit:junit:3.8.1::jar", "test" ) );
      model.addDependency( toDependency( "org.mortbay.jetty:servlet-api-2.5:6.0.2::jar", "provided" ) );
      addModel( model );

      model = toModel( "org.mortbay.jetty:servlet-api-2.5:6.0.2" );
      model.setParentProject( toParent( "org.mortbay.jetty:project:6.0.2" ) );
      addModel( model );

   }
}
