package org.mockito;

import java.util.*;

import junit.framework.TestCase;
import org.hamcrest.Matcher;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;
import org.mockito.stubbing.Answer;
import org.mockito.stubbing.DeprecatedOngoingStubbing;
import org.mockito.stubbing.OngoingStubbing;
import org.mockito.stubbing.Stubber;
import org.mockito.stubbing.VoidMethodStubbable;

public class MockitoTestCase extends TestCase {
	public MockitoTestCase() {
	}

	// /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Mockito

	/**
	 * @see org.mockito.Mockito#mock(Class)
	 */
	public Object mock(Class classToMock) {
		return Mockito.mock(classToMock);
	}

	/**
	 * @see org.mockito.Mockito#mock(Class, String)
	 */
	public Object mock(Class classToMock, String name) {
		return Mockito.mock(classToMock, name);
	}

	/**
	 * @deprecated
	 *
	 * @see org.mockito.Mockito#mock(Class, ReturnValues)
	 */
	public Object mock(Class classToMock, ReturnValues returnValues) {
		return Mockito.mock(classToMock, returnValues);
	}

	/**
	 * @see org.mockito.Mockito#mock(Class, Answer)
	 */
	public Object mock(Class classToMock, Answer defaultAnswer) {
		return Mockito.mock(classToMock, defaultAnswer);

	}

	/**
	 * @see org.mockito.Mockito#mock(Class, MockSettings)
	 */
	public Object mock(Class classToMock, MockSettings mockSettings) {
		return Mockito.mock(classToMock, mockSettings);
	}

	/**
	 * @see org.mockito.Mockito#spy(Object)
	 */
	public Object spy(Object object) {
		return Mockito.spy(object);
	}

	/**
	 * @see org.mockito.Mockito#stub(Object)
	 */
	public DeprecatedOngoingStubbing stub(Object methodCall) {
		return Mockito.stub(methodCall);

	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Object> when(Object o) {
		return Mockito.when(o);
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Byte> when(byte o) {
		return Mockito.when(Byte.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Short> when(short o) {
		return Mockito.when(Short.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Integer> when(int o) {
		return Mockito.when(Integer.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Long> when(long o) {
		return Mockito.when(Long.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Float> when(float o) {
		return Mockito.when(Float.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Double> when(double o) {
		return Mockito.when(Double.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Character> when(char o) {
		return Mockito.when(Character.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#when(Object)
	 */
	public OngoingStubbing<Boolean> when(boolean o) {
		return Mockito.when(Boolean.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#verify(Object)
	 */
	public Object verify(Object o) {
		return Mockito.verify(o);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object, VerificationMode)
	 */
	public Object verify(Object o, VerificationMode mode) {
		return Mockito.verify(o, mode);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object)
	 */
	public Collection verify(Collection o) {
		return (Collection) Mockito.verify(o);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object, VerificationMode)
	 */
	public Collection verify(Collection o, VerificationMode mode) {
		return (Collection) Mockito.verify(o, mode);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object)
	 */
	public List verify(List o) {
		return (List) Mockito.verify(o);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object, VerificationMode)
	 */
	public List verify(List o, VerificationMode mode) {
		return (List) Mockito.verify(o, mode);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object)
	 */
	public Set verify(Set o) {
		return (Set) Mockito.verify(o);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object, VerificationMode)
	 */
	public Set verify(Set o, VerificationMode mode) {
		return (Set) Mockito.verify(o, mode);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object)
	 */
	public Map verify(Map o) {
		return (Map) Mockito.verify(o);
	}

	/**
	 * @see org.mockito.Mockito#verify(Object, VerificationMode)
	 */
	public Map verify(Map o, VerificationMode mode) {
		return (Map) Mockito.verify(o, mode);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0) {
		Mockito.reset(mock0);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1) {
		Mockito.reset(mock0, mock1);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2) {
		Mockito.reset(mock0, mock1, mock2);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3) {
		Mockito.reset(mock0, mock1, mock2, mock3);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13, Object mock14) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13, Object mock14, Object mock15) {
		Mockito.reset(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14, mock15);
	}

	/**
	 * @see org.mockito.Mockito#reset(Object...)
	 */
	public void reset(Object[] mocks) {
		Mockito.reset(mocks);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0) {
		Mockito.verifyNoMoreInteractions(mock0);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1) {
		Mockito.verifyNoMoreInteractions(mock0, mock1);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13, Object mock14) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13, Object mock14, Object mock15) {
		Mockito.verifyNoMoreInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14, mock15);
	}

	/**
	 * @see org.mockito.Mockito#verifyNoMoreInteractions(Object...)
	 */
	public void verifyNoMoreInteractions(Object[] mocks) {
		Mockito.verifyNoMoreInteractions(mocks);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0) {
		Mockito.verifyZeroInteractions(mock0);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1) {
		Mockito.verifyZeroInteractions(mock0, mock1);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13, Object mock14) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
			Object mock10, Object mock11, Object mock12, Object mock13, Object mock14, Object mock15) {
		Mockito.verifyZeroInteractions(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14, mock15);
	}

	/**
	 * @see org.mockito.Mockito#verifyZeroInteractions(Object...)
	 */
	public static void verifyZeroInteractions(Object[] mocks) {
		Mockito.verifyZeroInteractions(mocks);
	}

	/**
	 * @deprecated
	 *
	 * @see org.mockito.Mockito#stubVoid(Object)
	 */
	public static VoidMethodStubbable stubVoid(Object mock) {
		return Mockito.stubVoid(mock);
	}

	/**
	 * @see org.mockito.Mockito#doThrow(Throwable)
	 */
	public Stubber doThrow(Throwable toBeThrown) {
		return Mockito.doThrow(toBeThrown);
	}

	/**
	 * @see org.mockito.Mockito#doCallRealMethod()
	 */
	public Stubber doCallRealMethod() {
		return Mockito.doCallRealMethod();
	}

	/**
	 * @see org.mockito.Mockito#doAnswer(Answer)
	 */
	public Stubber doAnswer(Answer a) {
		return Mockito.doAnswer(a);
	}

	/**
	 * @see org.mockito.Mockito#doNothing()
	 */
	public Stubber doNothing() {
		return Mockito.doNothing();
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(Object o) {
		return Mockito.doReturn(o);
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(byte o) {
		return Mockito.doReturn(Byte.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(short o) {
		return Mockito.doReturn(Short.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(int o) {
		return Mockito.doReturn(Integer.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(long o) {
		return Mockito.doReturn(Long.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(float o) {
		return Mockito.doReturn(Float.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(double o) {
		return Mockito.doReturn(Double.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(char o) {
		return Mockito.doReturn(Character.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#doReturn(Object)
	 */
	public Stubber doReturn(boolean o) {
		return Mockito.doReturn(Boolean.valueOf(o));
	}

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0) {
        return Mockito.inOrder(mock0);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1) {
        return Mockito.inOrder(mock0, mock1);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2) {
        return Mockito.inOrder(mock0, mock1, mock2);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
    		Object mock10) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
    		Object mock10, Object mock11) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
    		Object mock10, Object mock11, Object mock12) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
    		Object mock10, Object mock11, Object mock12, Object mock13) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
    		Object mock10, Object mock11, Object mock12, Object mock13, Object mock14) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object mock0, Object mock1, Object mock2, Object mock3, Object mock4, Object mock5, Object mock6, Object mock7, Object mock8, Object mock9,
    		Object mock10, Object mock11, Object mock12, Object mock13, Object mock14, Object mock15) {
        return Mockito.inOrder(mock0, mock1, mock2, mock3, mock4, mock5, mock6, mock7, mock8, mock9, mock10, mock11, mock12, mock13, mock14, mock15);
    }

	/**
	 * @see org.mockito.Mockito#inOrder(Object...)
	 */
    public static InOrder inOrder(Object[] mocks) {
        return Mockito.inOrder(mocks);
    }

	/**
	 * @see org.mockito.Mockito#times(int)
	 */
	public VerificationMode times(int numberOfTimes) {
		return Mockito.times(numberOfTimes);
	}

	/**
	 * @see org.mockito.Mockito#never()
	 */
	public VerificationMode never() {
		return Mockito.never();
	}

	/**
	 * @see org.mockito.Mockito#atLeastOnce()
	 */
	public VerificationMode atLeastOnce() {
		return Mockito.atLeastOnce();
	}

	/**
	 * @see org.mockito.Mockito#atLeast(int)
	 */
	public VerificationMode atLeast(int minNumberOfInvocations) {
		return Mockito.atLeast(minNumberOfInvocations);
	}

	/**
	 * @see org.mockito.Mockito#atMost(int)
	 */
	public VerificationMode atMost(int maxNumberOfInvocations) {
		return Mockito.atMost(maxNumberOfInvocations);
	}

	/**
	 * @see org.mockito.Mockito#only()
	 */
	public VerificationMode only() {
		return Mockito.only();
	}

	/**
	 * @see org.mockito.Mockito#timeout(int)
	 */
	public VerificationWithTimeout timeout(int millis) {
		return Mockito.timeout(millis);
	}

	/**
	 * @see org.mockito.Mockito#validateMockitoUsage()
	 */
	public void validateMockitoUsage() {
		Mockito.validateMockitoUsage();
	}

	/**
	 * @see org.mockito.Mockito#withSettings()
	 */
	public MockSettings withSettings() {
		return Mockito.withSettings();
	}

	// /////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Matchers

	/**
	 * @see org.mockito.Mockito#anyBoolean()
	 */
	public boolean anyBoolean() {
		return Mockito.anyBoolean();
	}

	/**
	 * @see org.mockito.Mockito#anyByte()
	 */
	public byte anyByte() {
		return Mockito.anyByte();
	}

	/**
	 * @see org.mockito.Mockito#anyChar()
	 */
	public char anyChar() {
		return Mockito.anyChar();
	}

	/**
	 * @see org.mockito.Mockito#anyInt()
	 */
	public int anyInt() {
		return Mockito.anyInt();
	}

	/**
	 * @see org.mockito.Mockito#anyLong()
	 */
	public long anyLong() {
		return Mockito.anyLong();
	}

	/**
	 * @see org.mockito.Mockito#anyFloat()
	 */
	public float anyFloat() {
		return Mockito.anyFloat();
	}

	/**
	 * @see org.mockito.Mockito#anyDouble()
	 */
	public double anyDouble() {
		return Mockito.anyDouble();
	}

	/**
	 * @see org.mockito.Mockito#anyShort()
	 */
	public short anyShort() {
		return Mockito.anyShort();
	}

	/**
	 * @see org.mockito.Mockito#anyObject()
	 */
	public Object anyObject() {
		return Mockito.anyObject();
	}

	/**
	 * @see org.mockito.Mockito#anyVararg()
	 */
	public Object anyVararg() {
		return Mockito.anyVararg();
	}

	/**
	 * @see org.mockito.Mockito#any(Class)
	 */
	public Object any(Class clazz) {
		return Mockito.any(clazz);
	}

	/**
	 * @see org.mockito.Mockito#any()
	 */
	public Object any() {
		return Mockito.any();
	}

	/**
	 * @see org.mockito.Mockito#anyString()
	 */
	public String anyString() {
		return Mockito.anyString();
	}

	/**
	 * @see org.mockito.Mockito#anyList()
	 */
	public List anyList() {
		return Mockito.anyList();
	}

	/**
	 * @see org.mockito.Mockito#anyListOf(Class)
	 */
	public List anyListOf(Class clazz) {
		return Mockito.anyListOf(clazz);
	}

	/**
	 * @see org.mockito.Mockito#anySet()
	 */
	public Set anySet() {
		return Mockito.anySet();
	}

	/**
	 * @see org.mockito.Mockito#anySetOf(Class)
	 */
	public Set anySetOf(Class clazz) {
		return Mockito.anySetOf(clazz);
	}

	/**
	 * @see org.mockito.Mockito#anyMap()
	 */
	public Map anyMap() {
		return Mockito.anyMap();
	}

	/**
	 * @see org.mockito.Mockito#anyCollection()
	 */
	public Collection anyCollection() {
		return Mockito.anyCollection();
	}

	/**
	 * @see org.mockito.Mockito#anyCollectionOf(Class)
	 */
	public Collection anyCollectionOf(Class clazz) {
		return Mockito.anyCollectionOf(clazz);
	}

	/**
	 * @see org.mockito.Mockito#isA(Class)
	 */
	public Object isA(Class clazz) {
		return Mockito.isA(clazz);
	}

	/**
	 * @see org.mockito.Mockito#eq(boolean)
	 */
	public boolean eq(boolean value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(byte)
	 */
	public byte eq(byte value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(char)
	 */
	public char eq(char value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(double)
	 */
	public double eq(double value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(float)
	 */
	public float eq(float value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(int)
	 */
	public int eq(int value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(long)
	 */
	public long eq(long value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(short)
	 */
	public short eq(short value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#eq(Object)
	 */
	public Object eq(Object value) {
		return Mockito.eq(value);
	}

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value) {
        return Mockito.refEq(value);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0) {
        return Mockito.refEq(value, excludeField0);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1) {
        return Mockito.refEq(value, excludeField0, excludeField1);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9,
    		String excludeField10) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9,
        		excludeField10);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9,
    		String excludeField10, String excludeField11) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9,
        		excludeField10, excludeField11);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9,
    		String excludeField10, String excludeField11, String excludeField12) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9,
        		excludeField10, excludeField11, excludeField12);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9,
    		String excludeField10, String excludeField11, String excludeField12, String excludeField13) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9,
        		excludeField10, excludeField11, excludeField12, excludeField13);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9,
    		String excludeField10, String excludeField11, String excludeField12, String excludeField13, String excludeField14) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9,
        		excludeField10, excludeField11, excludeField12, excludeField13, excludeField14);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String excludeField0, String excludeField1, String excludeField2, String excludeField3, String excludeField4, String excludeField5, String excludeField6, String excludeField7, String excludeField8, String excludeField9,
    		String excludeField10, String excludeField11, String excludeField12, String excludeField13, String excludeField14, String excludeField15) {
        return Mockito.refEq(value, excludeField0, excludeField1, excludeField2, excludeField3, excludeField4, excludeField5, excludeField6, excludeField7, excludeField8, excludeField9,
        		excludeField10, excludeField11, excludeField12, excludeField13, excludeField14, excludeField15);
    }

	/**
	 * @see org.mockito.Mockito#refEq(Object, String...)
	 */
    public static Object refEq(Object value, String[] excludeFields) {
        return Mockito.refEq(value, excludeFields);
    }

	/**
	 * @see org.mockito.Mockito#same(Object)
	 */
	public Object same(Object o) {
		return Mockito.same(o);
	}

	/**
	 * @see org.mockito.Mockito#isNull()
	 */
	public Object isNull() {
		return Mockito.isNull();
	}

	/**
	 * @see org.mockito.Mockito#isNotNull()
	 */
	public Object isNotNull() {
		return Mockito.isNotNull();
	}

	/**
	 * @see org.mockito.Mockito#contains(String)
	 */
	public String contains(String substring) {
		return Mockito.contains(substring);
	}

	/**
	 * @see org.mockito.Mockito#matches(String)
	 */
	public String matches(String regex) {
		return Mockito.matches(regex);
	}

	/**
	 * @see org.mockito.Mockito#endsWith(String)
	 */
	public String endsWith(String suffix) {
		return Mockito.endsWith(suffix);
	}

	/**
	 * @see org.mockito.Mockito#startsWith(String)
	 */
	public String startsWith(String s) {
		return Mockito.startsWith(s);
	}

	/**
	 * @see org.mockito.Mockito#argThat(Matcher)
	 */
	public Object argThat(Matcher arg) {
		return Mockito.argThat(arg);
	}

	/**
	 * @see org.mockito.Mockito#charThat(Matcher)
	 */
	public char charThat(Matcher arg0) {
		return Mockito.charThat(arg0);
	}

	/**
	 * @see org.mockito.Mockito#booleanThat(Matcher)
	 */
	public boolean booleanThat(Matcher matcher) {
		return Mockito.booleanThat(matcher);
	}

	/**
	 * @see org.mockito.Mockito#byteThat(Matcher)
	 */
	public byte byteThat(Matcher arg) {
		return Mockito.byteThat(arg);
	}

	/**
	 * @see org.mockito.Mockito#shortThat(Matcher)
	 */
	public short shortThat(Matcher matcher) {
		return Mockito.shortThat(matcher);
	}

	/**
	 * @see org.mockito.Mockito#intThat(Matcher)
	 */
	public int intThat(Matcher matcher) {
		return Mockito.intThat(matcher);
	}

	/**
	 * @see org.mockito.Mockito#longThat(Matcher)
	 */
	public long longThat(Matcher matcher) {
		return Mockito.longThat(matcher);
	}

	/**
	 * @see org.mockito.Mockito#floatThat(Matcher)
	 */
	public float floatThat(Matcher matcher) {
		return Mockito.floatThat(matcher);
	}

	/**
	 * @see org.mockito.Mockito#doubleThat(Matcher)
	 */
	public double doubleThat(Matcher matcher) {
		return Mockito.doubleThat(matcher);
	}

}
