<?php
/**
 * @copyright
 *  現在の電力使用状況
 *  設定値を超えたら、ユーザーに配信する。 
 */


chdir(dirname(__FILE__));
include "./include/header.php";
include "./include/web_api.php";
include "./include/function.php";
require("./include/phpmailer/class.phpmailer.php");

$ret =array();
$record =array();

$mail_template =array();

foreach ($ELECTRICPOWER_URL as $key => $value){
	$ret = get_supplypower_api($key);
	$ret["name"]=$value; // 会社名
	$ret["rate"] = round ( ($ret[NOW_USE_POWER] * 100 ) / $ret[PEAK_HOUR_SUPPLY]); //　現在の使用率
	$ret["now_use_time"] = $ret[NOW_USE_TIME] ; //　現在の時刻
	$ret["use"]=$ret[NOW_USE_POWER] ; //　現使用量
	$ret["max"]=$ret[ PEAK_HOUR_SUPPLY ]; //　供給量
	$ret["expected_max_power"]=$ret[ EXPECTED_MAX_POWER ]; //　最大使用量
	$ret["expected_max_time"]=$ret[ EXPECTED_MAX_TIME ]; //　時間帯
	$ret["max_rate"] = round ( ($ret[EXPECTED_MAX_POWER] * 100 ) / $ret[PEAK_HOUR_SUPPLY]); //　最大使用量
	$record[$value]=$ret; //
}
//phpemaillist_messagesに送信する本文作成


foreach ($ELECTRICPOWER_DARY_MAIL_TEMPLATE as $key => $value){

   $smarty->assign("name",$key); 
   $smarty->assign("rate",$record[$key]["rate"]); 
   $smarty->assign("now_use_power",$record[$key][NOW_USE_POWER]); 

   $smarty->assign("now_use_time",$record[$key][NOW_USE_TIME]); 

   $smarty->assign("max",$record[$key][PEAK_HOUR_SUPPLY]); 
   $smarty->assign("max_rate",$record[$key]["max_rate"]); 
   $smarty->assign("expected_max_power",$record[$key]["expected_max_power"]); 
   $smarty->assign("expected_max_time",$record[$key]["expected_max_time"]); 

   $smarty->assign("max_use",$record[$key]["max_rate"]); 

   //$url = "http://". $_SERVER['SERVER_NAME']."/".RCV_REGIST_URL."?n=".$n;
   //$smarty->assign("url",$url); 

   //$unlink = "http://". $_SERVER['SERVER_NAME']."/".RCV_UNREGIST_URL."?n=".$n;
   //$smarty->assign("unlink",$unlink);

   $mail_template[$key] = $smarty->fetch($value); //メールのテンプレートをSmartyで読み込む
}



 //print_r($mail_template);
 //exit;
 
// 送信記録をget 
$send_mail = array(); // 送信済みのメールアドレス
$csv_file = LOG_DIR .LOG_MAIL_SEND. date("Ymd").LOG_MAIL_SEND_EXT;
$row = 1;

if (file_exists($csv_file)) {
	$handle = fopen($csv_file, "r");
	if($handle ){
		while (($data = fgetcsv($handle, 2000, ",")) !== FALSE) {
            $i = $data[0];
            $data1 = array_shift($data);
    		$send_mail[$i ] =$data;
		}
	fclose($handle);
	}
}




$state =OFFICIAL_MEMBER;// 正会員
$sql=<<<SQL
    select 
	phpemaillist_subscribers.id as id ,
	phpemaillist_subscribers.email as  email,
	phpemaillist_subscribers.listid as listid  ,
	phpemaillist_subscribers.limit_MAX as  limit_MAX ,
	phpemaillist_subscribers.limit_MIN as limit_MIN ,
	phpemaillist_subscribers.state as  state,
	phpemaillist_subscribers.type as  type,
	phpemaillist_subscribers.uniqNO as uniqNO,  
	phpemaillist_subscribers.date as date,
	phpemaillist_lists.title as title 
     from phpemaillist_subscribers,phpemaillist_lists where
    phpemaillist_lists.id=phpemaillist_subscribers.listid 
    and phpemaillist_subscribers.state=$state
      ;
SQL;

 $result=mysql_query($sql) or die("Unable to execute query $result".$sql);

 
 
 //print_log("\n debug1" .print_r($send_mail,true));
    		
//$fp = fopen($csv_file, 'a');
 while($row=mysql_fetch_array($result)){
 
  // 
  if(empty($send_mail[ $row["id"]]) ){   
     $body=$mail_template[$row["title"]];

   // 規定値超え
	if($row["limit_MAX"] < $record[$row["title"]]["rate"] ){
   	// 退会URL
	   	$unlink = "http://kinken48.com/".RCV_UNREGIST_URL."?n=".$row["uniqNO"];
   		$body = str_replace("(unlink)", $unlink, $body);
   		sendEmail($row["email"], "電力使用状況のお知らせ", $body, "");
   		print_log($row["email"] ."宛に規定値超通知");
   		// 送信記録
   		$str= $row["email"] .",".date("Ymd H:i:s")."\n";
   		$r=array();
   		$r[]=$row["email"] ;
   		$r[]=date("Ymd H:i:s");
   		$send_mail[$row["id"]] =$r;
   		// fwrite($fp, $str);
	}
   } else {
   	//print_log($row["email"] ."宛に配信済み");
   }
  //
    if(! empty($send_mail[ $row["id"]]) ){   
     $body=$mail_template[$row["title"]];
     // 規定値以下 s
     if($row["limit_MAX"] >= $record[$row["title"]]["rate"] ){
   	// 退会URL
	   	$unlink = "http://kinken48.com/".RCV_UNREGIST_URL."?n=".$row["uniqNO"];
   		$body = str_replace("(unlink)", $unlink, $body);
   		sendEmail($row["email"], "電力使用状況のお知らせ", $body, "");
   		print_log($row["email"] ."宛に規定値以下通知");
   		//fwrite($fp, $str);
        //  送信記録リストから削除
        unset ( $send_mail[ $row["id"]] );
 	}
   } else {
   	//print_log($row["email"] ."宛に配信済み");

   }
  //
  
  

     
  }

//
//   		print_log("\n debug" .print_r($send_mail,true));


$fp = fopen($csv_file, 'w');
foreach( $send_mail as $key => $value ){
   	$str= $key ."," .  implode( ",",$value) . " \n";
   fwrite($fp, $str);
}

fclose($fp);




exit;



function sendEmail($email, $subject, $main, $footer){
    $body=HEADER;
    $body.=$main;
    $body.=$footer;
    //    print "<br>$email";
    $mail = new PHPMailer();
    $mail->CharSet = "iso-2022-jp";
    $mail->From = FROM;
    $mail->FromName = mb_encode_mimeheader(mb_convert_encoding("denkiletter","JIS","AUTO"));
    $mail->AddAddress("$email");
    $mail->IsHtml(false);
    $mail->Subject = mb_encode_mimeheader(mb_convert_encoding($subject,"JIS","AUTO"));
    $body = mb_convert_encoding($body,"JIS","AUTO");
    $mail->Body    = $body;

    $mail->Send();
}





?>
