<?php
/*
* サブ関数
*
*/


define("CNV_DATE" , 1);
define("CNV_DATETIME" , 2);

;
// pager()関数ここから

function pager($idname,$countRe){
    $id =$_GET[$idname];
    // ページ情報以外のパラメータを補完し、$other_paramにセット
    foreach($_GET as $key => $value){
        // $idname 以外のGETメソッドのパラメータを $other_param に再構築
        if ($key != $idname){
            // リンクさせるためにurlencodeする.
            $other_param .= "&".$key."=".urlencode($value);
        }
    }
    // ページ数の指定がなければページ数を1にセット
    if($id=="") $id=1;
    // 最終ページを計算する
    // 総Hit数をページング単位で割ると総ページ数が計算される
    // ページング単位PER_PAGEを10とすると最終ページ数$maxPageは
    // 総Hit数 / PER_PAGEを切り上げたものとなる。
    // 検索結果205件 PER_PAGE:10の場合 $maxPage = ceil(205 / 10) = 21
    $maxPage=ceil($countRe / PER_PAGE);
    // maxPage=1の場合(PER_PAGEより少ない検索結果)
    // 選択したページ数(id)よりもmaxPageが小さいときはfalse
    if( ($maxPage == 1) or ($maxPage < $id) ) return false;
    // 選択したページ数がVIEW_PAGE_MENU_WIDTHより大きいとき
    if($id > VIEW_PAGE_MENU_WIDTH + 1){
        // スタートページは選択ページからVIEW_PAGE_MENU_WIDTHを
        // 引いたもの程度出せばよい
        $startPage = $id - VIEW_PAGE_MENU_WIDTH;
        // より小さいもの「 < 」の部分はさらにその$startPageから1を引いたもの
        $startMore = "<a href=\"$PHP_SELF?".$idname."=".($startPage - 1).$other_param."\">".PREV_MARK." </a>";
    }else{
        // そうでなければ$startPage=1(一番はじめのページ = 1)になる
        $startPage = 1;
    }
    // 選択したページ数に5を足したものより、更に$maxPage
    // （最大ページ)が大きければ
    if($id + VIEW_PAGE_MENU_WIDTH < $maxPage){
        // 表示される最終ページは選択したページに
        // VIEW_PAGE_MENU_WIDTHを足したものになる
        $endPage = $id + VIEW_PAGE_MENU_WIDTH;
        $endMore = " <a href=\"$PHP_SELF?".$idname."=".($endPage + 1).$other_param."\"> ".NEXT_MARK."</a>";
    }else{
        // そうでなければ、$endPageは最終ページになる
        $endPage = $maxPage;
    }
    // ここまでで、計算されたのは
    // $id        : 現在選択しているページ番号
    // $maxPage   : 検索の最終ページ
    // $startPage : 表示されるはじめのページ
    // $endPage   : 表示される最後のページ
    // $page_footer="" として$page_footerを初期化
    $page_footer="";
    // $startPage から $endPageまで繰り返し
    for($i = $startPage ; $i <= $endPage ; $i++){
        // $i = $idだったら選択されたページなので、fontsizeを大きくする
        // その際、リンクはなし
        // そうでなければ、id=$iをリンクにセットする
        $page_footer.= " ".(($id==$i)?"<span style='font-Size:120%'>$i</span>":"<a href=\"$PHP_SELF?$idname=$i$other_param\">$i</a>");
    }
    // $startMoreと$endMoreを$page_footerの前後に付け足す
    $page_footer = $startMore.$page_footer.$endMore;
    // $page_footerを表示
    print $page_footer;
}


define( "ONE_DAY_SEC", 24 * 3600 );

// 日付けの差分をとる関数
function dateDiff( $date1, $date2 ) {
    return ( strtotime( $date1) - strtotime( $date2 ) ) / ONE_DAY_SEC;
}


// 時間の差分をとる関数
function timeDiff( $time1, $time2 ) {
    // strtotime("0:0:0") を足して localtime を補正
    return date( "H:i:s", strtotime( $time1 ) - strtotime( $time2 )  + strtotime("0:0:0"));
}





function dbdate2date( $dbdate , $cnv=CNV_DATE )
{
	switch( $cnv ){
		case	CNV_DATE:
			$date_str =  preg_replace("/(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/","\\1/\\2/\\3 " , $dbdate );
			break;
		case	CNV_DATETIME:
			$date_str = preg_replace("/(\d\d\d\d)(\d\d)(\d\d)(\d\d)(\d\d)(\d\d)/","\\1/\\2/\\3 \\4:\\5" , $dbdate );
			break;
	}
	return $date_str;
}



	/*
		画像タグ
		をリサイズしてタグ生成

		$width=80 ,height=80,$file_path, $title="",$href""
	
	*/
function set_image_tag_ref( $width_src=80 ,$height_src=80,$file_path, $title="",$href="",$style=""){
			$a_path=$file_path;

			if(substr($file_path,0,1)=="/"){
				$a_path =$_SERVER['DOCUMENT_ROOT'].$file_path;
			} 

			list($height,$width,$type,$width_height) = getimagesize($a_path);

			if( empty($width) || empty($height) ){
				$width = 50;
				$height = 50;
				$photo_size = 150;
				$alt = ' alt="file damage"';
				$title = ' title="file damage"';
			}

			// サイズオーバー
			//横サイズ基準
			if( ($width > $width_src)   ||  ($height >height_src)   ){
				$r = $width/($width_src) ;
				$h = round (  $height / $r );
				$w=$width_src ;
			}

	$str_img_tag="<img $style src=\"$file_path\" border=\"0\" width=\"$w\" height=\"$h\" alt= \"$title\" title=\"$title\" >\n";
	if($href){
			$str_img_tag="<a href=$href>".$str_img_tag."</a>";
		}
			return $str_img_tag;

}


	/*
		画像タグ
	*/
function set_image_tag( $photo_size=1500 ,$file_path, $style=""){
			$a_path=$file_path;
			if(substr($file_path,0,1)=="/"){
				$a_path =$_SERVER['DOCUMENT_ROOT'].$file_path;
			} 
			list($height,$width,$type,$width_height) = getimagesize($a_path);
			$alt = "";
			$title = ' title="CLICK  "';
			if( empty($width) || empty($height) ){
				$width = 150;
				$height = 120;
				$photo_size = 150;
				$alt = ' alt="file damage"';
				$title = ' title="file damage"';
			}
			$r =1;
			if( ($width * $height) > $photo_size){
					$r = ($width * $height) / $photo_size;
				$w = round (  $width / $r );
				$h = round (  $height / $r) ;
			} else {
					$w =  $width ;
					$h =  $height ;
				}

					$w =  $width ;
					$h =  $height ;

			return <<<___
<img $style src="$file_path" border="0" width="$w" height="$h" $alt $title >
___;

}


// ディレクトリをオープンし、その中のゴミファイルを削除
// ディレクトリをオープンし、その中のゴミファイルを削除
function del_file($dir) {
//	echo $dir;
	if ($handle = opendir("$dir")) {
  	  while (false !== ($file = readdir($handle))) {
    	    if ($file != "." && $file != "..") {
				    if(date ("F d Y ", filemtime("${dir}${file}")) != date ("F d Y ") ) {
						if( substr($file,0,3) == "TMP" ){
								unlink("${dir}${file}");
						 }

						}
        	}
	    }
    closedir($handle);
	}
}

 function valid_mail($email) // 正しい書式のメールアドレスの場合は、1 を返す
{
if(preg_match('/^(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|"[^\\\\\x80-\xff\n\015"]*(?:\\\\[^\x80-\xff][^\\\\\x80-\xff\n\015"]*)*")(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|"[^\\\\\x80-\xff\n\015"]*(?:\\\\[^\x80-\xff][^\\\\\x80-\xff\n\015"]*)*"))*@(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[^\x80-\xff])*\])(?:\.(?:[^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff]+(?![^(\040)<>@,;:".\\\\\[\]\000-\037\x80-\xff])|\[(?:[^\\\\\x80-\xff\n\015\[\]]|\\\\[^\x80-\xff])*\]))*$/', $email)) return 1;
}


// DBからのデータをEUC->utf8に変換して、HTMLにエンコード
function  ArrayDB2str($Quote_data) { 
	$a=Array();
	foreach($Quote_data as $key => $value)
	{
//		$value= mb_convert_encoding($value, 'utf8', 'EUC');
		$a[$key]= htmlspecialchars($value,ENT_QUOTES);
	}	
   return($a); 
}


// 配列をシングルクォートで囲む　ABCD--＞　'ABCD'
function Array_Quote($Quote_data) { 
	$a=Array();
	foreach($Quote_data as $key => $value)
	{
		$i= addslashes($value);
		$a[$key]= "'".$i."'";
	}	
   return($a); 
}



// N桁の英語、数字のパスワードをランダムに作成 
function MakePasswd_N ($N) { 
	$aa="";
	for($ii=0 ;$ii<$N; $ii++) { 
		$i[] = MakePasswdsub();
 	$aa=$aa.$i[$ii]; 
	}
   return $aa ; 
}




function MakePasswdsub() { 
  mt_srand((double)microtime()*1000000);
  $kazu1 =mt_rand(0,2);

  if ($kazu1 ==2) {
    $kazu = mt_rand(0,10);
  } else {
    $kazu = mt_rand(0,25);
  }  
  $ar[] =array ("a","b","c","d","e","f","g","h","i","j","k","l","m","n",
                "o","p","q","r","s","t","u","v","w","x","y","z"); 

  $ar[] =array ("A","B","C","D","E","F","G","H","I","J","K","L","M","N",
                "O","P","Q","R","S","T","U","V","W","X","Y","Z"); 

  $ar[] =array (0,1,2,3,4,5,6,7,8,9,0); 
  return $ar[$kazu1][$kazu]; 
} 



?>

 