<?php

/* ========================================================================
 *
 * @license This source file is subject to version 3.01 of the PHP license,
 *                      that is available at http://www.php.net/license/3_01.txt
 *                      If you did not receive a copy of the PHP license and are unable
 *                      to obtain it through the world-wide-web, please send a note to
 *                      license@php.net so we can mail you a copy immediately.
 *
 * @category   Application of MyNETS
 * @project    OpenPNE UsagiProject 2006-2007
 * @package    MyNETS
 * @author     UsagiProject <info@usagi.mynets.jp>
 * @copyright  2006-2007 UsagiProject <author member ad http://usagi.mynets.jp/member.html>
 * @version    MyNETS,v 1.0.0
 * @since      File available since Release 1.0.0 Nighty
 * @chengelog  [2007/04/14] Ver1.0.1Nighty package
 * ========================================================================
 */

function smarty_modifier_t_mapurl($string)
{
  if (CHECK_KTAI_UA && !isKtaiUserAgent())
    return $string;
// "(&quot;) と '(&#039;) を元に戻す
  $search = array('&quot;', '&#039;');
  $replace = array('"', "'");

  $url_pattern = '/http:\/\/walk\.eznavi\.jp\/map\/\?([^\s]+)/i';
  $string = preg_replace_callback($url_pattern, 'smarty_modifier_t_eznavi_callback', $string);
  $url_pattern = '/http:\/\/docomo\.ne\.jp\/cp\/map\.cgi\?([^\s]+)/i';
  $string = preg_replace_callback($url_pattern, 'smarty_modifier_t_docomo_callback', $string);
  $url_pattern = '/&lt;cmd\s+src="gmaps"\s+args="([\w\-\+%]+(,[\w\-\+%]+)*)"\s*&gt;/i';
  $string = preg_replace_callback($url_pattern, 'smarty_modifier_t_cmd_callback', $string);
  $url_pattern = '/http:\/\/(?:maps|www)\.google\.(?:co\.jp|com)\/(?:map[sph]|)\?([^\s]+)/i';
  return preg_replace_callback($url_pattern, 'smarty_modifier_t_google_callback', $string);
}

function smarty_modifier_t_eznavi_callback($matches)
{
/*
*
* Covert from eznavi to eznavi
*http://walk.eznavi.jp/map/?datum=0&unit=0&lat=%2b36.17.42.47&lon=%2b139.48.27.86&fm=0
*http://walk.eznavi.jp/map/?datum=0&unit=0&lat=%2b36.17.42.47&lon=%2b139.48.27.86&fm=0
*
*
*/
    $url = 'http_://walk.eznavi.jp/map/?' . $matches[1];
    return "<a href=\"t.php?$url\" _blank><img src=\"gmaps/mapon.gif\"/></a>";
}

function smarty_modifier_t_cmd_callback($matches)
{
/*
*
* Covert from google&cmd to eznavi
*<cmd src="gmaps" args="16,35,687168,139,757412">
*http://walk.eznavi.jp/map/?datum=0&unit=0&lat=%2b36.17.42.47&lon=%2b139.48.27.86&fm=0
*
*
*/
    $args = $matches[1];

    $_args = explode(',', $args);

    $zoom = 300*pow(2,17-$_args[0]);
    if($zoom == 600) $zoom = 690;
    if($zoom == 153600) $zoom = 230230;
    $lat = $_args[1].'.'.$_args[2];
    $lon = $_args[3].'.'.$_args[4];
    $lat = rconvert($lat);
    $lon = rconvert($lon);
    $url = 'http_://walk.eznavi.jp/map/?datum=0&amp;unit=0&amp;lat=%2b'
 . $lat . '&amp;lon=%2b' . $lon . '&amp;fm=0';
    return "<a href=\"t.php?$url\" _blank><img src=\"gmaps/mapon.gif\"/></a>";
}

function smarty_modifier_t_google_callback($matches)
{
/*
*
* Covert from googlemap to eznavi
*http://maps.google.co.jp/?t=k&om=1&ie=UTF8&ll=13.41233,103.866806&spn=0.00334,0.003363
*http://walk.eznavi.jp/map/?datum=0&unit=0&lat=%2b36.17.42.47&lon=%2b139.48.27.86&fm=0
*
*
*/
  $param = array();
  $d =  explode("&amp;",$matches[1]);
  for($i=0;$i<count($d);$i++) {
    $e = explode("=",$d[$i]);
    if(count($e)==2)
      $param[$e[0]]=$e[1];
  }
  if(empty($param['ll']))
    return $matches[0];
  $v = explode(",",$param['ll']);
  $lat = rconvert($v[0]);
  $lon = rconvert($v[1]);
  $url = 'http_://walk.eznavi.jp/map/?datum=0&amp;unit=0&amp;lat=%2b'
 . $lat . '&amp;lon=%2b' . $lon . '&amp;fm=0';
    return "<a href=\"t.php?$url\" _blank><img src=\"gmaps/mapon.gif\"/></a>";

}
function rconvert($id)
{
    $nd1 = intval($id); $id=($id-$nd1)*60.0;
    $nd2 = intval($id); $id=($id-$nd2)*60.0;
    $nd3 = intval($id); $id=($id-$nd3)*100.0;
    $nd4 = intval($id);
    return sprintf("%d.%02d.%02d.%02d",$nd1,$nd2,$nd3,$nd4);
}
function smarty_modifier_t_docomo_callback($matches)
{
/*
*
* Covert from docomo to eznavi
*http://docomo.ne.jp/cp/map.cgi?&lat=%2B36.05.35.981&lon=%2B140.06.14.969&geo=WGS84&alt=%2B64.000&x-acc=1
*http://walk.eznavi.jp/map/?datum=0&unit=0&lat=%2b36.17.42.47&lon=%2b139.48.27.86&fm=0
*
*
*/
  $param = array();
  $d =  split("&amp;",$matches[1]);
  for($i=0;$i<count($d);$i++) {
    $e = explode("=",$d[$i]);
    if(count($e)==2)
      $param[$e[0]]=$e[1];
  }

  $url = 'http_://walk.eznavi.jp/map/?datum=0&amp;unit=0&amp;lat='
 . $param['lat'] . '&amp;lon=' . $param['lon'] . '&amp;fm=0';
    return "<a href=\"t.php?$url\" _blank><img src=\"gmaps/mapon.gif\"/></a>";
}
?>
