/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_php.h"
#include "cd_define.h"

Php php;

/*
 * cd_php_init
 */
gboolean cd_php_init(PgDialog *pd)
{
  sprintf(php.dir, "%s", gtk_entry_get_text((GtkEntry*)pd->ap.pub_entry));

  if(mkdir(php.dir, 0755)){
    cd_util_message(ERR_CREATE_PJ);
    return FALSE;
  }

  sprintf(php.index,  "%s/index.html",  php.dir);
  sprintf(php.class,  "%s/class.php3",  php.dir);
  sprintf(php.list,   "%s/list.html",   php.dir);
  sprintf(php.about,  "%s/about.html",  php.dir);
  sprintf(php.select, "%s/select.php3", php.dir);
  sprintf(php.insert, "%s/insert.php3", php.dir);
  sprintf(php.delete, "%s/delete.php3", php.dir);
  sprintf(php.select_for_update, "%s/select_for_update.php3", php.dir);
  sprintf(php.update, "%s/update.php3", php.dir);

  php.serial = FALSE;

  {
    int i;
    int attr_len;
    PgAttribute *attr;

    attr_len = g_list_length(pd->ni->attributes);
    for(i=0; i<attr_len; i++){
      attr = g_list_nth_data(pd->ni->attributes, i);
      if(attr->type == pg_serial)
	php.serial = TRUE;
    }
  }

  return TRUE;
}

/*
 * cd_php_generate_index
 */
void cd_php_generate_index(PgDialog *pd)
{
  FILE *fp;

  if((fp = fopen(php.index, "w")) == NULL){
    g_print(ERR_OPEN_FILE , php.index);
    return;
  }

  fprintf(fp, HTML_INDEX, pd->ni->name);

  fclose(fp);
}

/*
 * cd_php_generate_list
 */
void cd_php_generate_list(PgDialog *pd)
{
  FILE *fp;

  if((fp = fopen(php.list, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.list);
    return;
  }

  if(php.serial)
    fprintf(fp, HTML_LIST_UPDATE, pd->ni->name);
  else
    fprintf(fp, HTML_LIST_NORMAL, pd->ni->name);

  fclose(fp);
}

/*
 * cd_php_generate_about
 */
void cd_php_generate_about(PgDialog *pd)
{
  FILE *fp;

  if((fp = fopen(php.about, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.about);
    return;
  }

  if(php.serial)
    fprintf(fp, HTML_ABOUT_UPDATE, pd->ni->name, pd->ni->name);
  else
    fprintf(fp, HTML_ABOUT_NORMAL, pd->ni->name, pd->ni->name);

  fclose(fp);
}

/*
 * cd_php_generate_class_update
 */
void cd_php_generate_class_update(PgDialog *pd, FILE *fp)
{
  int i;
  int attr_len;
  PgAttribute *attr;

  fprintf(fp, PHP_CLASS_UPDATE1);

  attr_len = g_list_length(pd->ni->attributes);
  for(i=0; i<attr_len; i++){
    attr = g_list_nth_data(pd->ni->attributes, i);
    if(attr->type == pg_serial)
      fprintf(fp, PHP_CLASS_UPDATE2_SERIAL,
	      i, attr->name, attr->name, attr->name);
    else
      fprintf(fp, PHP_CLASS_UPDATE2_NORMAL, attr->name);
  }

  fprintf(fp, PHP_CLASS_UPDATE3);
}

/*
 * cd_php_generate_class
 */
void cd_php_generate_class(PgDialog *pd)
{
  FILE *fp;
  gchar *db;

  if((fp = fopen(php.class, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.class);
    return;
  }

  db = gtk_entry_get_text((GtkEntry*)pd->cp.entrys[0]);

  /* initial */
  fprintf(fp, PHP_CLASS_INIT,
	  pd->ni->name, pd->ni->name, pd->ni->name, db);

  /* select */
  fprintf(fp, PHP_CLASS_SELECT1);
  {
    int i;
    int attr_len;
    PgAttribute *attr;

    attr_len = g_list_length(pd->ni->attributes);
    for(i=0; i<attr_len; i++){
      attr = g_list_nth_data(pd->ni->attributes, i);
      fprintf(fp, PHP_CLASS_SELECT2, attr->name);
    }
  }
  fprintf(fp, PHP_CLASS_SELECT3);

  /* insert */
  fprintf(fp, PHP_CLASS_INSERT);

  /* delete */
  fprintf(fp, PHP_CLASS_DELETE);

  /* update */
  if(php.serial)
    cd_php_generate_class_update(pd, fp);

  fprintf(fp, PHP_CLASS_TERM);
      
  fclose(fp);
}

/*
 * cd_php_generate_select
 */
void cd_php_generate_select(PgDialog *pd)
{
  FILE *fp;

  if((fp = fopen(php.select, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.select);
    return;
  }

  fprintf(fp, PHP_APP_SELECT, pd->ni->name);
  fclose(fp);
}

/*
 * cd_php_generate_insert
 */
void cd_php_generate_insert(PgDialog *pd)
{
  FILE *fp;

  if((fp = fopen(php.insert, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.insert);
    return;
  }

  fprintf(fp, PHP_APP_INSERT, pd->ni->name);
  fclose(fp);
}

/*
 * cd_php_generate_delete
 */
void cd_php_generate_delete(PgDialog *pd)
{
  FILE *fp;

  if((fp = fopen(php.delete, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.delete);
    return;
  }

  fprintf(fp, PHP_APP_DELETE, pd->ni->name);
  fclose(fp);
}

/*
 * cd_php_generate_update
 */
void cd_php_generate_update(PgDialog *pd)
{
  FILE *fp1, *fp2;

  if((fp1 = fopen(php.select_for_update, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.select_for_update);
    return;
  }
  if((fp2 = fopen(php.update, "w")) == NULL){
    g_print(ERR_OPEN_FILE, php.update);
    return;
  }

  fprintf(fp1, PHP_APP_SELECT_FOR_UPDATE, pd->ni->name);
  fprintf(fp2, PHP_APP_UPDATE, pd->ni->name);

  fclose(fp1);
  fclose(fp2);
}

/*
 * cd_php_generate
 */
void cd_php_generate(PgDialog *pd)
{
  if(!cd_php_init(pd))
    return;

  cd_php_generate_index(pd);
  cd_php_generate_list(pd);
  cd_php_generate_about(pd);

  cd_php_generate_class(pd);
  cd_php_generate_select(pd);
  cd_php_generate_insert(pd);
  cd_php_generate_delete(pd);

  if(php.serial)
    cd_php_generate_update(pd);
}
