/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef CD_NODE_H
#define CD_NODE_H

#include <stdio.h>
#include <gtk/gtk.h>

#include "cd_define.h"
#include "cd_arc.h"

typedef struct _Attribute   Attribute;
typedef struct _Operation   Operation;
typedef struct _PgAttribute PgAttribute;
typedef struct _PgOperation PgOperation;
typedef struct _PgData      PgData;
typedef struct _NodeItem    NodeItem;
typedef struct _Node        Node;

struct _Attribute
{
  char name[64];
  CdVisibility vis;
};

struct _Operation
{
  char name[64];
  CdVisibility vis;
};

struct _PgAttribute
{
  char name[64];
  CdVisibility vis;
  CdPgType type;
};

struct _PgOperation
{
  char name[64];
  CdVisibility vis;
  CdPgType type;
};

struct _PgData
{
  char host[64];
  char port[8];
  char options[32];
  char tty[32];
  char db[64];
};

struct _NodeItem
{
  int id;
  GdkRectangle rect;

  char name[64];
  GdkPoint name_point;

  GList *attributes;
  int attr_y;

  GList *operations;
  int op_y;

  gboolean select;

  CdKind kind;
  void *data;
};

struct _Node
{
  int count;
  int seq;
  int selecting;
  int selected;

  NodeItem item[CD_NODE_ITEM_MAX];
};

void cd_node_item_init(int i);
void cd_node_item_new(int i, int x, int y, CdKind kind);
void cd_node_item_copy(int dst, int src);
void cd_node_item_move(int dx, int dy);
void cd_node_item_escape(int i);

int cd_node_item_get_id(int index);

void cd_node_item_erase(GdkPixmap *pixmap, GdkGC *gc, int i );

void cd_node_item_erase_deleted(GdkPixmap *pixmap, GdkGC *gc);
void cd_node_item_erase_corner_deleted(GdkPixmap *pixmap, GdkGC *gc);

void cd_node_item_draw(GdkPixmap *pixmap, GdkGC *gc, int i );

void cd_node_item_draw_selecting(GdkPixmap *pixmap, GdkGC *gc);
void cd_node_item_draw_selected(GdkPixmap *pixmap, GdkGC *gc);

int cd_node_item_selection(int x, int y);
void cd_node_item_selection_clear_all();

void cd_node_item_calc_rect(int i);
void cd_node_item_calc_name_point(int i);
void cd_node_item_calc_attr_y(int i);
void cd_node_item_calc_op_y(int i);
void cd_node_item_calc_center(int i, GdkPoint *point);

void cd_node_item_calc_arc_points(int start_node_id, int end_node_id,
				  ArcItem *arc);
void cd_node_init();
void cd_node_load(FILE *fp);
void cd_node_save(FILE *fp);

void cd_node_selecting_end();
void cd_node_selection_clear();
gboolean cd_node_check_intersect(GdkRectangle *rect);

#endif
