/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_pg_dialog.h"

/*
 * cd_node_dialog_pg_apply
 */
void cd_pg_dialog_apply(GtkWidget *widget, PgDialog *pd)
{
  cd_pg_table_panel_apply(pd);
  cd_pg_connect_panel_apply(pd);
  cd_control_node_dialog_apply(pd->item_index);
}

/*
 * cd_node_dialog_pg_close
 */
void cd_pg_dialog_close(GtkWidget *widget, PgDialog *pd)
{
  gtk_widget_destroy(pd->window);
}

/*
 * cd_pg_dialog_ok
 */
void cd_pg_dialog_ok(GtkWidget *widget, PgDialog *pd)
{
  cd_pg_dialog_apply(widget, pd);
  cd_pg_dialog_close(widget, pd);
}

void cd_pg_buttons_new(PgDialog *pd)
{
  pd->hbox = gtk_hbox_new(FALSE, 5);

  pd->ok_button = gtk_button_new_with_label (LABEL_OK);
  gtk_signal_connect(GTK_OBJECT(pd->ok_button), "clicked",
		     (GtkSignalFunc)cd_pg_dialog_ok,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->hbox), pd->ok_button, FALSE, TRUE, 0);

  pd->apply_button = gtk_button_new_with_label (LABEL_APPLY);
  gtk_signal_connect(GTK_OBJECT(pd->apply_button), "clicked",
		     (GtkSignalFunc)cd_pg_dialog_apply,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->hbox), pd->apply_button, FALSE, TRUE, 0);

  pd->close_button = gtk_button_new_with_label (LABEL_CLOSE);
  gtk_signal_connect(GTK_OBJECT(pd->close_button), "clicked",
		     (GtkSignalFunc)cd_pg_dialog_close,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->hbox), pd->close_button, FALSE, TRUE, 0);
		      
  gtk_box_pack_start (GTK_BOX (pd->vbox), pd->hbox, FALSE, TRUE, 0);
}

void cd_pg_dialog_open(NodeItem *ni, int i)
{
  PgDialog pd;

  pd.item_index = i;
  pd.ni = ni;

  /* top window */
  pd.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_position (GTK_WINDOW(pd.window), GTK_WIN_POS_CENTER);
  gtk_window_set_modal((GtkWindow*)pd.window, TRUE);
  gtk_container_border_width (GTK_CONTAINER (pd.window), 10);
  gtk_signal_connect(GTK_OBJECT(pd.window), "destroy", NULL, NULL);
  pd.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (pd.vbox), 10);

  pd.notebook = gtk_notebook_new();
  gtk_notebook_set_tab_pos (GTK_NOTEBOOK (pd.notebook), GTK_POS_TOP);
  gtk_box_pack_start(GTK_BOX(pd.vbox), pd.notebook, TRUE, TRUE, 0);
  gtk_widget_show(pd.notebook);

  cd_pg_table_panel_new(&pd);
  cd_pg_connect_panel_new(&pd);
  cd_pg_app_panel_new(&pd);
  cd_pg_buttons_new(&pd);

  gtk_container_add (GTK_CONTAINER (pd.window), pd.vbox);
  
  gtk_widget_show_all (pd.vbox);
  gtk_widget_show (pd.window);

  gtk_main();
}
