/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_define.h"
#include "cd_arc.h"
#include "cd_arc_dialog.h"

#include "pixmaps/association.xpm"
#include "pixmaps/association2.xpm"
#include "pixmaps/aggregation.xpm"
#include "pixmaps/aggregation2.xpm"

extern Arc cd_arc;

typedef struct _CdPixItem  CdPixItem;
typedef struct _CdMultItem CdMultItem;

struct _CdPixItem
{
  char **xpm;
  void *func;
};

struct _CdMultItem
{
  char *def;
  void *func;
};
  
/*
 * cd_arc_dialog_pix_start_funcs
 */
void cd_arc_dialog_pix_association_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_type = association;
}
void cd_arc_dialog_pix_association2_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_type = association2;
}
void cd_arc_dialog_pix_aggregation_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_type = aggregation;
}
void cd_arc_dialog_pix_aggregation2_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_type = aggregation2;
}
CdPixItem cd_pix_term_start[] = {
  { association_xpm,     cd_arc_dialog_pix_association_start  },
  { association2_xpm,    cd_arc_dialog_pix_association2_start },
  { aggregation_xpm,     cd_arc_dialog_pix_aggregation_start  },
  { aggregation2_xpm,    cd_arc_dialog_pix_aggregation2_start  },
  { NULL,                NULL }
};

/*
 * cd_arc_dialog_pix_end_func
 */
void cd_arc_dialog_pix_association_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_type = association;
}
void cd_arc_dialog_pix_association2_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_type = association2;
}
void cd_arc_dialog_pix_aggregation_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_type = aggregation;
}
void cd_arc_dialog_pix_aggregation2_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_type = aggregation2;
}
CdPixItem cd_pix_term_end[] = {
  { association_xpm,     cd_arc_dialog_pix_association_end  },
  { association2_xpm,    cd_arc_dialog_pix_association2_end },
  { aggregation_xpm,     cd_arc_dialog_pix_aggregation_end  },
  { aggregation2_xpm,    cd_arc_dialog_pix_aggregation2_end  },
  { NULL,                NULL }
};

/*
 * cd_arc_dialog_mult_start_funcs
 */
void cd_arc_dialog_mult_none_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_mult = m_none;
}
void cd_arc_dialog_mult_zero_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_mult = m0;
}
void cd_arc_dialog_mult_zero_one_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_mult = m0_1;
}
void cd_arc_dialog_mult_one_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_mult = m1;
}
void cd_arc_dialog_mult_zero_n_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_mult = m0_n;
}
void cd_arc_dialog_mult_one_n_start(GtkWidget *widget, ArcDialog *ad)
{
  ad->start_mult = m1_n;
}
CdMultItem cd_mult_term_start[] = {
  { CD_MULT_NONE,     cd_arc_dialog_mult_none_start },
  { CD_MULT_ZERO,     cd_arc_dialog_mult_zero_start },
  { CD_MULT_ZERO_ONE, cd_arc_dialog_mult_zero_one_start },
  { CD_MULT_ONE,      cd_arc_dialog_mult_one_start },
  { CD_MULT_ZERO_N,   cd_arc_dialog_mult_zero_n_start },
  { CD_MULT_ONE_N,    cd_arc_dialog_mult_one_n_start },
  { NULL, NULL }
};

/*
 * cd_arc_dialog_mult_end_funcs
 */
void cd_arc_dialog_mult_none_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_mult = m_none;
}
void cd_arc_dialog_mult_zero_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_mult = m0;
}
void cd_arc_dialog_mult_zero_one_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_mult = m0_1;
}
void cd_arc_dialog_mult_one_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_mult = m1;
}
void cd_arc_dialog_mult_zero_n_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_mult = m0_n;
}
void cd_arc_dialog_mult_one_n_end(GtkWidget *widget, ArcDialog *ad)
{
  ad->end_mult = m1_n;
}
CdMultItem cd_mult_term_end[] = {
  { CD_MULT_NONE,     cd_arc_dialog_mult_none_end },
  { CD_MULT_ZERO,     cd_arc_dialog_mult_zero_end },
  { CD_MULT_ZERO_ONE, cd_arc_dialog_mult_zero_one_end },
  { CD_MULT_ONE,      cd_arc_dialog_mult_one_end },
  { CD_MULT_ZERO_N,   cd_arc_dialog_mult_zero_n_end },
  { CD_MULT_ONE_N,    cd_arc_dialog_mult_one_n_end },
  { NULL, NULL }
};

/*
 * cd_arc_dialog_apply
 */
void cd_arc_dialog_apply(GtkWidget *widget, ArcDialog *ad)
{
  int i = ad->item_index;
  gchar *name;

  cd_control_arc_dialog_apply0(i);

  name = gtk_entry_get_text((GtkEntry*)ad->entry);

  sprintf(cd_arc.item[i].name, "%s", name);

  cd_arc.item[i].start.type = ad->start_type;
  cd_arc.item[i].start.mult = ad->start_mult;

  cd_arc.item[i].end.type = ad->end_type;
  cd_arc.item[i].end.mult = ad->end_mult;

  cd_control_arc_dialog_apply(i);
}

/*
 * cd_arc_dialog_close
 */
void cd_arc_dialog_close(GtkWidget *widget, ArcDialog *ad)
{
  gtk_widget_destroy(ad->window);
}

/*
 * cd_arc_dialog_ok
 */
void cd_arc_dialog_ok(GtkWidget *widget, ArcDialog *ad)
{
  cd_arc_dialog_apply(widget, ad);
  cd_arc_dialog_close(widget, ad);
}

/*
 * cd_arc_dialog_bottom_new
 */
void cd_arc_dialog_bottom_new(ArcDialog *ad)
{
  ad->hbox_bottom = gtk_hbox_new(FALSE, 5);

  ad->ok_button = gtk_button_new_with_label (LABEL_OK);
  gtk_box_pack_start (GTK_BOX (ad->hbox_bottom),
		      ad->ok_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ad->ok_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_arc_dialog_ok),
		      (gpointer)ad);
		      
  ad->apply_button = gtk_button_new_with_label (LABEL_APPLY);
  gtk_box_pack_start (GTK_BOX (ad->hbox_bottom),
		      ad->apply_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ad->apply_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_arc_dialog_apply),
		      (gpointer)ad);
		      
  ad->close_button = gtk_button_new_with_label (LABEL_CLOSE);
  gtk_box_pack_start (GTK_BOX (ad->hbox_bottom),
		      ad->close_button, FALSE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ad->close_button), "clicked",
		      GTK_SIGNAL_FUNC (cd_arc_dialog_close),
		      (gpointer)ad);

  gtk_box_pack_start (GTK_BOX (ad->vbox), ad->hbox_bottom, FALSE, TRUE, 0);
}

/*
 * cd_arc_dialog_labels_new
 */
void cd_arc_dialog_labels_new(ArcDialog *ad)
{
  ad->hbox_label = gtk_hbox_new(FALSE, 5);

  ad->start_label = gtk_label_new (LABEL_START);
  gtk_box_pack_start (GTK_BOX (ad->hbox_label),
		      ad->start_label, TRUE, TRUE, 0);
  ad->entry_label = gtk_label_new (LABEL_ENTRY);
  gtk_box_pack_start (GTK_BOX (ad->hbox_label),
		      ad->entry_label, TRUE, TRUE, 0);
  ad->end_label = gtk_label_new (LABEL_END);
  gtk_box_pack_start (GTK_BOX (ad->hbox_label),
		      ad->end_label, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX (ad->vbox), ad->hbox_label, FALSE, TRUE, 0);
}

/*
 * cd_arc_dialog_opt_mult_func_start
 */
void cd_arc_dialog_opt_mult_func_start(ArcDialog *ad, GtkWidget *menu, int i)
{
  GtkWidget *item;

  item = gtk_menu_item_new_with_label(cd_mult_term_start[i].def);
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC(cd_mult_term_start[i].func),
		     (gpointer)ad);
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
}

/*
 * cd_arc_dialog_opt_mult_func_end
 */
void cd_arc_dialog_opt_mult_func_end(ArcDialog *ad, GtkWidget *menu, int i)
{
  GtkWidget *item;

  item = gtk_menu_item_new_with_label(cd_mult_term_end[i].def);
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC(cd_mult_term_end[i].func),
		     (gpointer)ad);
  gtk_widget_show (item);
  gtk_menu_append (GTK_MENU (menu), item);
}

/*
 * cd_arc_dialog_mult_active
 */
void cd_arc_dialog_mult_active(GtkWidget *menu, MultType type)
{
  switch(type){
  case m_none:
    gtk_menu_set_active(GTK_MENU (menu), 0);
    break;
  case m0:
    gtk_menu_set_active(GTK_MENU (menu), 1);
    break;
  case m0_1:
    gtk_menu_set_active(GTK_MENU (menu), 2);
    break;
  case m1:
    gtk_menu_set_active(GTK_MENU (menu), 3);
    break;
  case m0_n:
    gtk_menu_set_active(GTK_MENU (menu), 4);
    break;
  case m1_n:
    gtk_menu_set_active(GTK_MENU (menu), 5);
    break;
  }
}

/*
 * cd_arc_dialog_opt_mult_new
 */
void cd_arc_dialog_opt_mult_new(ArcDialog *ad, CdTermType type)
{
  int i;
  GtkWidget *opt, *menu;

  opt = gtk_option_menu_new();
  menu = gtk_menu_new();
  
  if(type == START){
    for(i=0; i<6; i++)
      cd_arc_dialog_opt_mult_func_start(ad, menu, i);
    cd_arc_dialog_mult_active(menu, ad->start_mult);
  }else if(type == END){
    for(i=0; i<6; i++)
      cd_arc_dialog_opt_mult_func_end(ad, menu, i);
    cd_arc_dialog_mult_active(menu, ad->end_mult);
  }
    
  gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu);
  gtk_box_pack_start (GTK_BOX (ad->hbox_entry), opt, TRUE, TRUE, 0);
  gtk_widget_show (opt);
}

/*
 * cd_arc_dialog_opt_pix_new_start
 */
void cd_arc_dialog_opt_pix_new_start(ArcDialog *ad, GtkWidget *menu, int i)
{
  GtkWidget *gtkPixmap;
  GdkPixmap *gdkPixmap;
  GdkBitmap *gtkMask;
  GtkWidget *item;

  gdkPixmap = 
    gdk_pixmap_create_from_xpm_d(ad->window->window,
				 &gtkMask,
				 &ad->window->style->bg[GTK_STATE_NORMAL],
				 cd_pix_term_start[i].xpm);
  gtkPixmap = gtk_pixmap_new(gdkPixmap, gtkMask);

  item = gtk_menu_item_new();
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC(cd_pix_term_start[i].func),
		     (gpointer)ad);

  gtk_container_add(GTK_CONTAINER(item), gtkPixmap);
  gtk_widget_show(GTK_WIDGET(item));
  gtk_widget_show(GTK_WIDGET(gtkPixmap));

  gtk_menu_append (GTK_MENU (menu), item);
}

/*
 * cd_arc_dialog_opt_pix_new_end
 */
void cd_arc_dialog_opt_pix_new_end(ArcDialog *ad, GtkWidget *menu, int i)
{
  GtkWidget *gtkPixmap;
  GdkPixmap *gdkPixmap;
  GdkBitmap *gtkMask;
  GtkWidget *item;

  gdkPixmap = 
    gdk_pixmap_create_from_xpm_d(ad->window->window,
				 &gtkMask,
				 &ad->window->style->bg[GTK_STATE_NORMAL],
				 cd_pix_term_end[i].xpm);
  gtkPixmap = gtk_pixmap_new(gdkPixmap, gtkMask);

  item = gtk_menu_item_new();
  gtk_signal_connect(GTK_OBJECT (item), "activate",
		     GTK_SIGNAL_FUNC(cd_pix_term_end[i].func),
		     (gpointer)ad);

  gtk_container_add(GTK_CONTAINER(item), gtkPixmap);
  gtk_widget_show(GTK_WIDGET(item));
  gtk_widget_show(GTK_WIDGET(gtkPixmap));

  gtk_menu_append (GTK_MENU (menu), item);
}

/*
 * cd_arc_dialog_pix_active
 */
void cd_arc_dialog_pix_active(GtkWidget *menu, CdToolType type)
{
  switch(type){
  case association:
    gtk_menu_set_active(GTK_MENU (menu), 0);
    break;
  case association2:
    gtk_menu_set_active(GTK_MENU (menu), 1);
    break;
  case aggregation:
    gtk_menu_set_active(GTK_MENU (menu), 2);
    break;
  case aggregation2:
    gtk_menu_set_active(GTK_MENU (menu), 3);
    break;
  }
}

/*
 * cd_arc_dialog_opt_pix_new
 */
void cd_arc_dialog_opt_pix_new(ArcDialog *ad, CdTermType type)
{
  int i;
  GtkWidget *opt, *menu;
  
  opt = gtk_option_menu_new();
  menu = gtk_menu_new();
    
  if(type == START){
    for(i=0; i<4; i++)
      cd_arc_dialog_opt_pix_new_start(ad, menu, i);
    cd_arc_dialog_pix_active(menu, ad->start_type);
  }else if(type == END){
    for(i=0; i<4; i++)
      cd_arc_dialog_opt_pix_new_end(ad, menu, i);
    cd_arc_dialog_pix_active(menu, ad->end_type);
  }

  gtk_option_menu_set_menu (GTK_OPTION_MENU (opt), menu);
  gtk_box_pack_start (GTK_BOX (ad->hbox_entry), opt, TRUE, TRUE, 0);
  gtk_widget_show (opt);
}

/*
 * cd_arc_dialog_entrys_new
 */
void cd_arc_dialog_entrys_new(ArcDialog *ad)
{
  int i = ad->item_index;

  ad->hbox_entry = gtk_hbox_new(FALSE, 5);

  cd_arc_dialog_opt_mult_new(ad, START);
  cd_arc_dialog_opt_pix_new(ad, START);

  ad->entry = gtk_entry_new();
  gtk_entry_set_text((GtkEntry*)ad->entry, cd_arc.item[i].name); 
  gtk_box_pack_start (GTK_BOX (ad->hbox_entry), ad->entry, TRUE, TRUE, 0);

  cd_arc_dialog_opt_pix_new(ad, END);
  cd_arc_dialog_opt_mult_new(ad, END);

  gtk_box_pack_start (GTK_BOX (ad->vbox), ad->hbox_entry, FALSE, TRUE, 0);
}

/*
 * cd_arc_dialog_open
 */
void cd_arc_dialog_open(int i)
{
  ArcDialog ad;

  if(cd_arc.item[i].start.type == generalization ||
     cd_arc.item[i].end.type == generalization){
    g_print(CD_ARC_DIALOG_MESSAGE1);
    return;
  }

  ad.item_index = i;
  ad.start_type = cd_arc.item[i].start.type;
  ad.start_mult = cd_arc.item[i].start.mult;
  ad.end_type   = cd_arc.item[i].end.type;
  ad.end_mult   = cd_arc.item[i].end.mult;

  /* top window */
  ad.window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_modal((GtkWindow*)ad.window, TRUE);
  gtk_signal_connect(GTK_OBJECT(ad.window), "destroy", NULL, NULL);
  ad.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width(GTK_CONTAINER(ad.vbox), 10);

  cd_arc_dialog_labels_new(&ad);
  gtk_widget_show (ad.window);

  cd_arc_dialog_entrys_new(&ad);
  cd_arc_dialog_bottom_new(&ad);

  gtk_container_add (GTK_CONTAINER (ad.window), ad.vbox);
  gtk_widget_show_all (ad.vbox);

  gtk_main();
}
