/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_define.h"
#include "cd_window.h"
#include "cd_canvas.h"

/*
 * cd_window_focus
 */
void cd_window_focus(GtkWidget *widget, GdkEventFocus *event)
{
  cd_canvas_white();
  cd_canvas_update_all();
}

/*
 * cd_window
 */
GtkWidget* cd_window_new()
{
  GtkWidget *window;
  GtkWidget *vbox;

  window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title(GTK_WINDOW(window), TITLE);
  gtk_window_set_position (GTK_WINDOW(window), GTK_WIN_POS_CENTER);
  gtk_widget_set_usize(window, 800, 600);

  gtk_signal_connect(GTK_OBJECT(window), "delete_event",
		     GTK_SIGNAL_FUNC(gtk_exit), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "destroy",
		     GTK_SIGNAL_FUNC(gtk_exit), NULL);
  gtk_signal_connect(GTK_OBJECT(window), "focus_in_event",
		     GTK_SIGNAL_FUNC(cd_window_focus), NULL);

  vbox = gtk_vbox_new(FALSE, 0);

  cd_menubar_new(window, vbox);
  gtk_widget_show(window);

  cd_canvas_toolbar_new(window, vbox);
  cd_canvas_new(window, vbox);

  gtk_container_add(GTK_CONTAINER(window), vbox);
  gtk_widget_show(vbox);

  return window;
}
