/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_node.h"
#include "cd_pg_table_panel.h"

/*
 * cd_pg_vis_set_funcs
 */
void cd_pg_vis_set_private(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.vis = vis_private;
}
void cd_pg_vis_set_protected(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.vis = vis_protected;
}
void cd_pg_vis_set_public(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.vis = vis_public;
}
PgOptItem vis_item[] = {
  { CD_VIS_PRIVATE_DQ,   cd_pg_vis_set_private },
  { CD_VIS_PROTECTED_DQ, cd_pg_vis_set_protected },
  { CD_VIS_PUBLIC_DQ,    cd_pg_vis_set_public },
  { NULL,                NULL }
};

/*
 * cd_pg_table_vis_menu_new
 */
void cd_pg_table_vis_menu_new(PgDialog *pd)
{
  int i;
  
  pd->tp.opt_vis      = gtk_option_menu_new();
  pd->tp.opt_menu_vis = gtk_menu_new();
  
  pd->tp.opt_menu_item_vis = gtk_menu_item_new_with_label("");
  gtk_widget_show(GTK_WIDGET(pd->tp.opt_menu_item_vis));
  gtk_menu_append (GTK_MENU (pd->tp.opt_menu_vis), pd->tp.opt_menu_item_vis);

  for(i=0; i<3; i++){
    pd->tp.opt_menu_item_vis =
      gtk_menu_item_new_with_label(vis_item[i].label);
    gtk_signal_connect(GTK_OBJECT (pd->tp.opt_menu_item_vis), "activate",
		       GTK_SIGNAL_FUNC(vis_item[i].func),
		       (gpointer)pd);
    gtk_widget_show(GTK_WIDGET(pd->tp.opt_menu_item_vis));
    gtk_menu_append (GTK_MENU (pd->tp.opt_menu_vis),
		     pd->tp.opt_menu_item_vis);
  }
  
  gtk_option_menu_set_menu (GTK_OPTION_MENU (pd->tp.opt_vis),
			    pd->tp.opt_menu_vis);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox2), pd->tp.opt_vis, TRUE, TRUE, 0);
  gtk_widget_show (pd->tp.opt_vis);
}

/*
 * cd_pg_type_set_funcs
 */
void cd_pg_type_set_text(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_text;
}
void cd_pg_type_set_varchar(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_varchar;
}
void cd_pg_type_set_int4(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_int4;
}
void cd_pg_type_set_int8(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_int8;
}
void cd_pg_type_set_serial(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_serial;
}
void cd_pg_type_set_datetime(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_datetime;
}
void cd_pg_type_set_date(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_date;
}
void cd_pg_type_set_time(GtkWidget *widget, PgDialog *pd)
{
  pd->tp.type = pg_time;
}
PgOptItem type_item[] = {
  { CD_PG_TEXT_DQ,     cd_pg_type_set_text },
  { CD_PG_VARCHAR_DQ,  cd_pg_type_set_varchar },
  { CD_PG_INT4_DQ,     cd_pg_type_set_int4 },
  { CD_PG_INT8_DQ,     cd_pg_type_set_int8 },
  { CD_PG_SERIAL_DQ,   cd_pg_type_set_serial },
  { CD_PG_DATETIME_DQ, cd_pg_type_set_datetime },
  { CD_PG_DATE_DQ,     cd_pg_type_set_date },
  { CD_PG_TIME_DQ,     cd_pg_type_set_time },
  { NULL,              NULL }
};

/*
 * cd_pg_table_type_menu_new
 */
void cd_pg_table_type_menu_new(PgDialog *pd)
{
  int i;
  
  pd->tp.opt_type      = gtk_option_menu_new();
  pd->tp.opt_menu_type = gtk_menu_new();
  
  pd->tp.opt_menu_item_type = gtk_menu_item_new_with_label("");
  gtk_widget_show(GTK_WIDGET(pd->tp.opt_menu_item_type));
  gtk_menu_append (GTK_MENU (pd->tp.opt_menu_type), pd->tp.opt_menu_item_type);

  for(i=0; i<8; i++){
    pd->tp.opt_menu_item_type =
      gtk_menu_item_new_with_label(type_item[i].label);
    gtk_signal_connect(GTK_OBJECT (pd->tp.opt_menu_item_type), "activate",
		       GTK_SIGNAL_FUNC(type_item[i].func),
		       (gpointer)pd);
    gtk_widget_show(GTK_WIDGET(pd->tp.opt_menu_item_type));
    gtk_menu_append (GTK_MENU (pd->tp.opt_menu_type),
		     pd->tp.opt_menu_item_type);
  }
  
  gtk_option_menu_set_menu (GTK_OPTION_MENU (pd->tp.opt_type),
			    pd->tp.opt_menu_type);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox2), pd->tp.opt_type, TRUE, TRUE, 0);
  gtk_widget_show (pd->tp.opt_type);
}

/*
 * cd_pg_table_select
 */
void cd_pg_table_select(GtkWidget *clist,
			gint row, gint column,
			GdkEventButton *event, PgDialog *pd)
{
  gchar *vis, *type, *name;
  
  pd->tp.select = row;

  gtk_clist_get_text((GtkCList*)pd->tp.list, row, 0, &vis);
  gtk_clist_get_text((GtkCList*)pd->tp.list, row, 1, &type);
  gtk_clist_get_text((GtkCList*)pd->tp.list, row, 2, &name);

  switch(*vis){
  case CD_VIS_PRIVATE:
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_vis), 1);
    cd_pg_vis_set_private(clist, pd);    
    break;
  case CD_VIS_PROTECTED:
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_vis), 2);
    cd_pg_vis_set_protected(clist, pd);    
    break;
  case CD_VIS_PUBLIC:
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_vis), 3);
    cd_pg_vis_set_public(clist, pd);    
    break;
  }

  if(!strcmp(type, CD_PG_TEXT_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 1);
    cd_pg_type_set_text(clist, pd);    
  }else if(!strcmp(type, CD_PG_VARCHAR_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 2);
    cd_pg_type_set_varchar(clist, pd);    
  }else if(!strcmp(type, CD_PG_INT4_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 3);
    cd_pg_type_set_int4(clist, pd);    
  }else if(!strcmp(type, CD_PG_INT8_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 4);
    cd_pg_type_set_int8(clist, pd);    
  }else if(!strcmp(type, CD_PG_SERIAL_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 5);
    cd_pg_type_set_serial(clist, pd);    
  }else if(!strcmp(type, CD_PG_DATETIME_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 6);
    cd_pg_type_set_datetime(clist, pd);    
  }else if(!strcmp(type, CD_PG_DATE_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 7);
    cd_pg_type_set_date(clist, pd);    
  }else if(!strcmp(type, CD_PG_TIME_DQ)){
    gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 8);
    cd_pg_type_set_time(clist, pd);    
  }

  gtk_entry_set_text((GtkEntry*)pd->tp.entry,    name); 
  gtk_widget_set_sensitive(pd->tp.apply_button,  TRUE);
  gtk_widget_set_sensitive(pd->tp.delete_button, TRUE);
  gtk_widget_set_sensitive(pd->tp.up_button,     TRUE);
  gtk_widget_set_sensitive(pd->tp.down_button,   TRUE);
}

/*
 * cd_pg_sort_type_swap
 */
GtkSortType cd_pg_sort_type_swap(GtkSortType type)
{
  if(type == GTK_SORT_ASCENDING)
    return GTK_SORT_DESCENDING;
  else
    return GTK_SORT_ASCENDING;
}

/*
 * cd_pg_table_click_column
 */
void cd_pg_table_click_column(GtkCList *list, gint column, PgDialog *pd)
{
  GtkSortType  sort_type;

  if(column == 0){
    sort_type = pd->tp.sort_type0;
    pd->tp.sort_type0 = cd_pg_sort_type_swap(pd->tp.sort_type0);
  }else if(column == 2){
    sort_type = pd->tp.sort_type2;
    pd->tp.sort_type2 = cd_pg_sort_type_swap(pd->tp.sort_type2);
  }else
    return; //au

  gtk_clist_set_sort_type(list, sort_type);
  gtk_clist_set_sort_column(list, column);
  gtk_clist_sort(list);

  gtk_clist_unselect_all((GtkCList *)pd->tp.list);
  gtk_entry_set_text((GtkEntry*)pd->tp.entry, ""); 
  gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_vis), 0);
  gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 0);

  gtk_widget_set_sensitive(pd->tp.apply_button, FALSE);
  gtk_widget_set_sensitive(pd->tp.delete_button, FALSE);
  gtk_widget_set_sensitive(pd->tp.up_button, FALSE);
  gtk_widget_set_sensitive(pd->tp.down_button, FALSE);
  
  pd->tp.select = CD_SELECTING_CLEAR;
}

/*
 *
 */
void cd_pg_table_add(GtkWidget *widget, PgDialog *pd)
{
  gchar *dat[3] = {CD_VIS_PRIVATE_DQ, CD_PG_TEXT_DQ, PG_TABLE_PANEL_FIELD};

  gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_vis), 0);
  gtk_option_menu_set_history(GTK_OPTION_MENU (pd->tp.opt_type), 0);
  gtk_clist_append( (GtkCList *)pd->tp.list, dat);

  gtk_clist_unselect_all((GtkCList *)pd->tp.list);
  gtk_entry_set_text((GtkEntry*)pd->tp.entry, ""); 
}

/*
 * cd_pg_table_apply
 */
void cd_pg_table_apply(GtkWidget *widget, PgDialog *pd)
{
  int row = pd->tp.select;
  gchar *name;

  name = gtk_entry_get_text((GtkEntry*)pd->tp.entry);
  gtk_clist_set_text((GtkCList*)pd->tp.list, row, 2, name);

  switch(pd->tp.vis){
  case vis_private:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 0, CD_VIS_PRIVATE_DQ);
    break;
  case vis_protected:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 0, CD_VIS_PROTECTED_DQ);
    break;
  case vis_public:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 0, CD_VIS_PUBLIC_DQ);
    break;
  }

  switch(pd->tp.type){
  case pg_text:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_TEXT_DQ);
    break;
  case pg_varchar:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_VARCHAR_DQ);
    break;
  case pg_int4:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_INT4_DQ);
    break;
  case pg_int8:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_INT8_DQ);
    break;
  case pg_serial:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_SERIAL_DQ);
    break;
  case pg_datetime:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_DATETIME_DQ);
    break;
  case pg_date:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_DATE_DQ);
    break;
  case pg_time:
    gtk_clist_set_text((GtkCList*)pd->tp.list, row, 1, CD_PG_TIME_DQ);
    break;
  }
}

/*
 * cd_pg_table_delete
 */
void cd_pg_table_delete(GtkWidget *widget, PgDialog *pd)
{
  if(pd->tp.select == CD_SELECTING_CLEAR || pd->tp.select < 0)
    return;
  
  gtk_clist_remove((GtkCList *)pd->tp.list, pd->tp.select);

  gtk_entry_set_text((GtkEntry*)pd->tp.entry, ""); 

  gtk_widget_set_sensitive(pd->tp.apply_button, FALSE);
  gtk_widget_set_sensitive(pd->tp.delete_button, FALSE);
  gtk_widget_set_sensitive(pd->tp.up_button, FALSE);
  gtk_widget_set_sensitive(pd->tp.down_button, FALSE);
  
  pd->tp.select = CD_SELECTING_CLEAR;
}

/*
 * cd_pg_table_up
 */
void cd_pg_table_up(GtkWidget *widget, PgDialog *pd)
{
  if(pd->tp.select == CD_SELECTING_CLEAR || pd->tp.select < 0)
    return;
  
  gtk_clist_row_move((GtkCList *)pd->tp.list, pd->tp.select, pd->tp.select-1);
  pd->tp.select--;
}

/*
 * cd_pg_table_down
 */
void cd_pg_table_down(GtkWidget *widget, PgDialog *pd)
{
  if(pd->tp.select == CD_SELECTING_CLEAR || pd->tp.select < 0)
    return;
  
  gtk_clist_row_move((GtkCList *)pd->tp.list, pd->tp.select, pd->tp.select+1);
  pd->tp.select++;
}

/*
 * cd_pg_table_panel_buttons_new
 */
void cd_pg_table_panel_buttons_new(PgDialog *pd)
{
  /* add button */
  pd->tp.hbox3 = gtk_hbox_new(FALSE, 5);
  pd->tp.add_button = gtk_button_new_with_label (LABEL_ADD);
  gtk_signal_connect(GTK_OBJECT(pd->tp.add_button), "clicked",
		     (GtkSignalFunc)cd_pg_table_add,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox3),
		      pd->tp.add_button, FALSE, TRUE, 0);

  /* apply button */
  pd->tp.apply_button = gtk_button_new_with_label (LABEL_APPLY);
  gtk_signal_connect(GTK_OBJECT(pd->tp.apply_button), "clicked",
		     (GtkSignalFunc)cd_pg_table_apply,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox3),
		      pd->tp.apply_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(pd->tp.apply_button, FALSE);

  /* delete button */
  pd->tp.delete_button = gtk_button_new_with_label (LABEL_DELETE);
  gtk_signal_connect(GTK_OBJECT(pd->tp.delete_button), "clicked",
		     (GtkSignalFunc)cd_pg_table_delete,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox3),
		      pd->tp.delete_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(pd->tp.delete_button, FALSE);

  /* up button */
  pd->tp.up_button = gtk_button_new_with_label (LABEL_UP);
  gtk_signal_connect(GTK_OBJECT(pd->tp.up_button), "clicked",
		     (GtkSignalFunc)cd_pg_table_up,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox3),
		      pd->tp.up_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(pd->tp.up_button, FALSE);

  /* down button */
  pd->tp.down_button = gtk_button_new_with_label (LABEL_DOWN);
  gtk_signal_connect(GTK_OBJECT(pd->tp.down_button), "clicked",
		     (GtkSignalFunc)cd_pg_table_down,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox3),
		      pd->tp.down_button, FALSE, TRUE, 0);
  gtk_widget_set_sensitive(pd->tp.down_button, FALSE);

  gtk_box_pack_start (GTK_BOX (pd->tp.vbox), pd->tp.hbox3, FALSE, TRUE, 0);
}

/*
 * cd_pg_table_panel_list_new
 */
void cd_pg_table_panel_list_new(PgDialog *pd)
{
  gchar *titles[3] = { LABEL_VIS, LABEL_TYPE, LABEL_NAME };

  pd->tp.select     = CD_SELECTING_CLEAR;
  pd->tp.sort_type0 = GTK_SORT_ASCENDING;
  pd->tp.sort_type1 = GTK_SORT_ASCENDING;
  pd->tp.sort_type2 = GTK_SORT_ASCENDING;

  /* attribute list */
  pd->tp.hbox1 = gtk_hbox_new(FALSE, 5);
  pd->tp.scrolled_win = gtk_scrolled_window_new (NULL, NULL);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (pd->tp.scrolled_win),
				  GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_widget_set_usize(pd->tp.scrolled_win, 100, 120);
  gtk_box_pack_start (GTK_BOX (pd->tp.vbox),
		      pd->tp.scrolled_win, TRUE, TRUE, 0);
  gtk_widget_show (pd->tp.scrolled_win);
  pd->tp.list = gtk_clist_new_with_titles(3, titles);
  gtk_scrolled_window_add_with_viewport
    (GTK_SCROLLED_WINDOW (pd->tp.scrolled_win), pd->tp.list);
  gtk_signal_connect (GTK_OBJECT (pd->tp.list), "select_row",
		      (GtkSignalFunc)cd_pg_table_select,
		      (gpointer)pd);
  gtk_signal_connect (GTK_OBJECT (pd->tp.list), "click_column",
		      (GtkSignalFunc)cd_pg_table_click_column,
		      (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->tp.vbox), pd->tp.hbox1, FALSE, TRUE, 0);

  /* attribute entry */
  pd->tp.hbox2 = gtk_hbox_new(FALSE, 5);

  cd_pg_table_vis_menu_new(pd);
  cd_pg_table_type_menu_new(pd);

  pd->tp.entry = gtk_entry_new();
  gtk_box_pack_start (GTK_BOX (pd->tp.hbox2), pd->tp.entry, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (pd->tp.vbox), pd->tp.hbox2, FALSE, TRUE, 0);
}

/*
 * cd_pg_table_panel_list_init
 */
void cd_pg_table_panel_list_init(PgDialog *pd)
{
  PgAttribute *attr;
  gchar *dat[3];
  int i;

  for(i=0; i<g_list_length(pd->ni->attributes); i++){
    attr = g_list_nth_data(pd->ni->attributes, i);
    switch(attr->vis){
    case vis_private:
      dat[0] = CD_VIS_PRIVATE_DQ;
      break;
    case vis_protected:
      dat[0] = CD_VIS_PROTECTED_DQ;
      break;
    case vis_public:
      dat[0] = CD_VIS_PUBLIC_DQ;
      break;
    }
    switch(attr->type){
    case pg_text:
      dat[1] = CD_PG_TEXT_DQ;
      break;
    case pg_varchar:
      dat[1] = CD_PG_VARCHAR_DQ;
      break;
    case pg_int4:
      dat[1] = CD_PG_INT4_DQ;
      break;
    case pg_int8:
      dat[1] = CD_PG_INT8_DQ;
      break;
    case pg_serial:
      dat[1] = CD_PG_SERIAL_DQ;
      break;
    case pg_datetime:
      dat[1] = CD_PG_DATETIME_DQ;
      break;
    case pg_date:
      dat[1] = CD_PG_DATE_DQ;
      break;
    case pg_time:
      dat[1] = CD_PG_TIME_DQ;
      break;
    default:
      break;
    }
    dat[2] = attr->name;
    gtk_clist_append( (GtkCList *)pd->tp.list, dat);
  }
}

/*
 * cd_pg_tanle_panel_name_new
 */
void cd_pg_table_panel_name_new(PgDialog *pd)
{
  pd->tp.name_label = gtk_label_new (LABEL_TABLE);
  pd->tp.name_hbox = gtk_hbox_new(FALSE, 5);
  gtk_box_pack_start (GTK_BOX (pd->tp.name_hbox), pd->tp.name_label,
		      FALSE, TRUE, 0);
		     
  pd->tp.name_entry = gtk_entry_new();
  gtk_entry_set_text((GtkEntry*)pd->tp.name_entry, pd->ni->name); 
  gtk_box_pack_start (GTK_BOX (pd->tp.name_hbox), pd->tp.name_entry,
		      TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (pd->tp.vbox), pd->tp.name_hbox, FALSE, TRUE, 0);
}

/*
 * cd_pg_table_panel_new
 */
void cd_pg_table_panel_new(PgDialog *pd)
{
  pd->tp.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (pd->tp.vbox), 10);
  pd->tp.label = gtk_label_new (LABEL_TAB_DEF);
  gtk_notebook_insert_page (GTK_NOTEBOOK (pd->notebook),
			    pd->tp.vbox, pd->tp.label, 2);

  cd_pg_table_panel_name_new(pd);
  cd_pg_table_panel_list_new(pd);
  cd_pg_table_panel_list_init(pd);
  cd_pg_table_panel_buttons_new(pd);
}

/*
 * cd_pg_table_panle_apply_name
 */
void cd_pg_table_panel_apply_name(PgDialog *pd)
{
  gchar *table_name;

  table_name = gtk_entry_get_text((GtkEntry*)pd->tp.name_entry);

  sprintf(pd->ni->name, "%s", table_name);
}


/*
 * cd_pg_table_panle_apply_list
 */
void cd_pg_table_panel_apply_list(PgDialog *pd)
{
  int i;
  PgAttribute *attr;
  gchar *vis, *type, *name;

  if(pd->ni->attributes != NULL){
    g_list_free(pd->ni->attributes);
    pd->ni->attributes = NULL;
  }

  i = 0;
  while(gtk_clist_get_cell_type((GtkCList*)pd->tp.list, i, 0) != -1){
    gtk_clist_get_text((GtkCList*)pd->tp.list, i, 0, &vis);
    gtk_clist_get_text((GtkCList*)pd->tp.list, i, 1, &type);
    gtk_clist_get_text((GtkCList*)pd->tp.list, i, 2, &name);

    attr = g_new(PgAttribute, 1);
    sprintf(attr->name, "%s", name);

    switch(*vis){
    case CD_VIS_PRIVATE:
      attr->vis = vis_private;
      break;
    case CD_VIS_PROTECTED:
      attr->vis = vis_protected;
      break;
    case CD_VIS_PUBLIC:
      attr->vis = vis_public;
      break;
    }
    
    if(!strcmp(type, CD_PG_TEXT_DQ))
      attr->type = pg_text;
    else if(!strcmp(type, CD_PG_VARCHAR_DQ))
      attr->type = pg_varchar;
    else if(!strcmp(type, CD_PG_INT4_DQ))
      attr->type = pg_int4;
    else if(!strcmp(type, CD_PG_INT8_DQ))
      attr->type = pg_int8;
    else if(!strcmp(type, CD_PG_SERIAL_DQ))
      attr->type = pg_serial;
    else if(!strcmp(type, CD_PG_DATETIME_DQ))
      attr->type = pg_datetime;
    else if(!strcmp(type, CD_PG_DATE_DQ))
      attr->type = pg_date;
    else if(!strcmp(type, CD_PG_TIME_DQ))
      attr->type = pg_time;

    pd->ni->attributes = g_list_append(pd->ni->attributes, attr);
    
    i++;
  }
}

/*
 * cd_pg_table_panel_apply
 */
void cd_pg_table_panel_apply(PgDialog *pd)
{
  cd_pg_table_panel_apply_name(pd);
  cd_pg_table_panel_apply_list(pd);
}
