/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_pg_connect_panel.h"
#include "cd_node.h"
#include "libpq-fe.h"
#include "cd_define.h"

/*
 * cd_pg_create_table
 */
void cd_pg_create_table(GtkWidget *widget, PgDialog *pd)
{
  cd_pg_util_create_table(pd);
}

/*
 * cd_pg_connect_panel_entry_new
 */
void cd_pg_connect_panel_entry_new(PgDialog *pd)
{
  int i;
  PgData *data = (PgData*)pd->ni->data;
  char* labels[] = {
    LABEL_DBNAME, LABEL_HOSTNAME, LABEL_PORT, LABEL_OPTIONS, LABEL_TTY
  };
  
  pd->cp.table = gtk_table_new(5, 2, TRUE);

  for(i=0; i<5; i++){
    pd->cp.labels[i] = gtk_label_new(labels[i]);
    gtk_table_attach_defaults(GTK_TABLE(pd->cp.table),
		     pd->cp.labels[i], 0, 1, i, i+1);
    gtk_widget_show(pd->cp.labels[i]);
    pd->cp.entrys[i] = gtk_entry_new();
    gtk_table_attach_defaults(GTK_TABLE(pd->cp.table),
			      pd->cp.entrys[i], 1, 2, i, i+1);
    gtk_widget_show(pd->cp.entrys[i]);
  }

  if(strlen(data->db) > 0)
    gtk_entry_set_text((GtkEntry*)pd->cp.entrys[0], data->db); 
  if(strlen(data->host) > 0)
    gtk_entry_set_text((GtkEntry*)pd->cp.entrys[1], data->host); 
  if(strlen(data->port) > 0)
    gtk_entry_set_text((GtkEntry*)pd->cp.entrys[2], data->port); 
  if(strlen(data->options) > 0)
    gtk_entry_set_text((GtkEntry*)pd->cp.entrys[3], data->options); 
  if(strlen(data->tty) > 0)
    gtk_entry_set_text((GtkEntry*)pd->cp.entrys[4], data->tty); 

  gtk_widget_set_sensitive(pd->cp.entrys[2], FALSE);
  gtk_widget_set_sensitive(pd->cp.entrys[3], FALSE);
  gtk_widget_set_sensitive(pd->cp.entrys[4], FALSE);

  gtk_container_add(GTK_CONTAINER (pd->cp.vbox), pd->cp.table);
  gtk_widget_show(pd->cp.table);
}

/*
 * cd_pg_connect_panel_new
 */
void cd_pg_connect_panel_new(PgDialog *pd)
{
  pd->cp.vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_set_border_width (GTK_CONTAINER (pd->cp.vbox), 10);
  pd->cp.label = gtk_label_new (LABEL_CONNECT);
  gtk_notebook_insert_page (GTK_NOTEBOOK (pd->notebook),
			    pd->cp.vbox, pd->cp.label, 2);

  cd_pg_connect_panel_entry_new(pd);

  pd->cp.create_button = gtk_button_new_with_label (LABEL_CREATE);
  gtk_signal_connect(GTK_OBJECT(pd->cp.create_button), "clicked",
		     (GtkSignalFunc)cd_pg_create_table,
		     (gpointer)pd);
  gtk_box_pack_start (GTK_BOX (pd->cp.vbox), pd->cp.create_button,
		      FALSE, TRUE, 0);
}

/*
 * cd_pg_connect_panel_apply
 */
void cd_pg_connect_panel_apply(PgDialog *pd)
{
  int i;
  PgData *data;
  char *str[5];

  data = (PgData*)pd->ni->data;

  for(i=0; i<5; i++)
    str[i] = gtk_entry_get_text((GtkEntry*)pd->cp.entrys[i]);
  
  if(strlen(str[0]) > 0) sprintf(data->db,      "%s", str[0]);
  if(strlen(str[1]) > 0) sprintf(data->host,    "%s", str[1]);
  if(strlen(str[2]) > 0) sprintf(data->port,    "%s", str[2]);
  if(strlen(str[3]) > 0) sprintf(data->options, "%s", str[3]);
  if(strlen(str[4]) > 0) sprintf(data->tty,     "%s", str[4]);
}
