/* cdedit3 -- class diagram creation/manipulation program
 * Copyright (C) 2001 Touge Kamisimo
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
#include "cd_canvas.h"
#include "cd_control.h"
#include "cd_io.h"

#include <sys/types.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <stdio.h>

/* app flg */
gboolean flg;

Shm cd_shm;

/* Canvas Reference */
extern int cd_drawing_area_width;
extern int cd_drawing_area_height;
extern GdkPixmap *cd_pixmap;
extern GdkGC *cd_black_gc;
extern GdkGC *cd_white_gc;
extern GdkGC *cd_select_gc;
extern GdkGC *cd_blue_gc;
extern GdkFont *cd_font;
extern int lastX, lastY;

/* Io Reference */
extern IoDialog iod;

/*
 * cd_control_node_item_draw
 */
void cd_control_node_item_draw(int i)
{
  switch(cd_shm.cd_node.item[i].kind){
  case kind_uml:
    cd_node_item_draw(cd_pixmap, cd_black_gc, i);
    break;
  case kind_pgsql:
    cd_node_item_draw(cd_pixmap, cd_blue_gc, i);
    break;
  default:
    break;
  }
}

/*
 * cd_control_node_add
 */
void cd_control_node_add(int x, int y)
{
  int i = cd_shm.cd_node.count;
  CdKind kind;

  switch(cd_canvas_mode_get_tool_type()){
  case umlclass:
    kind = kind_uml;
    break;
  case pgclass:
    kind = kind_pgsql;
    break;
  default:
    break;
  }

  cd_node_item_new(i, x, y, kind);
  cd_control_node_item_draw(i);
}
  
/*
 * cd_control_selection
 */
void cd_control_selection(int x, int y, int event_type)
{
  int i;

  cd_node_item_selection_clear_all();
  cd_arc_item_selection_clear_all();

  cd_node_item_draw_selected(cd_pixmap, cd_white_gc);
  cd_arc_item_draw_selected(cd_pixmap, cd_black_gc);

  i = cd_node_item_selection(x,y);
  if(i < CD_NODE_ITEM_MAX) {
    if(event_type == 5){
      cd_control_selection_end();

      switch(cd_shm.cd_node.item[i].kind){
      case kind_uml:
	cd_node_dialog_open(i);
	break;
      case kind_pgsql:
	cd_pg_dialog_open(&cd_shm.cd_node.item[i], i);
	break;
      default:
	break;
      }
      return;
    }
    cd_node_item_draw_selecting(cd_pixmap, cd_black_gc);
    cd_arc_selection_clear();
    return;
  }

  i = cd_arc_item_selection(x,y);
  if(i < CD_ARC_ITEM_MAX){
    if(event_type == 5){
      cd_control_selection_end();
      cd_arc_dialog_open(i);
      return;
    }
    cd_arc_item_draw_selecting(cd_pixmap, cd_white_gc);
    cd_arc_item_draw_selecting(cd_pixmap, cd_select_gc);
    cd_node_selection_clear();
    return;
  }    
}

/*
 * cd_control_move_arc
 */
void cd_control_move_arc(int dx, int dy, int node_id)
{
  int i;

  for(i=0; i<cd_shm.cd_arc.count; i++){
    if(cd_shm.cd_arc.item[i].start.node_id == node_id){
      cd_arc_item_draw(cd_pixmap, cd_white_gc, i);
      cd_arc_item_start_move(dx, dy, i);
      cd_arc_item_draw(cd_pixmap, cd_black_gc, i);
    }
    if(cd_shm.cd_arc.item[i].end.node_id == node_id){
      cd_arc_item_draw(cd_pixmap, cd_white_gc, i);
      cd_arc_item_end_move(dx, dy, i);
      cd_arc_item_draw(cd_pixmap, cd_black_gc, i);
    }
  }
}

/*
 * cd_control_move_node
 */
void cd_control_move_node(int dx, int dy)
{
  cd_node_item_draw_selecting(cd_pixmap, cd_white_gc);
  cd_node_item_draw(cd_pixmap, cd_white_gc, cd_shm.cd_node.selecting);

  cd_node_item_move(dx, dy);

  cd_node_item_draw_selecting(cd_pixmap, cd_black_gc);
  cd_control_node_item_draw(cd_shm.cd_node.selecting);
}  

/*
 * cd_control_motion
 */
void cd_control_motion(int x, int y)
{
  int dx, dy;
  int node_index;

  dx = x - lastX;
  dy = y - lastY;

  node_index = cd_shm.cd_node.selecting;
  if(node_index < cd_shm.cd_node.count) {
    cd_control_move_node(dx, dy);
    cd_control_move_arc(dx, dy, cd_node_item_get_id(node_index));
  }

  lastX = x;
  lastY = y;
}

/*
 * cd_control_selection_end
 */
void cd_control_selection_end()
{
  cd_node_selecting_end();
  cd_arc_selecting_end();
}

/*
 * cd_control_selecting
 */
gboolean cd_control_selecting()
{
  if(cd_shm.cd_node.selecting == CD_SELECTING_CLEAR &&
     cd_shm.cd_arc.selecting == CD_SELECTING_CLEAR ){
    return FALSE;
  }

  return TRUE;
}

/*
 * cd_control_selecting_clear
 */
void cd_control_selecting_clear()
{
  cd_shm.cd_node.selecting = CD_SELECTING_CLEAR;
  cd_shm.cd_arc.selecting = CD_SELECTING_CLEAR;
}

/*
 * cd_control_arc_add_start
 */
void cd_control_arc_add_start(int x, int y, CdToolType type)
{
  int i;

  if(cd_shm.cd_arc.count >= CD_ARC_ITEM_MAX){
    g_print(CD_CONTROL_MESSAGE1);
    return;
  }

  cd_shm.cd_arc.start = cd_node_item_selection(x,y);

  if(cd_shm.cd_arc.start == CD_SELECTING_CLEAR)
    return;

  cd_arc_item_new_start(x, y, cd_shm.cd_arc.start, type);
}

/*
 * cd_control_arc_add_end
 */
void cd_control_arc_add_end(int x, int y, CdToolType type)
{
  int end_node_index;
  int start_node_id, end_node_id;

  if(cd_shm.cd_arc.count >= CD_ARC_ITEM_MAX){
    g_print(CD_CONTROL_MESSAGE1);
    return;
  }

  if(cd_shm.cd_arc.start == CD_SELECTING_CLEAR)
    return;

  end_node_index = cd_node_item_selection(x,y);

  if(cd_shm.cd_arc.start == end_node_index)
    return;

  if(end_node_index == CD_SELECTING_CLEAR)
    return;

  start_node_id = cd_shm.cd_arc.item[cd_shm.cd_arc.count].start.node_id;
  end_node_id = cd_shm.cd_node.item[end_node_index].id;

  if(cd_arc_item_is_exist(start_node_id, end_node_id)){
    g_print(CD_CONTROL_MESSAGE1);
    return;
  }

  cd_arc_item_new_end(x, y, end_node_index, type);

  cd_arc_item_draw_last(cd_pixmap, cd_black_gc);
}

/*
 * cd_control_draw_all
 */
void cd_control_draw_all()
{
  int i;

  int shmid;
  key_t key;
  void* shm;
  key = 234567890;

  if(flg == TRUE) {
    if((shmid = shmget(key, sizeof(cd_shm), IPC_CREAT | 0666)) < 0){
      perror("shmget");
      exit(1);
    }

    if((shm = shmat(shmid, NULL, 0)) == (char*)-1) {
      perror("shmat");
      exit(1);
    }
    
    memcpy(shm, &cd_shm, sizeof(cd_shm));
  } else {
    if((shmid = shmget(key, sizeof(cd_shm), 0666)) < 0){
      perror("shmget");
      exit(1);
    }

    if((shm = (char*)shmat(shmid, NULL, 0)) == (char*)-1){
      perror("shmat");
      exit(1);
    }

    memcpy(&cd_shm, shm, sizeof(cd_shm));
  }

  for(i=0; i<cd_shm.cd_arc.count; i++)
    cd_arc_item_draw(cd_pixmap, cd_black_gc, i);
  for(i=0; i<cd_shm.cd_node.count; i++)
    cd_node_item_erase(cd_pixmap, cd_white_gc, i);
  for(i=0; i<cd_shm.cd_node.count; i++)
    cd_control_node_item_draw(i);
}
    
/*
 * cd_control_draw_node_all
 */
void cd_control_draw_node_all()
{
  int i;

  for(i=0; i<cd_shm.cd_node.count; i++)
    cd_node_item_erase(cd_pixmap, cd_white_gc, i);
  for(i=0; i<cd_shm.cd_node.count; i++)
    cd_control_node_item_draw(i);
}  

/*
 * cd_control_delete
 */
void cd_control_delete()
{
  if(cd_arc_item_delete())
    cd_arc_item_erase_deleted(cd_pixmap, cd_white_gc);

  if(cd_node_item_delete()){
    cd_control_delete_arc_with_node();
    cd_node_item_erase_deleted(cd_pixmap, cd_white_gc);
    cd_node_item_erase_corner_deleted(cd_pixmap, cd_white_gc);
  }
}

/*
 * cd_control_delete_arc_with_node
 */
void cd_control_delete_arc_with_node()
{
  int i, node_id;

  node_id = cd_shm.cd_node_item_last_deleted.id;

  for(i=cd_shm.cd_arc.count-1; i>=0; i--){
    if(node_id == cd_shm.cd_arc.item[i].start.node_id ||
       node_id == cd_shm.cd_arc.item[i].end.node_id){
      cd_shm.cd_arc.item[i].select = TRUE;
      if(cd_arc_item_delete()){
	cd_arc_item_erase_deleted(cd_pixmap, cd_white_gc);
      }
    }
  }
}

/*
 * cd_control_save
 */
void cd_control_save()
{
  if(!iod.cd_filename)
    cd_io_dialog_open(io_save);

  cd_io_save();
}

/*
 * cd_control_follow_arc_points
 */
void cd_control_follow_arc_points(int i)
{
  int j;
  int node_id = cd_shm.cd_node.item[i].id;

  for(j=0; j<cd_shm.cd_arc.count; j++){
    if(cd_shm.cd_arc.item[j].start.node_id == node_id ||
       cd_shm.cd_arc.item[j].end.node_id == node_id){

      cd_arc_item_draw(cd_pixmap, cd_white_gc, j);

      cd_node_item_calc_arc_points(cd_shm.cd_arc.item[j].start.node_id,
				   cd_shm.cd_arc.item[j].end.node_id,
				   &cd_shm.cd_arc.item[j]);

      cd_arc_item_draw(cd_pixmap, cd_black_gc, j);
    }
  }    
}

/*
 * cd_control_node_dialog_apply
 */
void cd_control_node_dialog_apply(int i)
{
  cd_node_item_erase(cd_pixmap, cd_white_gc, i);
  cd_node_item_calc_rect(i);
  cd_node_item_calc_name_point(i);
  cd_node_item_calc_attr_y(i);
  cd_node_item_calc_op_y(i);

  cd_control_follow_arc_points(i);

  cd_control_node_item_draw(i);

  cd_canvas_update_all();
}

/*
 * cd_control_arc_dialog_apply
 */
void cd_control_arc_dialog_apply(int i)
{
  cd_arc_item_calc_name_rect(i);

  cd_arc_item_draw(cd_pixmap, cd_black_gc, i);

  cd_canvas_update_all();
}

/*
 * cd_control_arc_dialog_apply0
 */
void cd_control_arc_dialog_apply0(int i)
{
  cd_arc_item_draw(cd_pixmap, cd_white_gc, i);
}

/*
 * cd_control_mode_change_from_select
 */
void cd_control_mode_change_from_select()
{
  cd_node_item_selection_clear_all();
  cd_arc_item_selection_clear_all();

  cd_node_item_draw_selected(cd_pixmap, cd_white_gc);
  cd_arc_item_draw_selected(cd_pixmap, cd_black_gc);

  cd_arc_selection_clear();
  cd_node_selection_clear();
}

/*
 * void cd_control_tool_set_dialog_open
 */
void cd_control_tool_set_dialog_open()
{
  cd_tool_set_dialog_open();
}

/*
 * cd_control_calc_effective_rect
 */
gint cd_control_calc_effective_rect(GdkRectangle *rect)
{
  int i;
  int x = cd_drawing_area_width;
  int y = cd_drawing_area_height;
  int w = 0;
  int h = 0;

  if(cd_shm.cd_node.count == 0)
    return FALSE;

  for(i=0; i<cd_shm.cd_node.count; i++){
    if(x > cd_shm.cd_node.item[i].rect.x)
      x = cd_shm.cd_node.item[i].rect.x;
    if(y > cd_shm.cd_node.item[i].rect.y)
      y = cd_shm.cd_node.item[i].rect.y; 
    if(w < (cd_shm.cd_node.item[i].rect.x + cd_shm.cd_node.item[i].rect.width))
      w = cd_shm.cd_node.item[i].rect.x + cd_shm.cd_node.item[i].rect.width;
    if(h < (cd_shm.cd_node.item[i].rect.y + cd_shm.cd_node.item[i].rect.height))
      h = cd_shm.cd_node.item[i].rect.y + cd_shm.cd_node.item[i].rect.height;
  }

  rect->x = x-10;
  rect->y = y-10;
  rect->width = w+25-x;
  rect->height = h+30-y;

  return TRUE;
}
