package pbl2011.mvc;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

import javax.swing.JOptionPane;

import pbl2011.common.BuiltInClass;
import pbl2011.common.CommonConst;
import pbl2011.common.FileUtil;
import pbl2011.common.JavaCodeGenerator;
import pbl2011.common.Util;
import pbl2011.model.AssociationArc;
import pbl2011.model.Attribute;
import pbl2011.model.ClassModel;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;
import pbl2011.model.NodeArcSet;
import pbl2011.model.PackageManager;
import pbl2011.model.Parameter;
import pbl2011.model.UndoRedoModel;

/**
 * <p>
 * fNX
 * <p>
 * MVCfMSNXB
 * 
 * @author 10745104 Y.Ishii
 */
public class Model implements CommonConst {

	/** UndoRedoModel **/
	public UndoRedoModel undoredoModel;
	
	/** WXg */
	private Set<Observer> registry;

	/**
	 * <p>
	 * WXgɒǉB
	 * 
	 * @param o
	 */
	public void attach(Observer o) {

		if (registry == null) {
			registry = new HashSet<Observer>();
		}
		registry.add(o);
	}

	/**
	 * <p>
	 * WXg폜B
	 * 
	 * @param o
	 */
	public void detach(Observer o) {

		if (registry == null) {
			registry = new HashSet<Observer>();
		}
		registry.remove(o);
	}

	/** ύXtO */
	private boolean isModified = false;

	public boolean isModified() {
		return this.isModified;
	}

	/**
	 * <p>
	 * XV`dJjY
	 */
	protected void notifyAllObj() {

		isModified = true;

		// ׂĂviewXV

		for (Observer o : registry) {
			o.update();
		}

	}

	/** NX */
	private List<ClassNode> classList;

	/** ֘A */
	private List<AssociationArc> arcList;

	/**
	 * <p>
	 * RXgN^
	 * 
	 */
	public Model() {
		this.classList = Collections.synchronizedList(new ArrayList<ClassNode>());
		this.classList.addAll(getBuiltinClassNodeList());

		this.arcList = Collections.synchronizedList(new ArrayList<AssociationArc>());

		this.undoredoModel = new UndoRedoModel();

	}
	
	protected List<ClassNode> getBuiltinClassNodeList(){
		return BuiltInClass.getBuiltinClassNodeList();
	}

	/** 쒆IuWFNgǗNX */
	CurrentManager cuMgr;

	public CurrentManager getCurrentManager() {
		if (cuMgr == null) {
			cuMgr = new CurrentManager(this);
		}
		return cuMgr;
	}

	/**
	 * <p>
	 * NXNA
	 * <p>
	 * SẴNXNAB<br>
	 * XVɁAXV`dJjY̌ĂяosB
	 */
	public void clearData() {

		cuMgr.clear();
		PackageManager.clear();
		classList.clear();
		this.classList.addAll(getBuiltinClassNodeList());
		arcList.clear();
		undoredoModel.initializeUndoRedoModel();
		maxClassId = 0;
		notifyAllObj();
	}

	/**
	 * <p>
	 * NX폜
	 * <p>
	 * SẴNXNAB<br>
	 * XVɁAXV`dJjY̌ĂяosB
	 */
	public void delClassData(ClassNode newClass) {

		classList.remove(newClass);
		notifyAllObj();
	}

	/**
	 * <p>
	 * NXǉ
	 */
	public void addClass(ArrayList<ClassNode> newClasses) {
		classList.addAll(newClasses);
		notifyAllObj();
	}

	/**
	 * <p>
	 * NXǉ
	 */
	public void addClass(ClassNode newClass) {
		classList.add(newClass);
		notifyAllObj();
	}

	/**
	 * <p>
	 * NXύX
	 */
	public void changeModel() {

		// TODO
		notifyAllObj();
	}

	/**
	 * <p>
	 * NX擾
	 * 
	 * @return NX񃊃Xg
	 */
	public ArrayList<ClassNode> getAllActiveClassData() {

		ArrayList<ClassNode> list = new ArrayList<ClassNode>();
		for (ClassNode n : classList) {
			if (!n.delFlag && !n.isBuiltInClass && !(n.p == null)) {
				list.add(n);
			}
		}
		return list;
	}

	/**
	 * <p>
	 * NX擾(`ς݂܂߂Ď擾)
	 *
	 * @return NX񃊃Xg
	 */
	public ArrayList<ClassNode> getAllClassData() {

		ArrayList<ClassNode> list = new ArrayList<ClassNode>();
		for (ClassNode n : classList) {
			if (!n.delFlag) {
				list.add(n);
			}
		}
		return list;
	}

	/**
	 * <p>
	 * NX擾
	 * 
	 * @return NX
	 */
	public ClassNode getClassData(int classId) {

		for (ClassNode n : classList) {
			if (n.classId == classId) {
				return n;
			}
		}
		return null;
	}

	/**
	 * <p>
	 * NXNXID擾
	 * 
	 * @return NXID
	 */
	public int getClassIdByClassName(String className) {

		for (ClassNode n : classList) {
			if (n.className.equals(className)) {
				return n.classId;
			}
		}
		return 0;
	}

	/**
	 * <p>
	 * w肵NXIDNX(m[h)폜
	 */
	public void removeClassById(ClassNode cn) {
		for (int i = 0; i < classList.size(); i++) {
			if (cn.classId == classList.get(i).classId){
				
				classList.remove(i);
				return;
			}
		}
	}
	
	/**
	 * <p>
	 * w肵IDʂ폜
	 */
	public void removeArcById(AssociationArc aa) {
		for (int i = 0; i < arcList.size(); i++) {
			if (aa.assocId == arcList.get(i).assocId) {

				arcList.remove(i);
				return;
			}
		}
	}

	/**
	 * <p>
	 * w肵NXIDNXXV
	 */
	public void setClassDataById(ClassNode cn) {
		for (int i=0; i < classList.size(); i++) {
			if ( cn.classId == classList.get(i).classId) {

				classList.set(i, cn.clone());
				return;
			}
		}
	}
	
	/**
	 * <p>
	 * w肵IDʏXV
	 */
	public void setArcDataById(AssociationArc aa) {

		for (int i = 0; i < arcList.size(); i++) {
			if (aa.assocId == arcList.get(i).assocId) {
				arcList.set(i, aa.clone());
				return;
			}
		}
	}

	/**
	 * <p>
	 * ֘A擾
	 * 
	 * @return ֘A񃊃Xg
	 */
	public ArrayList<AssociationArc> getAllActiveAssociationArc() {

		ArrayList<AssociationArc> list = new ArrayList<AssociationArc>();
		for (AssociationArc a : arcList) {
			if (!a.delFlag) {
				list.add(a);
			}
		}
		return list;
	}

	/**
	 * <p>
	 * ֘A擾
	 *
	 * @return NX
	 */
	public AssociationArc getAssocData(int assocId) {

		for (AssociationArc a : arcList) {
			if (a.assocId == assocId) {
				return a;
			}
		}
		return null;
	}
	/**
	 * <p>
	 * ֘Aǉ
	 */
	public void addAssociation(ArrayList<AssociationArc> newAssociation) {
		arcList.addAll(newAssociation);
		notifyAllObj();
	}

	/**
	 * <p>
	 * ֘Aǉ
	 */
	public void addAssociation(AssociationArc newAssociation) {
		arcList.add(newAssociation);
		notifyAllObj();
	}

	/**
	 * <p>
	 * ^[Qbg֘A擾
	 * 
	 * @return ֘A񃊃Xg
	 */
	public List<AssociationArc> getTargetAssocList(ClassNode inClass) {

		List<AssociationArc> list = new ArrayList<AssociationArc>();
		if (inClass == null)
			return list;
		for (AssociationArc a : arcList) {
			if (inClass.classId == a.classIdTarget) {
				list.add(a);
			}
		}
		return list;
	}

	/**
	 * <p>
	 * \[X֘A擾
	 * 
	 * @return ֘A񃊃Xg
	 */
	public List<AssociationArc> getSourceAssocList(ClassNode outClass) {
		List<AssociationArc> list = new ArrayList<AssociationArc>();
		if (outClass == null)
			return list;
		for (AssociationArc a : arcList) {
			if (outClass.classId == a.classIdSource) {
				list.add(a);
			}
		}
		return list;
	}

	/**
	 * <p>
	 * t@CǍ
	 */
	public boolean read(BufferedReader br, File file) {

		clearData();

		ArrayList<ClassNode> list = new ArrayList<ClassNode>();
		Map<Integer, String> map = new HashMap<Integer, String>();
		ArrayList<AssociationArc> arclist = new ArrayList<AssociationArc>();
		ClassNode node = null;
		Attribute attribute = null;
		Method method = null;
		Parameter parameter = null;
		AssociationArc association = null;
		String line = "";			
		try {
			// t@C̓eɓǍ
			List<String> lines = new ArrayList<String>();
			while ((line = br.readLine()) != null) {
				lines.add(line);
			}
			// br.close();
			
			// [U`NX擾
			Map<String, Integer> userDefClassMap = FileUtil.getUserDefClass(lines);
			// t@CŗpĂ^ׂ̂Ă擾
			Set<String> allTypeSet = FileUtil.getAllTypeSet(lines);
			// `̌^񂪑݂ꍇɃNXXgɐݒ肷
			int maxClassId = FileUtil.getMaxClassId(userDefClassMap);
			for (String className : allTypeSet) {
				if (getClassIdByClassName(className) == 0 && !userDefClassMap.containsKey(className)) {
					classList.add(createClassNode(++maxClassId, className));
					assert Util.debug("##########  `̌^ݒ  ########## className=" + className + ",classId=" + maxClassId);
				}
			}

			// ŏIs܂œǂݍ
			for (String lineForClassLoad : lines) {
				if (FileUtil.isClass(lineForClassLoad)) {
					node = createClassNode(lineForClassLoad);
					list.add(node);
				} else if (FileUtil.isPackage(lineForClassLoad)) {
					String[] tokens = lineForClassLoad.split(DELIMITER);
					map.put(Integer.valueOf(tokens[1]), tokens[2]);
				} else if (FileUtil.isAttrib(lineForClassLoad)) {
					attribute = makeAttribute(lineForClassLoad, userDefClassMap);
					node.attributeList.add(attribute);
				} else if (FileUtil.isMethod(lineForClassLoad)) {
					method = makeMethod(lineForClassLoad, userDefClassMap);
					node.methodList.add(method);
				} else if (FileUtil.isParam(lineForClassLoad)) {
					parameter = makeParameter(lineForClassLoad, userDefClassMap);
					Method m = node.methodList.get(node.methodList.size() - 1);
					m.parameterList.add(parameter);
				} else if (FileUtil.isArc(lineForClassLoad)) {
					association = new AssociationArc(lineForClassLoad);
					// ֘AIDݒ肳ĂȂꍇɂ͍̔ԂB
					if(association.assocId < 0) {
						association.assocId = getNewAssocId();
					}
					arclist.add(association);
				}
			}
			PackageManager.add(map);
			addClass(list);
			addAssociation(arclist);
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
		return true;

	}
	
	protected ClassNode createClassNode(String line){
		return new ClassModel(line);
	}
	
	protected ClassNode createClassNode(int classId, String className){
		return new ClassModel(classId, className);
	}

	/**
	 * CX^X𐶐
	 * @param line
	 * @param userDefinitionClassMap
	 * @return CX^X
	 */
	public Attribute makeAttribute(String line, Map<String, Integer> userDefinitionClassMap) {
		String[] tokens = line.split(DELIMITER);

		int i = 1;
		String attributeName = tokens[i++];
		String typeName = tokens[i++];
		String typeId = getTypeIdByTypeName(typeName, userDefinitionClassMap);
		assert typeId != null : line;
		VisibilityType visibility = VisibilityType.aliasOf(tokens[i++]);
		
		return new Attribute(attributeName, typeId, visibility);
	}

	/**
	 * CX^X𐶐
	 * @param line
	 * @param userDefinitionClassMap
	 * @return CX^X
	 */
	public Method makeMethod(String line, Map<String, Integer> userDefinitionClassMap) {
		String[] tokens = line.split(DELIMITER);

		int i = 1;
		String methodName = tokens[i++];
		String typeName = tokens[i++];
		if (typeName == null || NULL.equals(typeName)) { // RXgN^̏ꍇ͖߂lnullɂȂ
			typeName = "";
		}
		String typeId = getTypeIdByTypeName(typeName, userDefinitionClassMap);
		assert typeId != null : line;
		VisibilityType visibility = VisibilityType.aliasOf(tokens[i++]);
		
		return new Method(methodName, typeId, visibility);
	}

	/**
	 * CX^X𐶐
	 * @param line
	 * @param userDefinitionClassMap
	 * @return CX^X
	 */
	public Parameter makeParameter(String line, Map<String, Integer> userDefinitionClassMap) {
		String[] tokens = line.split(DELIMITER);

		int i = 1;
		String parameterName = tokens[i++];
		String dataTypeName = tokens[i++];
		String typeId = getTypeIdByTypeName(dataTypeName, userDefinitionClassMap);
		assert typeId != null : line;
		return new Parameter(parameterName, typeId);
	}

	/**
	 * ^^IDɕϊ
	 * SɃ[hꍇɗp邱
	 * @param typeName
	 * @return
	 */
	public String getTypeIdByTypeName(String typeName) {
		if (Util.hasSymbol(typeName)) {
			String tmpTypeName = typeName.replace(SPACE, "");
			List<String> list = Util.getTypeList(tmpTypeName);
			for (String s : list) {
				addNoDefClass(s);
				tmpTypeName = tmpTypeName.replace(s, String.valueOf(getClassIdByClassName(s)));
			}
			return tmpTypeName;
		} else {
			addNoDefClass(typeName);
			return String.valueOf(getClassIdByClassName(typeName));
		}
	}

	/**
	 * Ŏ擾^̂classListɂȂꍇclassListɓo^
	 * @param typeName ^
	 */
	private void addNoDefClass(String typeName) {
		if (getClassIdByClassName(typeName) == 0) {
			classList.add(createClassNode(getNextClassId(), typeName));
			assert Util.debug("##########  `̌^ݒ  ########## typeName=" + typeName + ",classId=" + maxClassId);			
		}
	}
	/**
	 * ^^IDɕϊ
	 * t@C荞ݎɗp
	 * @param typeName
	 * @return
	 */
	public String getTypeIdByTypeName(String typeName, Map<String, Integer> userDefinitionClassMap) {
		if (Util.hasSymbol(typeName)) {
			String tmpTypeName = typeName.replace(SPACE, "");
			List<String> list = Util.getTypeList(tmpTypeName);
			for (String s : list) {
				if (getClassIdByClassName(s) != 0) {
					tmpTypeName = tmpTypeName.replace(s, String.valueOf(getClassIdByClassName(s)));
				} else {
					tmpTypeName = tmpTypeName.replace(s, String.valueOf(userDefinitionClassMap.get(s)));
				}
			}
			return tmpTypeName;
		} else {
			if (getClassIdByClassName(typeName) != 0) {
				return String.valueOf(getClassIdByClassName(typeName));
			} else {
				return String.valueOf(userDefinitionClassMap.get(typeName));
			}
		}
	}

	/**
	 * ^ID^ɕϊ
	 * @param typeId
	 * @return
	 */
	public String getTypeNameByTypeId(String typeId) {
		if (Util.hasSymbol(typeId)) {
			String tmpTypeName = typeId.replace(SPACE, "");
			List<String> list = Util.getTypeList(tmpTypeName);
			for (String id : list) {
				tmpTypeName = tmpTypeName.replace(id, getClassData(Integer.valueOf(id)).className);
			}
			return tmpTypeName;
		} else {
			return getClassData(Integer.valueOf(typeId)).className;
		}
	}

	/**
	 * ^ID^ɕϊ
	 * @param typeId
	 * @return
	 */
	public ClassNode getTypeByTypeId(String typeId) {
		if (Util.hasSymbol(typeId)) {
			return getClassData(Util.removeSymbol(typeId));
		} else {
			return getClassData(Integer.valueOf(typeId));
		}
	}

	/**
	 * <p>
	 * t@Cۑ
	 */
	public boolean save(BufferedWriter bw, File file) {
		assert Util.debug("executeSave");

		try {
			writeLine(bw, PackageManager.write());
			
			for (ClassNode nd : getAllActiveClassData()) {
				int id = nd.classId;
				if (!nd.isBuiltInClass) {
					writeLine(bw, nd.toString());
				}

				for (Attribute a : nd.attributeList) {
					writeLine(bw, replaceIdToName(a.toString(id)));
				}

				for (Method m : nd.methodList) {
					writeLine(bw, replaceIdToName(m.toString(id)));

					for (Parameter p : m.parameterList) {
						writeLine(bw, replaceIdToName(p.toString(id)));
					}
				}
			}
			bw.newLine();

			for (AssociationArc arc : getAllActiveAssociationArc()) {
				writeLine(bw, arc.toString());
			}

		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}

		return true;

	}

	private void writeLine(BufferedWriter out, String str) throws IOException {
		out.write(str);
		out.newLine();
	}

	private int maxClassId = 0;

	/**
	 * <p>
	 * NXID̔
	 */
	public int getNextClassId() {
		if (maxClassId < 1) {
			calcMaxClassId();
		}
		return ++maxClassId;
	}

	private void calcMaxClassId() {
		for (ClassNode n : classList) {
			if (!n.isBuiltInClass  && maxClassId < n.classId) {
				maxClassId = n.classId;
			}
		}
	}

	private int maxAssocId = 0;
	/**
	 * <p>
	 * ֘AID̔
	 */
	public int getNewAssocId() {
		if (maxAssocId < 1) {
			calcMaxAssocId();
		}
		return ++maxAssocId;
	}

	private void calcMaxAssocId() {
		for (AssociationArc a : arcList) {
			if (maxAssocId < a.assocId) {
				maxAssocId = a.assocId;
			}
		}
	}


	/**
	 * ^̃NXIDNXɕϊ
	 * @param line
	 * @return ^̃NXIDNXɕϊꂽline
	 */
	private String replaceIdToName(String line) {
		String[] tokens = line.split(DELIMITER);

		String typeId = tokens[2];
		String typeName = getTypeNameByTypeId(typeId);
		return line.replace(typeId, typeName);
	}

	// ֘AύX
	public void changeAssociationArc(String string, AssociationArc a,
			String role, Boolean navi, String multi) {

		if ("t".equals(string)) {
			a.changeT(role, navi, multi);
		} else if ("s".equals(string)) {
			a.changeS(role, navi, multi);
		}
		notifyAllObj();

	}
	// ֘AύXiҏWAgpǉj
	public void changeAssociationArc(String string, AssociationArc a,
			String role, Boolean navi, String multi, int sc) {
		changeAssociationArc(string, a, role, navi, multi);
	}


	// NX폜
	public void deleteClass() {
		NodeArcSet nodearcSet = new NodeArcSet();

		ArrayList<ClassNode> list = cuMgr.getCurrentNodeList();
		for (ClassNode cn : list) {
			cn.delFlag = true;
			nodearcSet.add(cn);

			ArrayList<AssociationArc> arclist = getAllActiveAssociationArc();
			for (AssociationArc a : arclist) {
				if (a.classIdTarget == cn.classId || a.classIdSource == cn.classId) {
					a.delFlag = true;
					nodearcSet.add(a);
				}
			}
		}
		undoredoModel.tryPush(nodearcSet);
		cuMgr.clear();
		notifyAllObj();
	}

	/**
	 * ߂l^Xgԋp
	 * @param classList
	 * @return
	 */
	public String[] getReturnTypeList() {
		return toStringArray(getAllTypeList());
	}

	/**
	 * ^Xgԋp
	 * void͏
	 * @param classList
	 * @return
	 */
	public String[] getTypeList() {
		List<String> allTypeList = getAllTypeList();
		allTypeList.remove(DEFAULT_RETURN_TYPE_NAME); // void
		allTypeList.remove(CONSTRACTOR_RETURN_TYPE_NAME);
		return toStringArray(allTypeList);
	}

	private List<String> getAllTypeList() {
		List<String> typeList = new ArrayList<String>();
		
		for (ClassNode classNode : getAllClassData()) {
			typeList.add(classNode.className);
		}
		
		return typeList;
	}

	private String[] toStringArray(List<String> stringList) {
		String[] stringArray = new String[stringList.size()];
		for (int i = 0; i < stringList.size() ; i++) {
			stringArray[i] = stringList.get(i);
		}
		return stringArray;
	}

	/**
	 * Java\[XR[h𐶐
	 * @throws IOException
	 */
	public void outputJavaCode(File outputDir) throws IOException {
		
		// ΏۂƂȂNX̎擾
		ArrayList<ClassNode> activeClassNodeList = getAllActiveClassData();
		if (activeClassNodeList.size() < 1) {
			JOptionPane.showMessageDialog(null, "o͑ΏۂƂȂNX݂܂B");
		}
		
		// \[XR[ho͏
		JavaCodeGenerator.generate(outputDir, classList);
		
	}

	/**
	 * NX̏ڍ׏XV
	 */
	public void updateClass(ClassNode clone) {
		clone.autoAdjust();
		ClassNode cn = getClassData(clone.classId);
		int i = classList.indexOf(cn);
		classList.remove(i);
		classList.add(i, clone);
		notifyAllObj();

	}
	
	/**
	 * dp`FbN
	 */
	public void checkMultiInherit() {
		Map<Integer, Integer> extendsMap = new HashMap<Integer, Integer>();
		Set<ClassNode> multiInheritList = new HashSet<ClassNode>();
		for (AssociationArc arc :arcList) {
			if (arc.getKind().isEXTENDS() && !arc.delFlag && !getClassData(arc.classIdTarget).classType.isINTERFACE()) {
				if (extendsMap.containsKey(arc.classIdSource)) {
					multiInheritList.add(getClassData(arc.classIdSource));
				}
				extendsMap.put(arc.classIdSource, arc.classIdTarget);
			}
		}
		if (multiInheritList.size() < 1) {
			JOptionPane.showMessageDialog(null, "dpĂNX͂܂B");
		} else {
			StringBuffer sb = new StringBuffer(System.getProperty("line.separator"));
			for (ClassNode c : multiInheritList) {
				sb.append(c.className + System.getProperty("line.separator"));
			}
			JOptionPane.showMessageDialog(null, "ȉ̃NXdpĂ܂B" + sb.toString());			
		}
	}
}
