package pbl2011.model;


import java.util.ArrayList;
import java.util.List;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;

/**
 * UNDOEREDOێNX.
 * 
 * ǗsꍇɎgpNX<br>
 * CX^X𐶐NXɑ΂1̊ǗnƂċ@\
 * 
 * @author isom
 *
 */
public class UndoRedoModel {


	private List<ClassNode> classNodeList = new ArrayList<ClassNode>();
	private List<AssociationArc> associationArcList = new ArrayList<AssociationArc>();
	private List<NodeArcSet> nodearcSetList = new ArrayList<NodeArcSet>();
	protected UndoManager undoManager = new UndoManager();

	/**
	 * RXgN^.
	 */
	public UndoRedoModel() {

	}
	
	/**
	 * 
	 * 
	 */
	public void initializeUndoRedoModel() {
		classNodeList = new ArrayList<ClassNode>();
		associationArcList = new ArrayList<AssociationArc>();
		nodearcSetList = new ArrayList<NodeArcSet>();
		undoManager = new UndoManager();
	}
	
	/**
	 * ClassNode^ListԂ.
	 * 
	 * @return ClassNode^Xg
	 * @see ClassNode
	 */
	public List<ClassNode> getClassNodeList() {
		return classNodeList;
	}
	
	/**
	 * AssociationArc^ListԂ.
	 * 
	 * @return AssociationArc^Xg
	 * @see AssociationArc
	 */
	public List<AssociationArc> getAssociationArcList() {
		return associationArcList;
	}
	
	/**
	 * NodeArcSet^ListԂ.
	 * 
	 * @return NodeArcSet^Xg
	 * @see NodeArcSet
	 */
	public List<NodeArcSet> getNodeArcSetList() {
		return nodearcSetList;
	}
	
	/**
	 * OClassNodeIuWFNgԂ.
	 * 
	 * @return ClassNode^IuWFNg
	 * @see ClassNode
	 */
	public ClassNode getNodeLatest() {
		return classNodeList.get(classNodeList.size() - 1);
	}
	
	/**
	 * OAssociationArcIuWFNgԂ.
	 * 
	 * @return AssociationArc^IuWFNg
	 * @see AssociationArc
	 */
	public AssociationArc getArcLatest() {
		return associationArcList.get(associationArcList.size() - 1);
	}
	
	/**
	 * ONodeArcIuWFNgԂ.
	 * 
	 * @return NodeArcSet^IuWFNg
	 * @see AssociationArc
	 */
	public NodeArcSet getNodeArcSetLatest() {
		return nodearcSetList.get(nodearcSetList.size() - 1);
	}
	
	/**
	 * NodeArcSet^𗚗X^bNɕۑ.
	 * 
	 * <p>
	 * NodeArcSetɊ܂܂邷ׂẴIuWFNg(ClassNode, AssociationArc)
	 * ɂāA߂̕ێeƓłꍇ͕ۑsȂB<br>
	 * ێĂf[^ɂĉ炩̕ύX̂ۑB
	 * </p>
	 * @param nas ۑNodeArcSet^̃IuWFNg
	 * @return ۑꍇtrueAۑȂꍇfalseԂ
	 */
	public boolean tryPush(NodeArcSet nas) {
		NodeArcSet nodearcSet = new NodeArcSet();
		ClassNode cloned_cn;
		AssociationArc cloned_aa;
		
		if (nas == null) {
			return false;
		}
		
		//쐬ꂽIuWFNgꍇ̓tOZbgĂ
		//undoɃIuWFNg폜邽߂ɕKv
		if (nas.isCreate()) {
			nodearcSet.setCreateFlg(true);
		}

		//NodeArcSetIuWFNgɂClassNodeListɑ΂āAύXe𒲂ׂ
		//ύXꍇ͗ɕۑ
		for (ClassNode cn : nas.classNodeList) {
			if (cn == null) {
				continue;
			}
			cloned_cn = cn.clone();
	
			if (nodearcSet.isCreate()) {
				cloned_cn.undoredoModel.classNodeList.clear();
			}
			
			if (cloned_cn.undoredoModel.classNodeList.size() > 0 &&
					cloned_cn.equals(cn.undoredoModel.getNodeLatest())) {
			} else {
				if (cloned_cn.undoredoModel.classNodeList.size() != 0 || nodearcSet.isCreate()) {
					nodearcSet.add(cloned_cn);
				}
				cloned_cn.undoredoModel.classNodeList.add(cloned_cn);
				cloned_cn.undoredoModel.undoManager.undoableEditHappened(new UndoableEditEvent(
						this, new ClassUndoRedoAbleModel(cloned_cn, cloned_cn.undoredoModel.getClassNodeList())));
			}
		}
		
		//NodeArcSetIuWFNgɂAssociationArcListɑ΂āAύXe𒲂ׂ
		//ύXꍇ͗ɕۑ
		for (AssociationArc aa: nas.associationArcList) {
			if (aa == null) {
				continue;
			}
			cloned_aa = aa.clone();
			
			if (nodearcSet.isCreate()) {
				cloned_aa.undoredoModel.associationArcList.clear();
			}
			
			if (cloned_aa.undoredoModel.associationArcList.size() > 0 &&
					cloned_aa.equals(cloned_aa.undoredoModel.getArcLatest())) {
			} else {
				if (cloned_aa.undoredoModel.associationArcList.size() != 0 || nodearcSet.isCreate()) {
					nodearcSet.add(cloned_aa);
		
			}
			cloned_aa.undoredoModel.associationArcList.add(cloned_aa);
			cloned_aa.undoredoModel.undoManager.undoableEditHappened(new UndoableEditEvent(
						this, new ArcUndoRedoAbleModel(cloned_aa, cloned_aa.undoredoModel.getAssociationArcList())));
			}
		}

		//ClassNode, AssociationArĉꂩɕύXƂȂIuWFNg݂ꍇ
		//NodeArcSet𗚗ɕۑ
		if (!nodearcSet.isEmpty()) {
			nodearcSetList.add(nodearcSet);
			undoManager.undoableEditHappened(new UndoableEditEvent(
					this, new UndoRedoAbleModel(nodearcSet, nodearcSetList)));
			return true;
		}
		
		return false;
	}

	/**
	 * Undo\ǂ𔻒.
	 * 
	 * <p>
	 * Undołꍇtrue, UndołȂꍇfalseԂ
	 * </p>
	 * 
	 * @return boolean
	 */
	public boolean canUndo() {
		return undoManager.canUndo();
	}
	
	/**
	 * Redo\ǂ𔻒.
	 * 
	 * <p>
	 * Redołꍇtrue, RedołȂꍇfalseԂ
	 * </p>
	 * 
	 * @return boolean
	 */
	public boolean canRedo() {
		return undoManager.canRedo();
	}
	
	/**
	 * Undos.
	 */
	public void undoAction() {
		try {
			undoManager.undo();
		} catch(CannotRedoException cre) {
			cre.printStackTrace();
		}
	}
	
	/**
	 * Redos.
	 */
	public void redoAction() {
		try {
			undoManager.redo();
		} catch(CannotRedoException cre) {
			cre.printStackTrace();
		}
	}	
	
	/**
	 * NXm[hUndoERedoێNX.
	 * 
	 * @author isom
	 *
	 */
	class ClassUndoRedoAbleModel extends AbstractUndoableEdit {
		protected List<ClassNode> classNodeList;
		protected ClassNode classNode;
		
		/**
		 * RXgN^.
		 * 
		 * @param cn ClassNode^IuWFNg
		 * @param cnl ClasNode^Xg
		 */
		public ClassUndoRedoAbleModel(ClassNode cn, List<ClassNode> cnl) {
			classNodeList = cnl;
			classNode = cn;
		}
		
		/**
		 * 얼\.
		 * 
		 * @return 얼
		 */
		@Override
		public String getPresentationName() {
			return "Class Undo/Redo";
		}
		
		/**
		 * undos.
		 */
		@Override
		public void undo() {
			super.undo();
			classNodeList.remove(classNodeList.size() - 1);
		}
		
		/**
		 * redos.
		 */
		@Override
		public void redo() {
			super.redo();
			classNodeList.add(classNode);
		}
	}

	/**
	 * ʂUndoERedoێNX.
	 * 
	 * @author isom
	 *
	 */
	class ArcUndoRedoAbleModel extends AbstractUndoableEdit {
		protected List<AssociationArc> associationArcList;
		protected AssociationArc associationArc;
		
		/**
		 * RXgN^.
		 * 
		 * @param aa AssociationArc^IuWFNg
		 * @param aal AssociationArc^Xg
		 */
		public ArcUndoRedoAbleModel(AssociationArc aa, List<AssociationArc> aal) {
			associationArcList = aal;
			associationArc = aa;
		}
		
		/**
		 * 얼\.
		 * 
		 * @return 얼
		 */
		@Override
		public String getPresentationName() {
			return "Arc Undo/Redo";
		}

		/**
		 * undos.
		 */
		@Override
		public void undo() {
			super.undo();
			associationArcList.remove(associationArcList.size() - 1);
		}
		
		/**
		 * redos.
		 */
		@Override
		public void redo() {
			super.redo();
			associationArcList.add(associationArc);
		}
	}

	/**
	 * NXm[hAʃZbgUndoERedoێNX.
	 * 
	 * @author isom
	 *
	 */
	class UndoRedoAbleModel extends AbstractUndoableEdit {
		protected List<NodeArcSet> nodearcSetList;
		protected NodeArcSet nodearcSet;
		
		/**
		 * RXgN^.
		 * 
		 * @param nas NodeArcSet^IuWFNg
		 * @param nasl NodeArc^Xg
		 */
		public UndoRedoAbleModel(NodeArcSet nas, List<NodeArcSet> nasl) {
			nodearcSetList = nasl;
			nodearcSet = nas;
		}
		
		/**
		 * 얼\.
		 * 
		 * @return 얼
		 */
		@Override
		public String getPresentationName() {
			return "Class and Arc Undo/Redo";
		}
		
		/**
		 * undos.
		 */
		@Override
		public void undo() {
			super.undo();
			nodearcSetList.remove(nodearcSetList.size() - 1);
		}
		
		/**
		 * redos.
		 */
		@Override
		public void redo() {
			super.redo();
			nodearcSetList.add(nodearcSet);
		}
	}
}


