package pbl2011.model;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import pbl2011.common.CommonConst;

public class PackageManager implements CommonConst{

	/**
	 * pbP[Wێ}bv
	 */
	private static Map<Integer, String> packageMap;
	
	/**
	 * pbP[W}l[W[StaticCjVCU
	 */
	static {
		packageMap = new HashMap<Integer, String>();
		init();
	}
	
	// ݎgpĂpbP[WID̍ől
	private static int maxPackageId = 0;

	/**
	 * <p>
	 * pbP[WID̔
	 */
	private static int getNextPackageId() {
		if (maxPackageId < 1) {
			calcMaxPackageId();
		}
		return ++maxPackageId;
	}


	private static void calcMaxPackageId() {
		for (Integer n : packageMap.keySet()) {
			// VXeŗppbP[W͏
			if (isUserDefinitionPackage(n) && maxPackageId < n.intValue()) {
				maxPackageId = n.intValue();
			}
		}
	}

	/**
	 * pbP[W}bv
	 * VXeŗppbP[W[h
	 */
	private static void init() {
		packageMap.clear();
		packageMap.put(PACKAGE_DEFAULT_ID, PACKAGE_DEFAULT);
		packageMap.put(PACKAGE_JAVA_LANG_ID, PACKAGE_JAVA_LANG);
	}
	
	/**
	 * pbP[W}l[WێpbP[WNA
	 * VXeŗppbP[W͏Ȃ
	 */
	public static void clear() {
		init();
	}
	/**
	 * pbP[WpbP[W}l[W[ɒǉ
	 * @param packageName pbP[W
	 * @return ǉpbP[WID
	 */
	public static Integer add(String packageName) {
		if (packageMap.containsValue(packageName)) {
			return getPackageId(packageName);
		} else {
			Integer nextPackageId = getNextPackageId();
			packageMap.put(nextPackageId, packageName);
			return nextPackageId;
		}
	}

	/**
	 * pbP[WpbP[W}l[W[ɒǉ
	 * ǂݍ݂痘p邱Ƃz肵ĂȂ߁A݃`FbÑ`FbN͂Ȃ
	 * @param newPackageMap@pbP[WMap
	 */
	public static void add(Map<Integer, String> newPackageMap) {
		packageMap.putAll(newPackageMap);
	}

	/**
	 * pbP[WpbP[WID擾
	 * @param packageName pbP[W
	 * @return pbP[WID(݂Ȃꍇnull)
	 */
	public static Integer getPackageId(String packageName) {
		for(Entry<Integer, String> packageInfo: packageMap.entrySet()) {
			if (packageInfo.getValue().equals(packageName)) {
				return packageInfo.getKey();
			}
		}
		return null;
	}
	
	/**
	 * 	pbP[WIDpbP[W擾
	 * @param packageId
	 * @return
	 */
	public static String getPackageName(Integer packageId) {
		return packageMap.get(packageId);
	}

	/**
	 * o^ꂽpbP[W̓et@Co͌`ɕϊ
	 * @return
	 */
	public static String write() {
		StringBuffer buffer = new StringBuffer();
		for (Integer packageId : packageMap.keySet()) {
			if (isUserDefinitionPackage(packageId)) {
				buffer.append(PackageType.PACKAGE.alias());
				buffer.append(DELIMITER);
				buffer.append(packageId);
				buffer.append(DELIMITER);
				buffer.append(packageMap.get(packageId));
				buffer.append(System.getProperty("line.separator"));
			}
		}
		return buffer.toString();
	}
	
	/**
	 * [U`pbP[Wǂ𔻒f
	 * @param packageId 
	 * @return [U`pbP[W:trueAVXe`pbP[WFfalse
	 */
	public static boolean isUserDefinitionPackage(int packageId) {
		if ( packageId < PACKAGE_DEFAULT_ID ) {
			return true;
		} 
		return false;
	}
	
	/**
	 * C|[gKvȃpbP[WȂ̂𔻒肷
	 * @param packageId pbP[WID
	 * @return C|[gKvFtrue,svFfalse
	 */
	public static boolean isNeedImport(int packageId) {
		if (PACKAGE_DEFAULT_ID == packageId || PACKAGE_JAVA_LANG_ID == packageId) {
			return false;
		} 
		return true;
	}
	
}
