package pbl2011.model;

import java.awt.Point;
import pbl2011.common.Util;

/**
 * NX
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class ClassModel extends ClassNode {

	public ClassModel(String line) {

		String[] tokens = line.split(DELIMITER);

		int i = 0;
		
		classType = ClassType.aliasOf(tokens[i++]);
		classId = Integer.parseInt(tokens[i++]);
		
		className = tokens[i++];
		visibility = VisibilityType.aliasOf(tokens[i++]);
		p = Util.adjust(new Point(Integer.parseInt(tokens[i++]), Integer
				.parseInt(tokens[i++])));
		height1 = Util.adjust(Integer.parseInt(tokens[i++]));
		height2 = Util.adjust(Integer.parseInt(tokens[i++]));
		height3 = Util.adjust(Integer.parseInt(tokens[i++]));
		width = Util.adjust(Integer.parseInt(tokens[i++]));
		try {
			packageId = Integer.parseInt(tokens[i++]);			
		} catch (ArrayIndexOutOfBoundsException e) {
			packageId = Integer.valueOf(PACKAGE_DEFAULT_ID);						
		}
		
		try {
			colorRed = Integer.parseInt(tokens[i++]);
			colorGreen = Integer.parseInt(tokens[i++]);
			colorBlue = Integer.parseInt(tokens[i++]);
		} catch (ArrayIndexOutOfBoundsException e) {
			colorRed = CLASS_COLOR_RED;
			colorGreen = CLASS_COLOR_GREEN;
			colorBlue = CLASS_COLOR_BLUE;
		}

	}

	public ClassModel(int id, Point pt) {

		classId = id;
		packageId = 0;
		delFlag = false;
		className = "";
		visibility = VisibilityType.PUBLIC;

		p = pt;
		height1 = CLASS_HEIGHT1;
		height2 = CLASS_HEIGHT2;
		height3 = CLASS_HEIGHT3;
		width = CLASS_WIDTH;
		colorRed = CLASS_COLOR_RED;
		colorGreen = CLASS_COLOR_GREEN;
		colorBlue = CLASS_COLOR_BLUE;
	}

	public ClassModel(ClassModel clone) {
		classType = clone.classType;
		classId = clone.classId;
		className = clone.className;
		visibility = clone.visibility;
		p = new Point(clone.p.x, clone.p.y);
		height1 = clone.height1;
		height2 = clone.height2;
		height3 = clone.height3;
		width = clone.width;
		colorRed = clone.colorRed;
		colorGreen = clone.colorGreen;
		colorBlue = clone.colorBlue;
		packageId = clone.packageId;
		delFlag = clone.delFlag;
		for(Method m : clone.methodList) {
			Method copy = m.clone();
			methodList.add(copy);
		}
		for(Attribute a : clone.attributeList) {
			Attribute copy = a.clone();
			attributeList.add(copy);
		}
		undoredoModel = clone.undoredoModel;
	}

	/**
	 * VXe`ς݃NX[ĥɗpRXgN^
	 * @param classId NXID
	 * @param packageId pbP[WID
	 * @param classType NX^Cv
	 * @param className NX
	 */
	public ClassModel(int classId, int packageId, String className) {
		this.classId = classId;
		this.packageId = packageId;
		this.classType = ClassType.CLASS;
		this.className = className;
		this.visibility = VisibilityType.PUBLIC;
		this.delFlag = false;
		this.isBuiltInClass = true;
		
	}
	
	/**
	 * t@CǂݍݎɉoȂ^ݒ肷邽߂ɗpRXgN^
	 * @param classId NXID
	 * @param classType NX^Cv
	 * @param className NX
	 */
	public ClassModel(int classId, String className) {
		this.classId = classId;
		this.packageId = PACKAGE_DEFAULT_ID;
		this.classType = ClassType.CLASS;
		this.className = className;
		this.visibility = VisibilityType.PUBLIC;
		this.delFlag = false;
		this.p = null;
		this.height1 = CLASS_HEIGHT1;
		this.height2 = CLASS_HEIGHT2;
		this.height3 = CLASS_HEIGHT3;
		
	}
	@Override
	public String toString() {
 		return classType.alias()
 			+ DELIMITER + classId
 			+ DELIMITER + className + DELIMITER + visibility.alias()
 			+ DELIMITER + p.x + DELIMITER + p.y
 			+ DELIMITER + height1 + DELIMITER + height2 + DELIMITER + height3
 			+ DELIMITER + width
			+ DELIMITER + packageId
			+ DELIMITER + colorRed
			+ DELIMITER + colorGreen
			+ DELIMITER + colorBlue;
	}

	public ClassModel clone() {
		return new ClassModel((ClassModel) super.clone());
	}
}
