package pbl2011.model;

import pbl2011.common.CommonConst;

/**
 * 
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class Attribute implements CommonConst, Cloneable {

	public Attribute(String attributeName, String typeId, VisibilityType visibilityType) {
	this.attributeName = attributeName;
	this.typeId = typeId;
	this.visibility = visibilityType;
}

	public Attribute(Attribute clone) {
		attributeName = clone.attributeName;
		typeId = clone.typeId;
		visibility = clone.visibility;
		delFlag = clone.delFlag;
	}

	/**  */
	public String attributeName;

	/** ߂l^ */
	public String typeId;

	/**  */
	public VisibilityType visibility;

	/** 폜tO */
	public boolean delFlag;

	public String toString(int classId) {

		return MethodAndAttrType.ATTRIB.alias() + DELIMITER + attributeName + DELIMITER + typeId
				+ DELIMITER + visibility.alias();
	}

	// XV
	public void change(String name, String typeId, VisibilityType visi) {
		this.attributeName = name;
		this.typeId = typeId;
		this.visibility = visi;

	}

	public String visibilityMark() {
		return visibility.mark();
	}

	public Attribute clone() {
        try {
            return new Attribute((Attribute)super.clone());
        } catch(CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
	
	public boolean equals(Object o) {
		
		if (o == null) {
			return false;
		}
		Attribute a = (Attribute)o;
		
		if (!this.attributeName.equals(a.attributeName)) {
			return false;
		}
		
		if (!this.typeId.equals(a.typeId)) {
			return false;
		}
		
		if (!this.visibility.equals(a.visibility)) {
			return false;
		}
		
		if (this.delFlag != a.delFlag) {
			return false;
		}
		
		return true;
	}
}
