package pbl2011.gui;

import java.util.ArrayList;
import java.util.List;

import pbl2011.model.AssociationArc;
import pbl2011.mvc.Model;

public class RelationForm extends DetailForm {

	public RelationForm(Model m) {
		super(m);
	}

	@Override
	List<String[]> getComboData() {
		List<String[]> l = new ArrayList<String[]>();
		l.add(null);
		l.add(NAVIGABLE_LIST);
		l.add(null);
		l.add(MULTIPLE_LIST);
		return l;
	}

	@Override
	String[] getTableCol() {
		return new String[] { "[", "U\", "^[Qbg", "dx" };
	}

	@Override
	String[][] getTableData() {
		String[][] data;
		if (clone != null) {

			List<AssociationArc> target = myModel.getTargetAssocList(clone);
			List<AssociationArc> source = myModel.getSourceAssocList(clone);

			data = new String[target.size() + source.size()][4];
			int i = 0;
			for (AssociationArc a : target) {
				data[i][0] = a.roleTarget;
				data[i][1] = Boolean.toString(a.naviTarget);
				data[i][2] = (myModel.getClassData(a.classIdSource)).className;
				data[i][3] = a.multiplTarget;
				i++;
			}

			for (AssociationArc a : source) {
				data[i][0] = a.roleSource;
				data[i][1] = Boolean.toString(a.naviSource);
				data[i][2] = (myModel.getClassData(a.classIdTarget)).className;
				data[i][3] = a.multiplSource;
				i++;
			}
		} else {
			data = new String[0][4];
		}
		return data;
	}

	@Override
	void updateModel(int sc) {
		AssociationArc at;
		List<AssociationArc> target = myModel.getTargetAssocList(clone);
		List<AssociationArc> source = myModel.getSourceAssocList(clone);
		if (sc < target.size()) {
			at = target.get(sc);

			myModel.changeAssociationArc("t", at, (String) table.getValueAt(sc,
					0), Boolean.valueOf((String) table.getValueAt(sc, 1)),
					(String) table.getValueAt(sc, 3), sc);
		} else {
			int no = sc - target.size();
			at = source.get(no);
			myModel.changeAssociationArc("s", at, (String) table.getValueAt(sc,
					0), Boolean.valueOf((String) table.getValueAt(sc, 1)),
					(String) table.getValueAt(sc, 3), sc);
		}

	}
}
