package pbl2011.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;

import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

import pbl2011.common.CommonConst;
import pbl2011.mvc.CurrentManager;
import pbl2011.mvc.Model;

/**
 * NX}GfB^pl
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class ClassDiagramsPanel extends JPanel implements CommonConst {

	UMLCanvas mainCanvas;
	Model m;
	CurrentManager cu;
	
	public ClassDiagramsPanel(){}
	
	public ClassDiagramsPanel(ClassEditorFrame editor) {

		mainCanvas = editor.getMainCanvas();
		m = mainCanvas.getModel();
		cu = m.getCurrentManager();
		setBackground(Color.WHITE);
		setLayout(new BorderLayout());

		ParameterEditor paramEditer = new ParameterEditor(m);
		ClassDetailEditor detailEditer = new ClassDetailEditor(m, paramEditer);
		JSplitPane splitPane1 = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				detailEditer, paramEditer);
		splitPane1.setOneTouchExpandable(true);
		splitPane1.setDividerSize(10);
		splitPane1.setDividerLocation(Integer.MAX_VALUE);
		splitPane1.setMinimumSize(new Dimension(0,0));

		JSplitPane rightSplit = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				new JScrollPane(mainCanvas), splitPane1);
		rightSplit.setOneTouchExpandable(true);
		rightSplit.setDividerSize(10);
		rightSplit.setDividerLocation(Integer.MAX_VALUE);

		SubCanvas sub = new SubCanvas(m, editor.getSubCanvas());
		sub.setMinimumSize(new Dimension(0,0));
		JSplitPane leftSplit = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,
				sub, rightSplit);
		leftSplit.setOneTouchExpandable(true);
		leftSplit.setDividerSize(10);
		leftSplit.setDividerLocation(305);
		add(leftSplit, BorderLayout.CENTER);

	}

	public void copy() {
		cu.copy();
	}

	public void cut() {
		cu.cut();
	}

	public void paste() {
		cu.paste();
	}

	public void delete() {
		m.deleteClass();
	}

	public void selectAll() {
		cu.clear();
		cu.addCurrentClasses(m.getAllActiveClassData());
	}

	public void setFont(Font font) {
		State.font = font;
		if (m != null ) {
			m.changeModel();
		}
	}

	/**
	 * ctrl + z L[܂̓j[猳ɖ߂w肵ꍇɌĂ΂
	 */
	public void undo() {
		cu.undo();
		mainCanvas.draw();
	}

	/**
	 * ctrl + y L[܂̓j[蒼w肵ꍇɌĂ΂
	 */
	public void redo() {
		cu.redo();
		mainCanvas.draw();
	}


}

/**
 * c[UMLr[
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
class SubCanvas extends JPanel implements CommonConst {

	SubCanvas(Model m, UMLCanvas uml) {

		setLayout(new BorderLayout());
		JSplitPane split = new JSplitPane(JSplitPane.VERTICAL_SPLIT,
				new JScrollPane(new TreeInfo(m)), new JScrollPane(uml));
		split.setOneTouchExpandable(true);
		split.setDividerSize(10);
		split.setDividerLocation(400);
		add(split,BorderLayout.CENTER);

	}
}
