package pbl2011.gui;

import java.util.ArrayList;
import java.util.List;

import pbl2011.model.Attribute;
import pbl2011.mvc.Model;

public class AttributeForm extends DetailForm {

	public AttributeForm(Model m) {
		super(m);
	}

	@Override
	List<String[]> getComboData() {
		List<String[]> l = new ArrayList<String[]>();
		l.add(null);
		l.add(myModel.getTypeList());
		l.add(VISIBILITY_LIST);
		return l;
	}

	@Override
	String[] getTableCol() {
		return new String[] { "O", "^", "" };
	}

	@Override
	String[][] getTableData() {
		String[][] data;
		if (clone != null) {
			data = new String[clone.attributeList.size()][3];

			int i = 0;
			for (Attribute a : clone.attributeList) {
				data[i][0] = a.attributeName;
				data[i][1] = myModel.getTypeNameByTypeId(a.typeId);
				data[i][2] = a.visibility.alias();
				i++;
			}
		} else {
			data = new String[0][3];
		}
		return data;
	}

	@Override
	void updateModel(int sc) {
		clone.changeAttribute(sc, (String) table.getValueAt(sc, 0),
				myModel.getTypeIdByTypeName((String) table.getValueAt(sc, 1)),
				VisibilityType.aliasOf((String) table.getValueAt(sc, 2)));

	}
}
