package ash.util;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import javax.swing.ImageIcon;
import java.net.URL;

/**
 * t@Ĉ߂̔ėp̃[eBeB
 */
public class FileUtil {
	/**
	 * BufferedReader 쐬p֗̕\bh
	 */
	public static BufferedReader openReader(File file) throws IOException {
		return new BufferedReader(new FileReader(file));
	}

	/**
	 * BufferedWriter 쐬p֗̕\bh
	 */
	public static BufferedWriter openWriter(File file) throws IOException {
		OutputStream os = new FileOutputStream(file);
		return new BufferedWriter(new OutputStreamWriter(os));
	}
	public static BufferedWriter openWriter(File file, boolean append)
		throws IOException {
		OutputStream os = new FileOutputStream(file, append);
		return new BufferedWriter(new OutputStreamWriter(os));
	}

	public static String lastModified(File file) {
		Date d = (file == null) ? null : new Date(file.lastModified());
		return Util.formatDate(d);
	}

	/**
	 * eLXgt@CsPʂŕǂݎ蕶̔zB
	 * @param file t@C
	 * @return eLXgt@C̕zisꍇnullj
	 */
	public static String[] readStringArray(File file) {
		try {
			return readStringArrayEx(file);
		} catch(IOException e) {
			Log.debug(e);
			return null;
		}
	}
	private static final int FILE_LINES = 2048;
	public static String[] readStringArrayEx(File file) throws IOException {
		BufferedReader reader = null;
		try {
			reader = new BufferedReader(new FileReader(file));
			List<String> as = new ArrayList<String>(FILE_LINES);
			String line;
			while((line = reader.readLine()) != null) as.add(line);
			return Util.toArray(as);
		} finally {
			if(reader != null) reader.close();
		}
	}

	public static void writeStringArray(String[] text, File file)
		throws IOException {
		BufferedWriter writer = null;
		try {
			writer = openWriter(file);
			for(String line : text) {
				writer.write(line, 0, line.length());
				writer.newLine();
			}
		} finally {
			if(writer != null && file != null) writer.close();
		}
	}

	public static String readText(File file) {
		BufferedReader reader = null;
		try {
			reader = openReader(file);
			StringBuilder sb = new StringBuilder();
			String line;
			while((line = reader.readLine()) != null) {
				sb.append(line);
				sb.append('\n');
			}
			return sb.toString();
		} catch(IOException e) {
			return null;
		} finally {
			try {
				if(reader != null) reader.close();
			} catch(IOException e) {}
		}
	}
	public static boolean writeText(String text, File file) {
		BufferedWriter writer = null;
		try {
			writer = openWriter(file);
			writer.write(text, 0, text.length());
			return true;
		} catch(IOException e) {
			return false;
		} finally {
			try {
				if(writer != null) writer.close();
			} catch(IOException e) {}
		}
	}
	
	/**
	 * pX𐳋K\ɕϊB
	 * pX̕'/'ƂAfBNg̏ꍇŌ'/'tB
	 */
	public static String getFullPath(File path) {
		try {
			String pathname = normalPath(path.getCanonicalPath());
			if(!path.isDirectory()) return pathname;
			return pathname + "/";
		} catch(IOException e) {
			return getPath(path);
		}
	}

	/**
	 * w肵fBNg̃t@C̑΃pX擾B
	 * t@Cnull̏ꍇ "./"ԂB
	 * @param file Ώۂ̃t@C
	 * @param dir fBNg
	 * @return ΃pX
	 */
	public static String getPath(File file, File dir) {
		if(file == null) return "./";
		String filepath = getFullPath(file);
		String dirpath = getFullPath(dir);
		if(!filepath.startsWith(dirpath)) return filepath;
		if(filepath.equals(dirpath)) return "./";
		return filepath.substring(dirpath.length());
	}

	/**
	 * pX𐳋K\ɕϊB
	 * fBNg̏ꍇ '/'tȂB
	 */
	public static String getFullPathU(File path) {
		try {
			return normalPath(path.getCanonicalPath());
		} catch(IOException e) {
			return normalPath(path.getPath());
		}
	}
	/**
	 * t@C̐K\̃pX擾B
	 * fBNg̏ꍇ '/'tB
	 */
	public static String getPath(File file) {
		String pathname = normalPath(file.getPath());
		if(file.isDirectory()) return pathname + "/";
		return pathname;
	}

	/**
	 * pX̕'/'Ƃ
	 */
	public static String normalPath(String path) {
		return path.replace(File.separatorChar, '/');
	}

	/**
	 * t@CTtBbNXoA(lower case)ɕϊĕԂB
	 */
	public static String getSuffix(String path) {
	// path = nnnnnn.sss
	// path = pppp/nnnnnn.sss
	// path = http://hhh.hhh.hhh/pppp/nnnnnn.sss
	// path = file:pppp/nnnnnn.sss
	// path = file:nnnnnn.sss
		if(path.endsWith("/")) return null;
		int idx = Math.max(path.lastIndexOf('/'), path.indexOf(':'));
		int idx1 = (idx < 0) ? 0 : (idx + 1);	// nnnnnn.sss ̊Jnʒu
		int idx2 = path.lastIndexOf('.');		// .sss̊Jnʒu
		if(idx1 <= idx2) {
			//name = path.substring(idx1, idx2);	  // nnnnnn
			String suffix = path.substring(idx2+1);		  // sss
			return suffix.toLowerCase();
		}
		return null;							// TtBbNXȂB
	}

	
	/**
	 * Ɨp̈ꎞt@C쐬B
	 * File.createTempFile() ͑w̉Kł͐삵Ȃ̂Ŏ삵B
	 * CA,080924
	 */
	private static File tmpDir = null;
	private static int tmpFileSerial = 0;
	public static synchronized File createTempFile() throws IOException {
		// return File.createTempFile("ash",".tmp");
		if(tmpDir == null) tmpDir = new File(".tmpfiles");
		if(!tmpDir.exists() || !tmpDir.mkdir()) tmpDir = new File(".");
		File tmpFile;
		do {
			tmpFileSerial++;
			tmpFile = new File(tmpDir, "ash.tmp#" + tmpFileSerial);
			Log.debug(1, "tmpFile=" + tmpFile);
		} while(tmpFile.exists());
		return tmpFile;
	}

	/**
	 * w肳ꂽÕC[WACRԂB
	 * @param cls ĂяõNX
	 * @param fname C[Wt@C̖O
	 * @return C[WACR
	 */
	public static ImageIcon makeImageIcon(Class cls, String fname) {
		URL url = getResource(cls, "images/" + fname);
		if(url != null) return new ImageIcon(url);
		return null;
	}

	/**
	 * w肳ꂽ\[XURLԂB
	 * @param cls ĂяõNX
	 * @param path \[X̃pX
	 * @return \[XURL
	 */
	public static URL getResource(Class cls, String path) {
		URL url = getClassLoader(cls).getResource(path);
		if(url == null) System.err.println("t@C݂܂: " + path);
		return url;
	}

	/**
	 * NX[_擾B
	 * @param cls ĂяõNX
	 * @return NX[_
	 */
	public static ClassLoader getClassLoader(Class<?> cls) {
	    ClassLoader cloader = Thread.currentThread().getContextClassLoader();
	    if (cloader == null) cloader = cls.getClassLoader();
	    return cloader;
	}
}
