package ash.reverse.uml;
import java.util.List;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.Matcher;
import java.io.File;
import java.io.IOException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.PrintStream;
import java.awt.Font;
import static java.awt.Font.*;
import ash.reverse.parser.JavaParser;
import ash.reverse.struct.FileRecord;

/**
 * UMLNX}c[FJava\[XR[h͂UMLNX}GfB^
 * ͂ƂȂf[^𐶐B
 * <p>
 * gp@PFR}hCs
 * <pre>
 *	java -cp build reverse.uml.UMLTool -c1234ab -prd -f<font> <src-dir>...
 *	</pre>
 * <p>
 * gp@QFvOĂяo
 * <pre>
 * UMLTool uml = new UMLTool();
 * uml.setFont(new Font(SERIF,PLAIN,14));
 * uml.setParams(4, true, true); uml.setParams("c4ab");	// NX}̏ꍇ
 * uml.setParams("prd");		// pbP[W}̏ꍇ
 * uml.parse("src/pbl2011/mvc");
 * uml.parse("src/pbl2011/gui");
 * uml.generateUML(System.out);
 *	</pre>
 * @author C.Akiguchi
 */
public class UMLTool {
	public static void main(String... args) {
		new UMLTool(args);
	}

	/**
	 * R}hCsꍇ̃RXgN^B
	 * ̃RXgN^̒łׂĂ̏ĂB
	 * @param args R}hC̃p[^
	 */
	private UMLTool(String... args) {
		int i = 0;
		for(String arg : args) {
			if(arg.startsWith("-f")) {
				setFont(arg.substring(2));
			} else if(arg.startsWith("-")) {
				setParams(arg.substring(1));
			} else {
				parse(arg);
			}
		}

		// UMLNX}GfB^̃t@CtH[}bgŃNXo͂B
		generateUML(System.out);
	}

	// -f 'BI20%MS Gothic'
	static final String FONTDEF = "([PBI]+)(\\d+)(@(.+))$";
	//                             @1      @2      @4
	static private Pattern fontDefPat = Pattern.compile(FONTDEF);

	/**
	 * tHg񂩂tHg背CAEgvZŎgptHgɐݒ肷B
	 * @param fontInfo tHg('BI20%MS Gothic')
	 */
	private void setFont(String fontInfo) {
		Matcher m = fontDefPat.matcher(fontInfo);
		if(m.find()) {
			String name = m.group(3);
			int size = Integer.parseInt(m.group(2));
			int style = 0;
			for(char c : m.group(1).toCharArray()) {
				switch(c) {
				case 'P': style |= PLAIN; break;
				case 'B': style |= BOLD; break;
				case 'I': style |= ITALIC; break;
				}
			}
			font = new Font(name, style, size);
		}
	}

	/**
	 * vOĂяoꍇɎgpRXgN^
	 */
	public UMLTool() {}

	/**
	 * CAEgvZŎgptHgɐݒ肷B
	 * @param font CAEgvZŎgptHg
	 */
	public void setFont(Font font) {
		this.font = font;
	}

	/**
	 * NX}ɕKvȃp[^ݒ肷B
	 * @param params IvV(-c1234abprd")
	 * c:NX}  1: public  2: protected  3: package  4: private
	 * a:̌^Qƈˑ֌W̐  b:\bh{̂̌^Qƈˑ֌W̐
	 * p:pbP[W}  r:OpbP[WQ  d:`NX\
	 */
	public void setParams(String params) {
		for(char c : params.toCharArray()) {
			switch(c) {
			case 'c': cflag = true; break;	// NX}
			case 'p': pflag = true; break;	// pbP[W}
			case '1': case '2': case '3': case '4':	// ̑Ix
				selectLevel = c - '0'; break;
			case 'a': aflag = true; break;	// ̈ˑ֌W
			case 'b': bflag = true; break;	// \bh{̂̈ˑ֌W
			case 'r': rflag = true; break;	// OpbP[WQ
			case 'd': dflag = true; break;	// `NX\
			}
		}
	}

	/**
	 * NX}ɕKvȃp[^ݒ肷B
	 * @param selectLevel ̑Ix<p>
	 * 						1: public  2: protected  3: package  4: private
	 * @param aflag ̌^Qƈˑ֌W̐
	 * @param bflag \bh{̂̌^Qƈˑ֌W̐
	 */
	public void setParams(int selectLevel, boolean aflag, boolean bflag) {
		this.selectLevel = selectLevel;
		this.aflag = aflag;
		this.bflag = bflag;
	}

	/**
	 * UMLNX}𐶐B
	 * @param out UMLNX}̏o͐
	 */
	public void generateUML(PrintStream out) {
		if(cflag)
			ClsGenerator.generate(out, fileList, font, selectLevel,aflag,bflag);
		if(pflag)
			PkgGenerator.generate(out, fileList, font, rflag, dflag);
	}

	private boolean cflag = false;	// NX}
	private boolean pflag = false;	// pbP[W}
	private int selectLevel = 0;	// ̑Ix
	// 0: no member  1: public  2: protected  3: package  4: private
	private boolean aflag = false;	// ̌^Qƈˑ֌W̐
	private boolean bflag = false;	// \bh{̂̌^Qƈˑ֌W̐
	private boolean rflag = false;	// OpbP[WQ
	private boolean dflag = false;	// `NX\
	private Font font = null;		// CAEgvZŎgptHg

	// t@CpbP[WL^ƂĊǗ郊Xg
	private List<FileRecord> fileList = new ArrayList<FileRecord>();

	/**
	 * w肳ꂽfBNg̔zJava\[Xt@C͂A
	 * NX}𒊏oB
	 * @param dirpath Java\[Xt@C܂ރfBNg
	 */	
	public void parse(String dirpath) {
		File dir = new File(dirpath);
		if(dir != null) {
			parseSub(dir);
		} else {
			printErr(dirpath + ": pXmFĉB");
		}
	}

	private void parseSub(File path) {
		if(path.isDirectory()) {
			File[] files = path.listFiles();
			if(files != null) {
				for(File f : files) parseSub(f);
			} else {
				printErr(path.getName() + ": ANZX܂B");
			}
		} else if(path.getName().endsWith(".java")) {
			BufferedReader reader = null;
			try {
				reader = new BufferedReader(new FileReader(path));
				parseJavaCode(reader, path);
			} catch(IOException e) {
				printErr(path.getName() + ": t@C̉͂ł܂B");
			} finally {
				if(path != null && reader != null) 
					try { reader.close(); } catch(IOException e) {}
			}
		}
	}

	void printErr(Object msg) { System.err.println(msg); }

	/**
	 * Java\[Xt@C̃[_\[XeLXgǂݍ݁A
	 * NX}ɕKvȏ𒊏oB
	 * @param reader Java\[Xt@C̃[_
	 */
	protected void parseJavaCode(BufferedReader reader, File path)
		throws IOException {
		JavaParser parser = new JavaParser(reader, path.getName(), true);
		FileRecord frec = parser.parse();
		fileList.add(frec);
	}
}
