package ash.reverse.uml;
import java.util.List;
import java.util.ArrayList;
import java.io.PrintStream;
import javax.swing.JLabel;
import java.awt.Font;
import java.awt.FontMetrics;
import ash.reverse.struct.FileRecord;

/**
 * UML_CAO𐶐邽߂̃x[XNXB
 */
class UMLDiagram implements UMLConst {
	static final int MARGIN = 24;
	static final int MAX_HEIGHT = 800;

	/** CAEgvZŎgptHggbNX */
	protected FontMetrics fm;

	/** Ot̃m[hێ郊Xg */
	protected List<ClassNode> nodeList = new ArrayList<ClassNode>();

	/** Ot̃A[N̏ێ郊Xg */
	protected List<Relationship> relList = new ArrayList<Relationship>();

	/**
	 * CAEgvZŎgptHgݒ肷B
	 * @param font CAEgvZŎgptHg
	 */
	void setFont(Font font) {
		if(font != null) {
			fm = new JLabel().getFontMetrics(font);
			assert trace("height=" + fm.getHeight() +
						 ", width=" + fm.stringWidth("Hello"));
		}
	}

	/**
	 * UML_CAO𐶐B
	 * @param out UML_CAȌo͐
	 */
	public void generateDiagram(PrintStream out) {
		int xpos = MARGIN;
		int ypos = MARGIN;
		int seq = 0;
		int maxWidth = 0;

		// m[hCAEgāA_CAOo͂B
		for(ClassNode cn : nodeList) {
			int width = cn.width();
			int height = cn.height();
			int y = ypos + MARGIN + height;
		
			if(seq > 0 && y > MAX_HEIGHT) {
				xpos += MARGIN + maxWidth;
				ypos = MARGIN;
				seq = 0;
				maxWidth = 0;
			}
			if(width > maxWidth) maxWidth = width;
			seq++;
			cn.setLocation(xpos, ypos);
			ypos += height + MARGIN;
			cn.print(out);
		}

		out.println();

		// ֌Wo͂B
		for(Relationship rel : relList) out.println(rel.umlFormat());
	}

	boolean trace(Object msg) {
		System.err.println(msg);
		return true;
	}
}
