package ash.reverse.parser;

/**
 * ȊOJavȁCq̒`
 * <pre>
 * gpF
 * int flags |= Mod.mask("static");
 * flags |= Mod.mask("final");
 * if(Mod.STATIC.in(flags)) {}
 * Mod mod = Mod.value(token);
 * if(mod.in(flags)) {...}
 * </pre>
 */
public enum Mod {
	ABSTRACT("abstract"),
	STATIC("static"),
	FINAL("final"),
	NATIVE("native"),
	STRICTFP("strictfp"),
	SYNCHRONIZED("synchronized"),
	TRANSIENT("transient"),
	VOLATILE("volatile"),
	UNDEF("????");

	Mod(String keyword) { this.keyword = keyword; }

	/**
	 * eXgR[h
	 */
	public static void main(String[] args) {
		print("native -> " + Mod.value("native"));
		print("whatisthis -> " + Mod.value("whatisthis"));
		print("#native -> " + Mod.index("native"));
		print("#whatisthis -> " + Mod.index("whatisthis"));
		for(Mod mod : Mod.values())
			print(mod.name() + ": " + mod.keyword +
				  ", index = " + mod.index() +
				  ", mask = " + mod.mask()
				  );
		int modifiers = 0;
		modifiers |= Mod.mask("static");
		modifiers |= Mod.mask("final");
		modifiers |= Mod.mask("synchronized");
		print("modifiers=" + modifiers);
		modifiers |= Mod.mask("whatisthis");
		print("modifiers=" + modifiers);
		print("'" + Mod.toCode(modifiers) + "'");

		assert Mod.STATIC.in(modifiers): "Mod.STATIC.in(modifiers)";
		assert !Mod.UNDEF.in(modifiers): "Mod.UNDEF.in(modifiers)";
		assert !Mod.TRANSIENT.in(modifiers): "Mod.TRANSIENT.in(modifiers)";
	}

	private static void print(Object obj) { System.out.println(obj); }

	/** JavaL[[h\ */
	public final String keyword;
	public String keyword() { return keyword; }

	/**
	 * 0n܂ӂȘA
	 * Clint^̃rbgƂĕ\̃rbgʒuCfbNX
	 */
	private int index;
	public int index() { return index; }

	/** index̊Jnl */
	private static int seq = 0;
	static {
		for(Mod m : values()) m.index = seq++;
	}

	/**
	 * indexl̃rbgɑΉ鐮lԂB
	 * @return indexl̃rbgɑΉ鐮l
	 */
	public int mask() {
		return 1 << index;
	}

	/**
	 * w肳ꂽClZbgɂ̗񋓒l܂܂Ă邩肷B
	 * @param modifiers ClZbg
	 * @return ̗񋓒lClZbgɊ܂܂ĂȂtrue
	 */
	public boolean in(int modifiers) {
		return this != UNDEF && (modifiers & (1 << index)) != 0;
	}
		
	/**
	 * JavaL[[henuml擾B
	 * @param keyword JavaL[[h
	 * @return Ήenuml
	 */
	public static Mod value(String keyword) {
		for(Mod mod : values()) {
			if(mod.keyword.equals(keyword)) return mod;
		}
		return UNDEF;
	}

	/**
	 * JavaL[[hindexl擾B
	 * @param keyword JavaL[[h
	 * @return Ήindexli݂Ȃꍇ-1j
	 */
	static int index(String keyword) {
		Mod mod = value(keyword);
		if(mod == UNDEF) return -1;
		return mod.index;
	}

	/**
	 * JavaL[[hindexl̃rbgɑΉ鐮l擾B
	 * @param keyword JavaL[[h
	 * @return Ή}XNli݂Ȃꍇ0j
	 */
	public static int mask(String keyword) {
		int index = index(keyword);
		if(index < 0) return 0;
		return 1 << index;
	}

	/**
	 * w肳ꂽClZbgJavaL[[hŕ\ԂB
	 * @param modifiers ClZbg
	 * @return w肳ꂽClZbgJavaL[[h\
	 */
	public static String toCode(int modifiers) {
		StringBuilder sb = new StringBuilder();
		for(Mod mod : values()) {
			if((modifiers & mod.mask()) != 0)
				sb.append(mod.keyword + " ");
		}
		return sb.toString();
	}
}
