package ash.gui.core;
import java.io.File;
import java.io.IOException;
import java.io.BufferedWriter;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import ash.util.FileUtil;

/**
 * GUIAdapter ash/gui/corepbP[Wash.utilȊÕpbP[WƔˑ
 * 邽߂ɁAˑR|[lgɒdg݂񋟂B
 * <pre>
 * AshTerminal        -> GUIAdapter.setAshFacade(ashFacade)
 * AshGUIFrame/AshToolBar/AshPanel/AshMenu/AshPopupMenu
 *                    -> GUIAdapter.getListener()
 * AshFileChooser/AshGUIViewer -> GUIAdapter.findFile(path)
 * AshForm            -> GUIAdapter.readTextFile(fname)/openWriter(fname)
 * AshTEditFrame/AshGUIViewer  -> GUIAdapter.openViewer(path, lineNum)
 * AshGrepDialog      -> GUIAdapter.getOpenCommand()
 * </pre>
 */
public class GUIAdapter {
	static private AshFacade ashFacade = new AshFacade() {
			@Override public File findFile(String path) {
				return new File(path);
			}
			@Override public String evalVar(String varName) {
				return null;
			}
			@Override public void sendAshCommand(String command) {
				System.out.println(command);
			}
		};
	static public void setAshFacade(AshFacade ashFacade) {
		GUIAdapter.ashFacade = ashFacade;
	}

	static private ActionListener listener = new ActionListener() {
			@Override public void actionPerformed(ActionEvent ae) {
				sendAshCommand(ae.getActionCommand());
			}};
	static public ActionListener getListener() { return listener; }

	static public File findFile(String path) {
		return ashFacade.findFile(path);
	}
	static public void sendAshCommand(String command) {
		ashFacade.sendAshCommand(command);
	}

	static public String[] readTextFile(String fname) {
		return FileUtil.readStringArray(findFile(fname));
	}
	static public BufferedWriter openWriter(String fname) throws IOException {
		return FileUtil.openWriter(findFile(fname));
	}

	private static final String FILE_VIEWER = "tview -g";
	private static String params = "";

	/**
	 * w肳ꂽp[^Ńt@CI[vB
	 * @param lineNum t@C̍sԍi擪s͂Pj
	 * @param path t@C̃pX
	 */
	public static void openViewer(String path, String lineNum) {
		params = lineNum + " '" + path + "'";
		sendAshCommand(getOpenCommand());
	}
	/**
	 * t@CI[v}hԂB
	 * @return t@CI[vER}h
	 */
	public static String getOpenCommand() {
		String viewer = ashFacade.evalVar("FILE_VIEWER");
		if(viewer == null) viewer = FILE_VIEWER;
		return viewer + params;
	}
}
