package ash.gui.core;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Point;
import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JToolBar;
import javax.swing.JLabel;
import static java.awt.event.KeyEvent.VK_S;
import ash.util.Log;

/**
 * AshGUIFraméAAshW GUIt[쐬邽߂̃x[XNXłB
 * <p>AshW GUIt[͈ȉ̍\ƂB
 * <ul>
 * <li>j[o[
 * <li>^XNo[
 * <li>`̈
 * <li>Xe[^Xo[ibZ[W\̈AJ[\ʒu\̈j
 * </ul>
 * Factory Method p^[
 * <p>
 * j[o[A^XNo[A`̈́AAvP[V@\ɉ
 * IuWFNg̐KvɂȂ̂ŁAꂼgNXŊY
 * IuWFNg𐶐郁\bh FactoryMethod ƂĐB
 * <p>
 * AshGUIFrameł́Aj[^XNo[𐶐邽߂̃[eBeBNX
 * 񋟂ĂB
 */
@SuppressWarnings("serial")
public class AshGUIFrame extends JFrame implements ActionListener {
	/**
	 * RXgN^F
	 * j[o[Ɖʗ̈̃R|[lg𐶐B
	 */
	public AshGUIFrame() {
		init();
	}
	public AshGUIFrame(String title) {
		super(title);
		init();
		construct();
		pack();
	}
	private JPanel contentPane;

	/**
	 * ʍ\zOɎs鏉
	 */
	private void init() {
		addWindowListener(new WindowAdapter() {
				public void windowClosing(WindowEvent e) { disposeFrame(); }
			});
		contentPane = (JPanel)getContentPane();
		setJMenuBar(createMenuBar());	// j[o[̍쐬Ɛݒ
	}

	/**
	 * ʗ̈̃R|[lg\zAʂB
	 * ftHgł́Ac[o[A`̈AXe[^Xo[𐶐B
	 */
	protected void construct() {
		setNorth(createToolBar());		// c[o[̍쐬Ɛݒ
		setCenter(createWorkArea());	// `̈̐ݒ
		setSouth(getStatusBar());		// Xe[^Xo[̐ݒ
	}

	/**
	 * GUIt[IA\[XB
	 */
	protected void disposeFrame() {
		if(confirmDispose()) {
			assert Log.debug(1, "==> AshGUIFrame#disposeFrame()");
			dispose();
		}
	}
	/**
	 * IɏImF߂ꍇɁAI[oChB
	 * @return IȂꍇfalse
	 */
	protected boolean confirmDispose() {
		return true;
	}

	private static final int TASKBAR_HEIGHT = 34;
	/**
	 * GUIt[XN[̘gɎ߂B
	 */
	public void adjustLocation() {
		Dimension sZ = Toolkit.getDefaultToolkit().getScreenSize();
		Dimension z = this.getSize();
		sZ.height -= TASKBAR_HEIGHT;
		if(z.height > sZ.height) z.height = sZ.height;
		if(z.width > sZ.width) z.width = sZ.width;
		Point loc = this.getLocation();
		int x = Math.min(Math.max(loc.x, 0), sZ.width - z.width);
		int y = Math.min(Math.max(loc.y, 0), sZ.height - z.height);
		this.setBounds(x, y, z.width, z.height);
	}

	/**
	 * CAEgɂ BorderLayout gpĂB
	 * kƒ̂T̗̈̃R|[lgݒ^ĐݒłB
	 */
	protected void setNorth(Component comp) {	// ^XNo[
		if(comp != null) contentPane.add(comp, BorderLayout.NORTH);
	}
	protected void setCenter(Component comp) {	// `̈
		if(comp != null) contentPane.add(comp, BorderLayout.CENTER);
	}
	protected void setSouth(Component comp) {	// Xe[^Xo[
		if(comp != null) contentPane.add(comp, BorderLayout.SOUTH);
	}
	protected void setWest(Component comp) {	// lȂ
		if(comp != null) contentPane.add(comp, BorderLayout.WEST);
	}
	protected void setEast(Component comp) {	// lȂ
		if(comp != null) contentPane.add(comp, BorderLayout.EAST);
	}

	/*
	 * j[o[ƃj[쐬FactoryMethodF
	 * j[o[쐬ꍇ createMenuBar()I[oChB
	 * j[o[̎̍ۂɂ́Aj[̃NX AshMenu gB
	 * @return j[o[
	 */
	protected JMenuBar createMenuBar() { return null; }

	/**
	 * c[o[쐬FactoryMethodF
	 * c[o[쐬ꍇ createToolBar()I[oChB
	 * c[o[̎̍ۂɂ́Ac[o[쐬NX AshToolBar gB
	 * @return c[o[
	 */
	protected JToolBar createToolBar() { return null; }

	/**
	 * `̈쐬FactoryMethodF
	 * AvP[V̎vȋ@\̈ƂȂR|[lgԂB
	 * @return `̈̃R|[lg
	 */
	protected Component createWorkArea() { return null; }

	/**
	 *  Xe[^Xo[̍쐬ƑF
	 * @return Xe[^Xo[
	 */
	protected StatusBar getStatusBar() {
		if(statusBar == null) statusBar = new StatusBar();
		return statusBar;
	}
	private StatusBar statusBar;
	/**
	 * Xe[^Xo[̕\^\؂ւB
	 * @param visible \̏ꍇtrue
	 */
	protected void statusSetVisible(boolean visible) {
		statusBar.setVisible(visible);
	}
	/**
	 * Xe[^Xo[̕\^\؂ւ郁jڂ쐬B
	 * @return Xe[^Xo[̕\^\؂ւ郁j
	 */
	public JMenuItem makeStatusMenuItem() {
		return getStatusBar().makeStatusMenuItem();
	}
	/**
	 * Xe[^Xo[ɃbZ[W\B
	 * @param message Xe[^Xo[ɕ\郁bZ[W
	 */
	public void setMessage(String message) {
		getStatusBar().showMessage(message);
	}
	/**
	 * Xe[^Xo[ɃJ[\ʒu\B
	 * @param row sʒu
	 * @param column ʒu
	 */
	public void showCursorPos(int row, int column) {
		getStatusBar().showCursorPos(row, column);
	}
	/**
	 * J[\ʒu\̏߂B
	 * ύXꍇ̓I[oCh`B
	 * @param row sʒu
	 * @param column ʒu
	 * @return ʒu
	 */
	protected String cursorPosDisplay(int row, int column) {
		return "(" + row + ", " + column + ")";
	}
	/**
	 * bZ[W\̈ƃJ[\ʒu\̈Xe[^Xo[F
	 */
	protected class StatusBar extends JPanel {
		private JLabel statusLabel = new JLabel("\̈łB");
		private JLabel cursorPos = new JLabel();
		private StatusBar() {
			setLayout(new BorderLayout());
			add(statusLabel, BorderLayout.CENTER);
			add(cursorPos, BorderLayout.EAST);
		}
		void showMessage(String message) {
			statusLabel.setText(message);
		}
		void showCursorPos(int row, int column) {
			cursorPos.setText(cursorPosDisplay(row, column));
		}
		JMenuItem makeStatusMenuItem() {
			final JCheckBoxMenuItem mi =
				new JCheckBoxMenuItem("Xe[^Xo[(S)", true);
			mi.setMnemonic(VK_S);
			mi.addItemListener(new ItemListener() {
					public void itemStateChanged(ItemEvent e) {
						setVisible(mi.isSelected());
					}
				});
			return mi;
		}
	}

	/**
	 * GUI ֘Ã[eBeB
	 */
	/**
	 * r[v𔭐B
	 */
	public static void beep() { toolkit.beep(); }
	public static Toolkit toolkit = Toolkit.getDefaultToolkit();

	/**
	 * ӂȃANV𐶐
	 */
	protected static String actionName() {
		return String.format("ACTION_%03d", actionSerial++);
	}
	private static int actionSerial = 0;

	/*
	 * ActionListener C^tF[X̎F
	 * ftHg̃ANVsłactionAsh̃R}hƂĎsB
	 */
	@Override public void actionPerformed(ActionEvent ae) {
		GUIAdapter.getListener().actionPerformed(ae);
	}

	/**
	 * bZ[W\mF̂߂̃_CAOE[eBeB
	 */
	public void showMessage(String message) {
		JOptionPane.showMessageDialog(contentPane, message);
	}
	public void showError(String message, String title) {
		beep();
		JOptionPane.showMessageDialog(contentPane, message, title,
									  JOptionPane.ERROR_MESSAGE);
	}
	public int showConfirm(String message) {
		return JOptionPane.showConfirmDialog(contentPane, message);
	}
	public int showConfirm(String message, String title) {
		return JOptionPane.showConfirmDialog(contentPane, message, title,
											 JOptionPane.YES_NO_OPTION);
	}
	public String inputDialog(String message, String title) {
		return JOptionPane.showInputDialog(contentPane, message, title,
										   JOptionPane.QUESTION_MESSAGE);
	}
}
