package pbl2011.gui;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;

import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

import pbl2011.common.CommonConst.AssocType;
import pbl2011.common.Util;
import pbl2011.model.AssociationArc;
import pbl2011.model.ClassNode;
import pbl2011.model.NodeArcSet;
import pbl2011.model.UndoRedoModel;
import pbl2011.mvc.Controller;
import pbl2011.mvc.View;

/**
 * UMLLoXRg[
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class UMLCanvasController extends Controller implements MouseListener {

	private UMLCanvas UMLView;
	public UndoRedoModel undoredoModel;
	private JColorChooser colorChooser;

	public UMLCanvasController(View v) {
		super(v);
		UMLView = (UMLCanvas) v;
		createPopMenue();
		undoredoModel = v.getModel().undoredoModel;
		colorChooser = new JColorChooser();
	}

	@Override
	public void update() {
		NodeArcSet nodearcSet = new NodeArcSet();
		for (ClassNode cn: myModel.getAllActiveClassData()) {
			nodearcSet.add(cn);
		}
		for (AssociationArc aa: myModel.getAllActiveAssociationArc()) {
			nodearcSet.add(aa);
		}
		undoredoModel.tryPush(nodearcSet);
		myView.update();
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		String cmd = e.getActionCommand();
		if ("MODIFY_CLASS_COLOR".equals(cmd)) {
			executeChangeClassColor();
		} else if ("MODIFY_PACKAGE_COLOR".equals(cmd)) {
			executeChangePackageColor();
		} else if ("DEL_CLASS".equals(cmd)) {
			executeClassDelete();
		} else if ("DEL_ARC".equals(cmd)) {
			executeArcDelete();
		} else if ("RIGHT_ANGLE".equals(cmd)) {
			executeLine(AssocLineType.RIGHT_ANGLE);
		} else if ("RIGHT_ANGLE_H".equals(cmd)) {
			executeLine(AssocLineType.RIGHT_ANGLE_H);
		} else if ("STRAIGHT_LINE".equals(cmd)) {
			executeLine(AssocLineType.STRAIGHT_LINE);
		} else if ("FREE_LINE".equals(cmd)) {
			executeLine(AssocLineType.FREE_LINE);
		} else if ("ADD_POINT".equals(cmd)) {
			executeAddPoint();
		} else if ("DEL_POINT".equals(cmd)) {
			executeDelPoint();
		}
	}

	protected ArrayList<ClassNode> executeChangeClassColor() {
		
		ClassNode cn = cuMgr.getCurrentNode();
		ArrayList<ClassNode> list = new ArrayList<ClassNode>();
		list.add(cn);
		ActionListener changeColor = new ChangeClassColorListener(this, list, colorChooser);
		JDialog dialog = JColorChooser.createDialog(UMLView, "Select Color",
				true, colorChooser, changeColor, null);
		dialog.setVisible(true);
		return list;
	}

	protected ArrayList<ClassNode> executeChangePackageColor() {
		
		ClassNode node = cuMgr.getCurrentNode();
		ArrayList<ClassNode> activeNodes = UMLView.getModel().getAllActiveClassData();
		ArrayList<ClassNode> list = new ArrayList<ClassNode>();
		for (ClassNode cn :activeNodes) {
			if ((node.getPackageName() != null) && (cn.getPackageName() != null)) {
				if (node.getPackageName().equals(cn.getPackageName())) {
					list.add(cn);
				}
			} else if (node.getPackageName() == null) {
				if (cn.getPackageName() == null) {
					list.add(cn);
				}
			}
		}
		
		ActionListener changeColor = new ChangeClassColorListener(this, list, colorChooser);
		JDialog dialog = JColorChooser.createDialog(UMLView, "Select Color",
				true, colorChooser, changeColor, null);
		dialog.setVisible(true);
		return list;
	}
	protected void executeClassDelete() {

		myModel.deleteClass();
	}

	protected void executeArcDelete() {
		NodeArcSet nodearcSet = new NodeArcSet();
		AssociationArc a = cuMgr.getCurrentArc();

		a.delFlag = true;
		nodearcSet.add(a);
		undoredoModel.tryPush(nodearcSet);
		cuMgr.setCurrentArc(null);
		myModel.changeModel();

	}

	// ύX
	protected void executeLine(AssocLineType type) {
		AssociationArc a = cuMgr.getCurrentArc();
		if (type.isFREE_LINE()) {
			a.pointList = UMLView.getArcPointList(a);
		} else {
			a.pointList = null;
		}
		a.lineStyle = type;

		NodeArcSet nodearcSet = new NodeArcSet();
		nodearcSet.add(a);
		undoredoModel.tryPush(nodearcSet);

		myModel.changeModel();
	}

	// _ǉ
	protected void executeAddPoint() {
		UMLView.addArcPoint(popPoint);
		myModel.changeModel();
	}

	// _폜
	protected int executeDelPoint() {
		int poz = pointClickCheck(popPoint);
		if(poz > -1) {
			UMLView.delArcPoint(poz);
			myModel.changeModel();
		}
		return poz;
	}

	@Override
	public void mouseMoved(MouseEvent e) {
	}

	@Override
	public void mouseClicked(MouseEvent e) {
	}

	MouseEditState state;

	@Override
	public void mousePressed(MouseEvent e) {
		showPopup(e);
		Point pt = Util.adjust(e.getPoint());
		int no = -1;
		ClassNode node = UMLView.selectClass(pt);
		AssociationArc arc = UMLView.selectArc(e.getPoint());

		// ֘A̒ǉ[hŃNXȊONbNꍇI[hɖ߂B
		if (State.arcSelect != null && node == null) {
			State.changeToSelectMode();
		}

		// NX̒ǉ[h
		if (State.classSelect) {
			if (!UMLView.mainCanvas)
				return;
			assert Util.debug("UMLView.classSelect");
			state = new FrameMoveState(UMLView, pt);
			cuMgr.setCurrentNode(UMLView.addNewClass(pt));

			NodeArcSet nodearcSet = new NodeArcSet();
			nodearcSet.add(cuMgr.getCurrentNode());
			nodearcSet.setCreateFlg(true);
			undoredoModel.tryPush(nodearcSet);
//			State.changeToSelectMode();
			clearClassAddMode();
			
		// ֘A̒ǉ[h
		} else if (State.arcSelect != null) {
			if (!UMLView.mainCanvas)
				return;
			if (node != null) {
				assert Util.debug("UMLView.arcSelect");
				state = new ArcDrawState(UMLView, node, State.arcSelect);

				NodeArcSet nodearcSet = new NodeArcSet();
				nodearcSet.add(cuMgr.getCurrentArc());
				nodearcSet.setCreateFlg(true);
				undoredoModel.tryPush(nodearcSet);

			} else {
				cuMgr.setCurrentNode(null);
				cuMgr.setCurrentArc(null);
			}

		// NXIAt[łΈړ
		} else if( cuMgr.getCurrentNodeList().size() > 1 &&
					UMLView.selectClass(pt, cuMgr.getCurrentNodeList()) != null	) {
				state = new FrameMoveState(UMLView, pt);

		// NXI𒆂ŁAmuENXNbNꍇ
		} else if( cuMgr.getCurrentNodeList().size() == 1) {
			Point orgPt;
			if (UMLView.mainCanvas) {

				if ((orgPt = knobClickCheck1(pt)) != null) { // muvX烊TCY
					state = new FrameResizeState(UMLView, orgPt, pt, 1);
				} else if ((orgPt = knobClickCheck2(pt)) != null) { // muvX烊TCY
					state = new FrameResizeState(UMLView, orgPt, pt, 2);
				} else if ((orgPt = knobClickCheck3(pt)) != null) { // muvX烊TCY
					state = new FrameResizeState(UMLView, orgPt, pt, 3);
				} else if (node != null) {
					cuMgr.setCurrentNode(node);
					state = new FrameMoveState(UMLView, pt);
				} else if (arc != null) {
					cuMgr.setCurrentArc(arc);
				} else {
					cuMgr.setCurrentNode(null);
					cuMgr.setCurrentArc(null);
					state = new ModelSelectState(UMLView, pt);
				}
			} else {
				if (node != null) { // NXvXړ
					cuMgr.setCurrentNode(node);
					state = new FrameMoveState(UMLView, pt);
				} else {
					cuMgr.setCurrentNode(null);
					cuMgr.setCurrentArc(null);
				}
			}
		// ֘AI𒆂ŁA|CgNbNꍇ
		} else if( cuMgr.getCurrentArc() != null &&
				((no = pointClickCheck(pt)) > -1)) {
			state = new PointMoveState(UMLView, pt, no);
			no = -1;

		// NXIꍇ
		} else if (node != null) {
			cuMgr.setCurrentNode(node);
			state = new FrameMoveState(UMLView, pt);

		// ֘AIꍇ
		} else if (arc != null) {
			cuMgr.setCurrentArc(arc);

		// ȊȌꍇAI
		} else {
			cuMgr.setCurrentNode(null);
			cuMgr.setCurrentArc(null);
			state = new ModelSelectState(UMLView, pt);
		}

		UMLView.repaint();
	}

	protected void clearClassAddMode(){
		State.changeToSelectMode();
	}
	
	@Override
	public void mouseEntered(MouseEvent e) {
	}

	@Override
	public void mouseExited(MouseEvent e) {

		if ( state instanceof FrameMoveState )
				state = null;
	}

	@Override
	public void mouseDragged(MouseEvent me) {
		if (state == null)
			return;
		state.mouseDragged(me);
	}

	@Override
	public void mouseReleased(MouseEvent me) {

		showPopup(me);
		if (state == null)
			return;

		if (cuMgr.getCurrentNode() != null) {
			NodeArcSet nodearcSet = new NodeArcSet();
			ArrayList<AssociationArc> arclist = myModel.getAllActiveAssociationArc();
			ClassNode cn = cuMgr.getCurrentNode();
			nodearcSet.add(cn);
			for (AssociationArc a: arclist) {
				if (a.classIdTarget == cn.classId || a.classIdSource == cn.classId) {
					nodearcSet.add(a);
				}
			}
			undoredoModel.tryPush(nodearcSet);
		}

		state.mouseReleased(me);
		myModel.changeModel();
	}

	JPopupMenu popClass;
	JPopupMenu popArc;

	private void createPopMenue() {
		popClass = new JPopupMenu();
		popArc = new JPopupMenu();

		JMenu colorModify = new JMenu("F̕ύX");
		JMenuItem colorModifyClassItem = new JMenuItem("NXF");
		colorModifyClassItem.setActionCommand("MODIFY_CLASS_COLOR");
		colorModifyClassItem.addActionListener(this);
		JMenuItem colorModifyPackageItem = new JMenuItem("pbP[WF");
		colorModifyPackageItem.setActionCommand("MODIFY_PACKAGE_COLOR");
		colorModifyPackageItem.addActionListener(this);
		colorModify.add(colorModifyClassItem);
		colorModify.add(colorModifyPackageItem);
		
		popClass.add(colorModify);
		JMenuItem delClassItem = new JMenuItem("폜");
		delClassItem.setActionCommand("DEL_CLASS");
		delClassItem.addActionListener(this);
		popClass.add(delClassItem);

		JMenu rightAngle = new JMenu("pɂ");
		JMenuItem rightAngleV = new JMenuItem("cD");
		rightAngleV.setActionCommand("RIGHT_ANGLE");
		rightAngleV.addActionListener(this);
		JMenuItem rightAngleH = new JMenuItem("D");
		rightAngleH.setActionCommand("RIGHT_ANGLE_H");
		rightAngleH.addActionListener(this);
		rightAngle.add(rightAngleV);
		rightAngle.add(rightAngleH);

		JMenuItem straightLine = new JMenuItem("ɂ");
		straightLine.setActionCommand("STRAIGHT_LINE");
		straightLine.addActionListener(this);
		JMenuItem freeLine = new JMenuItem("RɂȂ");
		freeLine.setActionCommand("FREE_LINE");
		freeLine.addActionListener(this);
		addPoint = new JMenuItem("_ǉ");
		addPoint.setActionCommand("ADD_POINT");
		addPoint.addActionListener(this);
		delPoint = new JMenuItem("_폜");
		delPoint.setActionCommand("DEL_POINT");
		delPoint.addActionListener(this);
		JMenuItem delArcItem = new JMenuItem("폜");
		delArcItem.setActionCommand("DEL_ARC");
		delArcItem.addActionListener(this);
		popArc.add(straightLine);
		popArc.add(rightAngle);
		popArc.add(freeLine);
		popArc.add(addPoint);
		popArc.add(delPoint);
		popArc.add(delArcItem);
	}

	JMenuItem addPoint;
	JMenuItem delPoint;
	Point popPoint;
	private void showPopup(MouseEvent e) {

		if (e.isPopupTrigger()) {
			popPoint = e.getPoint();
			if (cuMgr.getCurrentNode() != null
					&& cuMgr.getCurrentNode().equals(UMLView.selectClass(popPoint))) {
				popClass.show(e.getComponent(), e.getX(), e.getY());
			} else if (cuMgr.getCurrentArc() != null
					&& cuMgr.getCurrentArc().equals(UMLView.selectArc(popPoint))) {

				// _̒ǉƍ폜́A삪\ȂƂɂB
				addPoint.setEnabled(false);
				delPoint.setEnabled(false);
				if(cuMgr.getCurrentArc().lineStyle.isFREE_LINE()) {
					addPoint.setEnabled(true);
					if(cuMgr.getCurrentArc().pointList.length > 2) {
						delPoint.setEnabled(true);
					}
				}
				popArc.show(e.getComponent(), e.getX(), e.getY());
			}
		}
	}


	private Point knobClickCheck1(Point p) {

		ClassNode current = cuMgr.getCurrentNode();
		assert Util.debug("knobClickCheck1");
		if (hitKnob(p, current.p.x, current.p.y)) {
			return new Point(current.p.x + current.width, current.p.y
					+ current.height1);
		}

		if (hitKnob(p, current.p.x, current.p.y + current.height1)) {
			return new Point(current.p.x + current.width, current.p.y);
		}

		if (hitKnob(p, current.p.x + current.width, current.p.y)) {
			return new Point(current.p.x, current.p.y + current.height1);
		}

		if (hitKnob(p, current.p.x + current.width, current.p.y
				+ current.height1)) {
			return new Point(current.p.x, current.p.y);
		}

		return null;

	}

	private Point knobClickCheck2(Point p) {
		ClassNode current = cuMgr.getCurrentNode();
		assert Util.debug("knobClickCheck2");
		if (hitKnob(p, current.p.x, current.p.y + current.height1
				+ current.height2)) {
			return new Point(current.p.x + current.width, current.p.y
					+ current.height1);
		}
		if (hitKnob(p, current.p.x + current.width, current.p.y
				+ current.height1 + current.height2)) {
			return new Point(current.p.x, current.p.y + current.height1);
		}
		return null;

	}

	private Point knobClickCheck3(Point p) {
		ClassNode current = cuMgr.getCurrentNode();
		assert Util.debug("knobClickCheck3");
		if (hitKnob(p, current.p.x, current.p.y + current.height())) {
			return new Point(current.p.x + current.width, current.p.y
					+ current.height1 + current.height2);
		}
		if (hitKnob(p, current.p.x + current.width, current.p.y
				+ current.height())) {
			return new Point(current.p.x, current.p.y + current.height1
					+ current.height2);
		}
		return null;

	}

	private boolean hitKnob(Point p, int x, int y) {
		int z = KNOB_SIZE;
		Rectangle knobRect = new Rectangle(x - z / 2, y - z / 2, z, z);

		return knobRect.contains(p);
	}

	private int pointClickCheck(Point p) {

		AssociationArc current = cuMgr.getCurrentArc();
		if (current != null && current.lineStyle.isFREE_LINE()) {
			Point[] pList = current.pointList;
			for(int i = 0; i< pList.length; i++) {
				if (hitPoint(p, pList[i].x,pList[i].y)) {
					return i;
				}
			}
		}
		return -1;
	}

	private boolean hitPoint(Point p, int x, int y) {
		int z = POINT_SIZE;
		Rectangle pointRect = new Rectangle(x - z / 2, y - z / 2, z, z);

		return pointRect.contains(p);
	}

}

/**
 * }EXgX̕ҏWԂɂ}EX상\bh
 */
abstract class MouseEditState {
	UMLCanvas UMLView;
	Point currPt; // hbũ}EXʒu
	MouseEditState(UMLCanvas UMLView, Point currPt) {
		this.UMLView = UMLView;
		this.currPt = currPt;

	}
	abstract void mouseDragged(MouseEvent me);

	abstract void mouseReleased(MouseEvent me);
}

/**
 * UMLNX}͈̔͑I
 */
class ModelSelectState extends MouseEditState {

	public ModelSelectState(UMLCanvas view, Point currPt) {
		super(view, currPt);
		UMLView.setStartPoint(currPt);
	}

	@Override
	public void mouseDragged(MouseEvent me) {
		Point pt = me.getPoint();
		if (pt != null && !pt.equals(currPt)) {
			UMLView.setEndPoint( pt );
			UMLView.repaint();
		}
	}

	@Override
	public void mouseReleased(MouseEvent me) {
		UMLView.cuMgr.selectStatus();
	}
}

/**
 * t[̈ړԂ̏
 */
class FrameMoveState extends MouseEditState {

	public FrameMoveState(UMLCanvas UMLView, Point currPt) {
		super(UMLView,currPt);
	}

	@Override
	public void mouseDragged(MouseEvent me) {
		Point pt = Util.adjust(me.getPoint());
		if (pt != null && !pt.equals(currPt)) {

			UMLView.moveFrame(pt.x - currPt.x, pt.y - currPt.y);
			currPt = pt;
		}
	}

	@Override
	public void mouseReleased(MouseEvent me) {
	}
}

/**
 * t[̃TCYԂ̏
 */
class FrameResizeState extends MouseEditState {
	protected Point orgPt; // TCY^VK쐬̌Œ_
	int poz;
	int side;

	final int LEFT = 1;
	final int RIGHT = 2;

	public FrameResizeState(UMLCanvas UMLView, Point orgPt, Point currPt,
			int poz) {
		super(UMLView,currPt);
		this.orgPt = orgPt;
		this.poz = poz;
		if (orgPt.x < currPt.x) {
			this.side = RIGHT;
		} else {
			this.side = LEFT;
		}
	}

	@Override
	public void mouseDragged(MouseEvent me) {
		Point pt = Util.adjust(me.getPoint());
		UMLView.dragFrame(orgPt, currPt, pt, poz, side);

		if (pt != null && !pt.equals(currPt)) {
			currPt = pt;
		}
	}

	@Override
	public void mouseReleased(MouseEvent me) {

	}
}

/**
 * ֘Aǉ̏
 */
class ArcDrawState extends MouseEditState {
	private ClassNode orgNode; // TCY^VK쐬̌Œ_
	protected AssocType kind; // ֘A

	public ArcDrawState(UMLCanvas UMLView, ClassNode orgNode, AssocType kind) {
		super(UMLView,null);
		this.orgNode = orgNode;
		this.kind = kind;
		if (orgNode != null) {
			currPt = new Point(orgNode.p.x + (orgNode.width / 2),
					orgNode.p.y + ((orgNode.height()) / 2));
		}
	}

	@Override
	public void mouseDragged(MouseEvent me) {
		Point pt = Util.adjust(me.getPoint());
		UMLView.setCurrPoint(currPt, pt);

	}

	@Override
	public void mouseReleased(MouseEvent me) {
		Point pt = me.getPoint();
		ClassNode node = UMLView.selectClass(pt);
		UMLView.setCurrPoint(null, null);
		if (node != null && !node.equals(orgNode)) {
			AssociationArc aa = UMLView.addNewArc(orgNode, node, kind);
			NodeArcSet nodearcSet = new NodeArcSet();
			nodearcSet.add(aa);
			nodearcSet.setCreateFlg(true);
			UMLView.getModel().undoredoModel.tryPush(nodearcSet);

		}
	}
}


/**
 * ֘Aړ̏
 */
class PointMoveState extends MouseEditState {
	protected int no;
	public PointMoveState(UMLCanvas UMLView, Point p, int no) {
		super(UMLView, p);
		this.no = no;
	}

	@Override
	public void mouseDragged(MouseEvent me) {
		Point pt = Util.adjust(me.getPoint());
		UMLView.moveArcPoint(pt,no);
	}

	@Override
	public void mouseReleased(MouseEvent me) {
	}
}

/**
 * NX}̐F肵ꍇ̏
 */
class ChangeClassColorListener implements ActionListener {
	JColorChooser colorChooser;
	Controller controller;
	ArrayList<ClassNode> nodeList;
	ChangeClassColorListener(Controller controller, ArrayList<ClassNode> nodeList, 
			JColorChooser colorChooser) {
		this.controller = controller;
		this.nodeList = nodeList;
		this.colorChooser = colorChooser;
	}

	public void actionPerformed(ActionEvent e) {
		Color color = colorChooser.getColor();
		for (ClassNode cn: nodeList) {
			cn.colorRed = color.getRed();
			cn.colorGreen = color.getGreen();
			cn.colorBlue = color.getBlue();
		}
		controller.update();
	}
}
