package pbl2011.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;

import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import pbl2011.model.ClassNode;
import pbl2011.model.PackageManager;
import pbl2011.mvc.Controller;
import pbl2011.mvc.Model;
import pbl2011.mvc.View;



/**
 * NXڍוҏWNX
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class ClassDetailEditor extends View {
	ParameterEditor paramEditor;
	MethodForm methodForm;
	AttributeForm attributeForm;
	RelationForm relationForm;

	private JTabbedPane formTabbed;
	private int tabIndex = 0;

	public ClassDetailEditor(Model m,ParameterEditor paramEditor) {
		super(m);
		methodForm = new MethodForm(m,paramEditor);
		attributeForm = new AttributeForm(m);
		relationForm = new RelationForm(m);
		this.paramEditor = paramEditor;
		initialize();
	}

	protected ClassNode clone = null;
	@Override
	protected void draw() {
		if ( cuMgr.getCurrentNode() != null && (clone == null ||
				clone.classId != cuMgr.getCurrentNode().classId)) {
			clone  = (cuMgr.getCurrentNode()).clone();
			setClassNode();
		} else if ( cuMgr.getCurrentNode() == null ) {
			clone = null;
			setClassNode();
		}
		String packageName = "";
		String className = "";
		VisibilityType visibility = VisibilityType.PUBLIC;

		if (clone != null) {
			packageName = clone.getPackageName();
			className = clone.className;
			visibility = clone.visibility;
		}
		text1.setText(packageName);
		text2.setText(className);
		com.setSelectedItem(visibility.alias());

		drawOne();
	}

	private void drawOne() {

		switch (tabIndex) {
		case 0: //^ȕꍇ
			methodForm.drawOne();
			break;

		case 1: //^ȕꍇ
			attributeForm.drawOne();
			break;

		case 2: //֘A^ȕꍇ
			relationForm.drawOne();
			break;
		}
		paramEditor.drawOne();
	}

	private void setClassNode() {
		methodForm.setClassNode(clone);
		attributeForm.setClassNode(clone);
		relationForm.setClassNode(clone);
		paramEditor.setClassNode(clone);
	}

	private void changeBtnState() {
		tabIndex = formTabbed.getSelectedIndex();

		switch (tabIndex) {
		case 0: //^ȕꍇ
			setBtnEnabled(true);
			paramEditor.setShowFlg(true);
			break;

		case 1: //^ȕꍇ
			setBtnEnabled(true);
			paramEditor.setShowFlg(false);
			break;

		case 2: //֘A^ȕꍇ
			setBtnEnabled(false);
			paramEditor.setShowFlg(false);
			break;

		}
		drawOne();
	}

	private void setBtnEnabled(boolean flg) {
		bo1.setEnabled(flg);
		bo2.setEnabled(flg);
		boUp.setEnabled(flg);
		boDown.setEnabled(flg);
	}

	@Override
	protected void initialize() {

		setLayout(new BorderLayout());

		removeAll();
		add(getTopPanel(), BorderLayout.NORTH);

		formTabbed = new JTabbedPane();
		formTabbed.addTab("", new JScrollPane(methodForm));
		formTabbed.addTab("", new JScrollPane(attributeForm));
		formTabbed.addTab("֘A", new JScrollPane(relationForm));
		formTabbed.setSelectedIndex(tabIndex) ;
		formTabbed.addChangeListener(new ChangeListener() {

			@Override
			public void stateChanged(ChangeEvent e) {
				changeBtnState();
			}
		});

		add(formTabbed, BorderLayout.CENTER);
		add(getButton(), BorderLayout.SOUTH);
		changeBtnState();
		validate();

		draw();
		setVisible(true);
	}

	private JTextField text1;
	private JTextField text2;
	private JButton boUp;
	private JButton boDown;
	private JButton boUpdate;
	JComboBox com ;

	private Component getTopPanel() {

		JPanel p = new JPanel();
		p.setLayout(new GridLayout(3, 3));

		JLabel l1 = new JLabel("pbP[W");
		JLabel l2 = new JLabel("NX");
		JLabel l3 = new JLabel("");
		text1 = new JTextField();
		text2 = new JTextField();
		com = new JComboBox(VISIBILITY_LIST);
		com.setSelectedItem(VisibilityType.PUBLIC.alias());

		boUp = new JButton("");
		boUp.setActionCommand(UP);
		boUp.addActionListener(myController);
		boDown = new JButton("");
		boDown.setActionCommand(DOWN);
		boDown.addActionListener(myController);
		boUpdate = new JButton("X V");
		boUpdate.setActionCommand(UPDATE);
		boUpdate.addActionListener(myController);
		p.add(l1);
		p.add(text1);
		p.add(boUp);
		p.add(l2);
		p.add(text2);
		p.add(boDown);
		p.add(l3);
		p.add(com);
		p.add(boUpdate);
		return p;
	}

	JButton bo1;
	JButton bo2;

	private Component getButton() {
		JPanel p = new JPanel();
		p.setLayout(new GridLayout(1, 4));
		bo1 = new JButton("ǉ");
		bo1.setActionCommand(ADD);
		bo1.addActionListener(myController);
		bo2 = new JButton("폜");
		bo2.setActionCommand(DELETE);
		bo2.addActionListener(myController);
		p.add(bo1);
		p.add(bo2);

		return p;
	}

	@Override
	protected Controller makeController() {
		return new ClassDetailController(this);
	}

	public void addModel() {
		if (tabIndex == 0) {
			clone.addMethod();
			methodForm.tableModel.addRow(new String[]{"new method", "void", "public"});

		} else if (tabIndex == 1) {
			clone.addAttribute();
			attributeForm.tableModel.addRow(new String[]{"new Attribute", "String", "private"});
		}
	}

	public void deleteModel() {
		if (isMethodSelect()) {
			clone.delMethod(methodForm.getSelectedRow());
			methodForm.tableModel.removeRow(methodForm.getSelectedRow());

		} else if (isAttributeSelect()) {
			clone.delAttribute(attributeForm.getSelectedRow());
			attributeForm.tableModel.removeRow(attributeForm.getSelectedRow());

		}
	}

	public void up() {
		if (isMethodSelect() && methodForm.getSelectedRow() > 0 ) {
			int row = methodForm.getSelectedRow();
			clone.changeMethodSeq(row ,true);
			methodForm.tableModel.moveRow(row,row, row-1 );
			methodForm.table.setRowSelectionInterval(row-1,row-1);
		} else if (isAttributeSelect() && attributeForm.getSelectedRow() > 0 ) {
			int row = attributeForm.getSelectedRow();
			clone.changeAttributeSeq(row ,true);
			attributeForm.tableModel.moveRow(row,row, row-1 );
			attributeForm.table.setRowSelectionInterval(row-1,row-1);

		}
	}

	public void down() {
		if (isMethodSelect() &&  methodForm.getSelectedRow() > -1 &&
				methodForm.getSelectedRow() < methodForm.getRowNum()-1) {
			int row = methodForm.getSelectedRow();
			clone.changeMethodSeq(methodForm.getSelectedRow() ,false);
			methodForm.tableModel.moveRow(row,row, row+1 );
			methodForm.table.setRowSelectionInterval(row+1,row+1);


		} else if (isAttributeSelect() && attributeForm.getSelectedRow() > -1 &&
				attributeForm.getSelectedRow() < attributeForm.getRowNum()-1) {
			int row = attributeForm.getSelectedRow();
			clone.changeAttributeSeq(attributeForm.getSelectedRow() ,false);
			attributeForm.tableModel.moveRow(row,row, row+1 );
			attributeForm.table.setRowSelectionInterval(row+1,row+1);

		}
	}

	private boolean isMethodSelect() {
		return tabIndex == 0 && methodForm.getSelectedRow() > -1;
	}

	private boolean isAttributeSelect() {
		return tabIndex == 1 && attributeForm.getSelectedRow() > -1;
	}

	public void changeLine() {
		if (tabIndex == 0) {
			methodForm.changeLine();
		}
	}

	public void updateDetail() {

		clone.packageId = PackageManager.add(text1.getText());
		clone.className = text2.getText();
		clone.visibility = VisibilityType.aliasOf((String)com.getSelectedItem());
		myModel.updateClass(clone);

	}
}