package pbl2011.common;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;


/**
 * ʃ[eBeBNX
 * <p>
 *
 * @author 10745104 Y.Ishii
 *
 */
public class Util implements CommonConst {

	/**
	 * `߂̃|CgZo
	 * <p>
	 *
	 * @param p1
	 *            ̃|Cg
	 * @param p2
	 *            ƔΑ̃|Cg
	 * @return intziXW,YW,XW,YWj
	 */
	public static int[] calcArrowPoint(Point p1, Point p2) {

		double theta = Math.atan2((p2.y - p1.y), (p2.x - p1.x));
		double theta2 = ARROW_ANGLE_A;

		int x1 = (int) (ARROW_SIZE_A * Math.cos(theta + theta2));
		int y1 = (int) (ARROW_SIZE_A * Math.sin(theta + theta2));
		int x2 = (int) (ARROW_SIZE_A * Math.cos(theta - theta2));
		int y2 = (int) (ARROW_SIZE_A * Math.sin(theta - theta2));

		return new int[] { p1.x + x1, p1.y + y1, p1.x + x2, p1.y + y2 };
	}

	/**
	 * p̎Op``߂̃|CgZo
	 * <p>
	 *
	 * @param p1
	 *            ̃|Cg
	 * @param p2
	 *            ƔΑ̃|Cg
	 * @return intziXW,YW,XW,YWj
	 */
	public static int[] calcTrianglePoint(Point p1, Point p2) {

		double theta = Math.atan2((p2.y - p1.y), (p2.x - p1.x));
		double theta2 = ARROW_ANGLE_E;

		int x1 = (int) (ARROW_SIZE_E * Math.cos(theta + theta2));
		int y1 = (int) (ARROW_SIZE_E * Math.sin(theta + theta2));
		int x2 = (int) (ARROW_SIZE_E * Math.cos(theta - theta2));
		int y2 = (int) (ARROW_SIZE_E * Math.sin(theta - theta2));

		return new int[] { p1.x + x1, p1.y + y1, p1.x + x2, p1.y + y2 };
	}

	/**
	 * NXƊ֘A̐|Cg߂
	 * <p>
	 *
	 * @param rect
	 *            NX
	 * @param p
	 *            Α̃NX̒S_
	 * @return _
	 */
	public static Point calcCrossPoint(Rectangle rect, Point p) {

		// `̒Ƀ|Cgꍇ͑ΏۊO
		if (rect.contains(p)) {
			return null;
		}

		// `̏cƌ
		int x1 = rect.width / 2;
		int x2 = p.x - (rect.x + (rect.width / 2));
		int y2 = (rect.y + (rect.height / 2)) - p.y;
		int y1;
		if (x2 == 0) {
			y1 = 0;
		} else {
			y1 = y2 * x1 / x2;
		}
		if (x2 != 0 && y1 <= (rect.height / 2)) {

			if (p.x > rect.x) {
				int cy = rect.y + (rect.height / 2) - y1;
				if (cy >= rect.y && cy <= (rect.y + rect.height)) {
					return new Point((rect.x + rect.width), cy);
				}
			} else {
				int cy = rect.y + (rect.height / 2) + y1;
				if (cy >= rect.y && cy <= (rect.y + rect.height)) {
					return new Point((rect.x), cy);
				}
			}
		}

		// `̉ƌ
		x1 = rect.height / 2;
		x2 = p.y - (rect.y + (rect.height / 2));
		y2 = (rect.x + (rect.width / 2)) - p.x;
		y1 = y2 * x1 / x2;

		if (y1 <= (rect.width / 2)) {

			if (p.y > rect.y) {
				int cx = rect.x + (rect.width / 2) - y1;
				if (cx >= rect.x && cx <= (rect.x + rect.width)) {
					return new Point(cx, (rect.y + rect.height));
				}
			} else {
				int cx = rect.x + (rect.width / 2) + y1;
				if (cx >= rect.x && cx <= (rect.x + rect.width)) {
					return new Point(cx, (rect.y));
				}
			}
		}

		return null;
	}

	/**
	 * NXƃNX𒼊pɌԃ|Cg߂(Dj
	 * <p>
	 * @param rect1 NX
	 * @param rect2 NX
	 * @return ֘Ã|CgXg
	 */
	public static Point[] calcRightAngleHPoint(Rectangle rect1, Rectangle rect2) {

		// `Ƌ`dȂꍇ͑ΏۊO
		if (rect1.intersects(rect2)) {
			return null;
		}

		// ǂ̋`ɂ邩
		boolean flg;
		Rectangle left;
		Rectangle right;
		if (rect1.x <= rect2.x) {
			left = rect1;
			right = rect2;
			flg = true;
		} else {
			left = rect2;
			right = rect1;
			flg = false;
		}
		// ㉺ԕȂꍇ́AE
		if( left.x + left.width >= right.x) {
			Rectangle upper;
			Rectangle lower;
			if (rect1.y <= rect2.y) {
				upper = rect1;
				lower = rect2;
				flg = true;
			} else {
				upper = rect2;
				lower = rect1;
				flg = false;
			}

			return putUpAndDown(upper,lower,flg);
		}
		return putRightAndLeft(left,right,flg);

	}

	/**
	 * NXƃNX𒼊pɌԃ|Cg߂(cDj
	 * <p>
	 * @param rect1 NX
	 * @param rect2 NX
	 * @return ֘Ã|CgXg
	 */
	public static Point[] calcRightAngleVPoint(Rectangle rect1, Rectangle rect2) {

		// `Ƌ`dȂꍇ͑ΏۊO
		if (rect1.intersects(rect2)) {
			return null;
		}

		// ǂ̋`ɂ邩
		boolean flg;
		Rectangle upper;
		Rectangle lower;
		if (rect1.y <= rect2.y) {
			upper = rect1;
			lower = rect2;
			flg = true;
		} else {
			upper = rect2;
			lower = rect1;
			flg = false;
		}

		// ㉺ԕȂꍇ́AE
		if( upper.y + upper.height >= lower.y) {
			Rectangle left;
			Rectangle right;
			if (rect1.x <= rect2.x) {
				left = rect1;
				right = rect2;
				flg = true;
			} else {
				left = rect2;
				right = rect1;
				flg = false;
			}
			return putRightAndLeft(left,right,flg);
		}
		return putUpAndDown(upper,lower,flg);

	}

	/**
	 * NXƃNX𒼊pɌԃ|Cg߂i㉺ɔzuj
	 * <p>
	 * @param upper NX
	 * @param lower NX
	 * @param flg tO(true:upperlowerւ̐@false:lowerupperւ̐)
	 * @return ֘Ã|CgXg
	 */
	private static Point[] putUpAndDown(Rectangle upper, Rectangle lower, boolean flg) {
		int a = (lower.y - ( upper.y + upper.height )) / 2 + (upper.y +upper.height) ;
		Point p1 = new Point(upper.x + ( upper.width / 2 ), upper.y + upper.height );
		Point p2 = new Point(upper.x + ( upper.width / 2 ), a );
		Point p3 = new Point(lower.x + ( lower.width / 2 ), a );
		Point p4 = new Point(lower.x + ( lower.width / 2 ), lower.y );
		if (flg) {
			return new Point[]{p1, p2, p3, p4 };
		}
		return  new Point[]{p4, p3, p2, p1 };
	}
	/**
	 * NXƃNX𒼊pɌԃ|Cg߂iEɔzuj
	 * <p>
	 * @param left NX
	 * @param right NX
	 * @param flg tO(true:leftrightւ̐@false:rightleftւ̐)
	 * @return ֘Ã|CgXg
	 */
	private static Point[] putRightAndLeft(Rectangle left, Rectangle right, boolean flg) {
		int a = (right.x - ( left.x + left.width )) / 2 + ( left.x + left.width ) ;
		Point p1 = new Point((left.x + left.width ), (left.y + (left.height / 2 )));
		Point p2 = new Point( a, (left.y + (left.height / 2 )));
		Point p3 = new Point( a, (right.y + (right.height / 2 )));
		Point p4 = new Point( right.x, (right.y + (right.height / 2 )));
		if (flg) {
			return new Point[]{p1, p2, p3, p4 };
		}
		return  new Point[]{p4, p3, p2, p1 };
	}

	/**
	 * ObhTCYɍ킹
	 * <p>
	 *
	 * @param
	 * @return
	 */
	public static Point adjust(Point pt) {
		return new Point(adjust(pt.x), adjust(pt.y));
	}


	/**
	 * ObhTCYɍ킹
	 * <p>
	 *
	 * @param
	 * @return
	 */
	public static int adjust(int i) {
		return adjust(i, CommonConst.GRID_SIZE);
	}

	/**
	 * ObhTCYɍ킹
	 * <p>
	 *
	 * @param
	 * @return
	 */
	public static int adjust(int i, int gridSize) {
		return (i + (gridSize / 2)) / gridSize * gridSize;
	}


	/**
	 * fobOp
	 * <p>
	 */
	public static boolean debug(String str) {
		System.err.println(str);
		return true;
	}
	
	private static final String REG_EX_JAVA_SPECIFIC_SYMBOL = ".*[\\[\\]\\<,\\>\\.+].*";
	/**
	 * "[","]",",","<",">","."̋LNX^ǂ𔻒肷
	 * @param type typeID or TypeName
	 * @return LFtrueALȂ:false
	 */
	public static boolean hasSymbol(String type) {
		return type.matches(REG_EX_JAVA_SPECIFIC_SYMBOL);
	}

	public static Integer removeSymbol(String typeId) {
		String tmpTypeId = typeId;
		tmpTypeId = tmpTypeId.replace("\\[.*\\]", "");
		tmpTypeId = tmpTypeId.replace("\\<.*\\>", "");
		tmpTypeId = tmpTypeId.replace("\\.+", "");
		return Integer.valueOf(tmpTypeId);
	}
	/**
	 * ŗ^ꂽtypeɊ܂܂typeׂĕԋp
	 * @param type typeName or typeId
	 * @return@^̃Xg
	 */
	public static List<String> getTypeList(String type){
		List<String> list = new ArrayList<String>();
		String tmpType = type.replace(SPACE, ""); // Xy[X͏
		if (hasSymbol(tmpType)) {
			String[] strs = tmpType.split("[\\[\\]\\<,\\>\\.+]");
				for (String s : strs) {
					if (!"".equals(s)) { //󕶎͏
						list.add(s);
					}
				}
		} else {
			list.add(type);
		}
		return list;
	}
	
	/**
	 * NX[_̎擾
	 * @param currentClass ĂяõNX
	 * @return NX[_
	 */
	public static ClassLoader getClassLoader(Class<?> currentClass){
	    ClassLoader cloader = Thread.currentThread().getContextClassLoader();
	    if (cloader == null) {
	    	cloader = currentClass.getClassLoader();
	    }
	    return cloader;
	}
}
