package ash.reverse.struct;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.io.PrintStream;
import ash.reverse.parser.JavaType;

/**
 * NX̋K͏ƃNXɏtB[hQƃ\bhQǗB
 */
public class ClassRecord extends GroupRecord {
	private String superClass;
	private List<String> interfaces = new ArrayList<String>();
	private List<String> enumList = new ArrayList<String>();
	private int id;
	private JavaType jtype;

	public String superClass() { return superClass; }
	public List<String> interfaces() { return interfaces; }
	public int id() { return id; }
	public void id(int id) { this.id = id; }
	public boolean isEnum() { return jtype == JavaType.ENUM; }
	@Override public boolean isInterface() { return jtype==JavaType.INTERFACE; }
	public String symbol() { return jtype.symbol(); }

	public List<String> enumList() { return enumList; }
	public void addEnum(String value) { enumList.add(value); }

	/**
	 * NX肷邽߂̏CԂB
	 */
	public String qcn() {
		String qcn = name;
		for(GroupRecord w = owner; w instanceof ClassRecord; w = w.owner) {
			qcn = ((ClassRecord)w).name + "." + qcn;
		}
		return qcn;
	}

	public ClassRecord(String type, String name, int lineno, GroupRecord owner) {
		super(type, name, lineno, owner);
		jtype = JavaType.value(type);
	}

	/**
	 * X[pNXƎׂC^tF[XQ͂Aꂼ
	 * superClass  interfaces ɐݒ肷B
	 * @param decl NX錾<br>
	 * decl̗: public class C1<T,E> extends S1 implements I1, I2
	 */
	@Override protected void paraseDecl(String decl) {
		String[] tokens = decl.split("[,]?\\s+");
		String prevToken = "null";
		for(String token : tokens) {
			if(token.equals("extends") || token.equals("implements")) {
				prevToken = token;
			} else {
				if(prevToken.equals("extends")) {
					superClass = stripGenerics(token);
					prevToken = "null";
				} else if(prevToken.equals("implements")) {
					interfaces.add(stripGenerics(token));
				} else {
					prevToken = token;
				}
			}
		}
	}

	private String stripGenerics(String token) {
		int index = token.indexOf('<');
		return (index < 0) ? token : token.substring(0, index);
	}

	/** ̃NX̌݉͒̃\bh */
	private MethodRecord theMethod;

	/** \bho^B */
	public MethodRecord addMethod(String name, int lineno) {
		theMethod = new MethodRecord(name, lineno, this);
		members.add(theMethod);
		return theMethod;
	}
	/** ݉͒̃\bh̃\bhK͂ݒ肷B */
	public void setMethodLoc(int n, int lineno) {
		theMethod.addLoc(n);
		theMethod.setLineEnd(lineno);
	}
	/** ݉͒̃\bh̖{̋Lq̃g[NǉB */
	public void addMethodToken(String sval) {
		theMethod.addToken(sval);
	}

	/**
	 * ݉͒̃\bh̃VOj`ݒ肷B
	 * @param signature ݏ̃\bh̃VOj`
	 */
	public void setMethodSignature(String signature) {
		theMethod.setSignature(signature);
	}

	/**
	 * NXLOCo͂B
	 * @param out |[g̏o͐
	 * @param nest lXg̐[ɉ󔒕iPxQ̋󔒁j
	 */
	public void printLoc(PrintStream out, String nest) {
		int nMethods = 0;
		int mloc = 0;
		for(ObjectRecord rec : members) {
			if(rec.type.equals("method")) {
				nMethods++;
				mloc += rec.loc;
			}
		}
		// NXANXLOCA\bhA\bhLOC̍vo͂
		out.println(nest + this + " " + nMethods + " " + mloc);
	}

	/** G[bZ[W̕gݗĂ */
	@Override public String errMessage() {
		String methodInfo = (theMethod!=null) ? "\n"+theMethod.errMessage() : "";
		return super.errMessage() + methodInfo;
	}

	/**
	 * Visitorp^[̎󂯓ꑤ\bhBK҂󂯓B
	 * @param visitor ̃NXL^{K
	 */
	@Override public void accept(ObjectVisitor visitor) {
		visitor.visit(this);
	}
}
