package ash.reverse.parser;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;

/**
 * Java\[Xt@Čb͂sB
 * StreamTokenizerƓlɁAgĎgpB
 * <p>
 * g@\F
 * <ul>
 * <li>Java\[XR[hp̐ݒB
 * <li>󔒍sƗLs̃JEgsB
 * <li>ubNƃp[̃xǗB
 * <li>sEOFǂ݂ƂO𔭐A[v̔hB
 * <li>VOj`ǗB<br>
 * 		make/start/append/pruneSignature() gpB
 * <li>g[N̎擾 getToken()\bhōsB
 * <ul>
 */
public class JavaTokenizer extends StreamTokenizer {
	/**
	 * RXgN^̒`F
	 * StreamTokenizer gAJava\[Xt@Čb͂̂߂
	 * ݒsB
	 * @param reader \[Xt@Cǂݎ邽߂̃[_[
	 * @param fname \[Xt@C
	 */
	public JavaTokenizer(Reader reader, String fname) {
		super(reader);
		this.fname = fname;
		this.eof = false;
		// Javap̐ݒ
		//this.resetSyntax();
		this.eolIsSignificant(true);	// sR[ho
 		this.slashStarComments(true);	// /* */ ^̃RgLɂ
 		this.slashSlashComments(true);	// //^Rg̏Lɂ
		this.ordinaryChar('/');			// `/' ̃Rgݒ𖳌ɂ
		this.wordChars('_', '_');		// p̑ɎʎqɎg镶̒`
		this.wordChars('$', '$');		// p̑ɎʎqɎg镶̒`
		this.parseNumbers();			// le͂
	}
	/**
	 * fobOpg[X[`
	 */
	protected void trace() { System.err.println(tokenString()); }
	protected void trace(Object msg) { System.err.println(msg); }

	/**
	 * gNXQƂ
	 */
	protected String fname;				// \[Xt@C
	protected int nSpaceLine = 0;		// 󔒍s̍sJEg
	protected int nLine = 0;			// Ls̍sJEg
	protected int blockLevel = 0;		// ubN{}̃lXg
	protected int parenLevel = 0;		// p[()̃lXg
	/**
	 * p[YȑԂێ邽߂̓
	 */
	private boolean makeSignature = false;
	private int lastLineNum = 1;		// O̗Ls̍sԍ(擪s1)
	private boolean tokenEaten = false;	// stokenꂽtrue
	private boolean eof = false;		// \[Xt@C̏I
	private boolean pushback = false;	// pushBack() ̃tO
	private boolean atmark = false;		// Ame[V`^Q
	private StringBuilder signatureBuffer = new StringBuilder();
	private boolean signatureSwitch = false; // VOj`obt@ւ̏o
	private int c1;						// VOj`obt@̍Ō̕
	private boolean parsingAnnotation;	// Ame[Ṽp[Y𔻒

	protected void appendCloser(String closer) {
		signatureBuffer.append(closer);
	}

	/**
	 * Ame[V̉͂̊JnƏIɌĂяoKvB
	 * ̏̓VOj`̏oɕKvB
	 */
	protected void startAnnotation() { parsingAnnotation = true; }
	protected void endAnnotation() { parsingAnnotation = false; }

	/**
	 * \G[ɂEOFB̃G[gݗĂB
	 * gNXŕt񂪂ꍇ͂̃\bhI[oChΗǂB
	 */
	protected String getErrorInfo() {
		String msg = "*** unexpected EOF:";
		if(fname != null) msg += "\n" + fname;
		return msg;
	}

	/**
	 * tokenǂݎA󔒍sELs̃JEgƃt@C̏I[sB
	 */
	@Override public int nextToken() throws IOException {
		switch(super.nextToken()) {
		case TT_EOF:
			if(eof)	throw new IOException(getErrorInfo());
			eof = true;
			return this.ttype;
		case TT_EOL:
			// 󔒍sۂ𔻒肵A󔒍sȂ΃JEgB
			// ỎsɍstokenĂȂ΁A󔒍sƔ肷B
			if(!tokenEaten)
				nSpaceLine += this.lineno() - lastLineNum;
			tokenEaten = false;
			lastLineNum = this.lineno();
			return this.ttype;
		default:
			// stokenǂݎLsƂăJEg
			if(!tokenEaten) nLine++;
			tokenEaten = true;
			return this.ttype;
		}
	}
	@Override public void pushBack() {
		if(this.ttype == '{') blockLevel--;
		if(this.ttype == '(') parenLevel--;
		pushback = true;
	}
	/**
	 * VOj`𐶐ꍇɌĂԁB
	 */
	protected void makeSignature() { makeSignature = true; }
	/**
	 * VOj`o^JnB
	 */
	protected void startSignature() {
		signatureBuffer.delete(0, Integer.MAX_VALUE);
		signatureSwitch = true;
		c1 = 0;
	}
	/**
	 * VOj`o^IAVOj`ԂB
	 * @return VOj`̕
	 */
	protected String pruneSignature() {
		signatureSwitch = false;
		return signatureBuffer.toString();
	}
	/**
	 * g[NVOj`obt@ɒǉB
	 * @param token 
	 */
	protected void appendSignature(String token) {
		if(!makeSignature || !signatureSwitch) return;
		if((token.equals(";") || token.equals("{")) && !parsingAnnotation) {
			signatureSwitch = false;
			return;
		}
		// c1: VOj`obt@̍Ō̕
		// c2: ǉg[N̐擪
		int c2 = token.charAt(0);
		if(c1 != 0 && c2 != '\t') {
			if(Character.isJavaIdentifierPart(c2)) c2 = 'A';
			if((c1 == 'A' || c1 == ',' || c1 == '?') && c2 == 'A'
			   || c1 == ']' && c2 != '[' && c2 != '>'
			   || c1 == '>' && c2 != '>'
			   || c1 == ')'
			   || c1 != '\t' && c2 == '@'
			   || signatureBuffer.toString().endsWith("..."))
				signatureBuffer.append(' ');
		}
		signatureBuffer.append(token);
		c1 = token.charAt(token.length()-1);
		if(Character.isJavaIdentifierPart(c1)) c1 = 'A';
	}

	/**
	 * tokenǂݎAAme[V(@L@)AvbVobNA
	 * ubNƃp[̃xǗsB
	 * @return g[Nʁithis.ttypełQƂłj
	 */
	protected int getToken() throws IOException {
		while(true) {
			if(!pushback) nextToken();
			if(this.ttype == TT_EOF) return TT_EOF;	// t@CI[ł͉Ȃ
			if(this.ttype == TT_EOL) continue;	// sR[h͓ǂݔ΂
			if(pushback) {
				pushback = false;
			} else {
				appendSignature(tokenString());
			}
			
			if(atmark && this.ttype == TT_WORD) { // Ame[V
				this.sval = "@" + this.sval;
				atmark = false;
				return TT_WORD;
			}
			atmark = (this.ttype == '@');		// Ame[V̑O
			if(atmark) continue;

			// ubNƃp[̃xǗ
			if(this.ttype == '{') blockLevel++;
			else if(this.ttype == '}') blockLevel--;
			else if(this.ttype == '(') parenLevel++;
			else if(this.ttype == ')') parenLevel--;
			return this.ttype;
		}
	}
	private String tokenString() {
		switch(this.ttype) {
		case TT_WORD:   return this.sval;
		case TT_NUMBER: return "" + this.nval;
		case '\'':      return "'" + antiChar(this.sval) + "'";
		case '"':       return "\"" + antiString(this.sval) + "\"";
		default:        return "" + (char)this.ttype;
		}
	}
	private String antiString(String s) {
		StringBuilder sb = new StringBuilder();
		for(int i = 0; i < s.length(); i++) {
			char c = s.charAt(i);
			switch(c) {
			case '\\': sb.append("\\\\"); break;
			case '\n': sb.append("\\n"); break;
			case '\t': sb.append("\\t"); break;
			case '\f': sb.append("\\f"); break;
			case '\r': sb.append("\\r"); break;
			case '"':  sb.append("\\\""); break;
				//case 'u': sb.append("\\"+c); break;
			default: sb.append(c); break;
			}
		}
		return sb.toString();
	}
	private String antiChar(String s) {
		if(s.length() == 1) {
			switch(s.charAt(0)) {
			case '\\': return "\\\\";
			case '\n': return "\\n";
			case '\t': return "\\t";
			case '\f': return "\\f";
			case '\r': return "\\r";
			case '\'': return "\\'";
			default: return s;
			}
		}
		if(s.length() == 5 && s.charAt(0) == 'u') return "\\" + s;
		return s;
	}
}
