/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.mvc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import pbl2011.common.BuiltInClass;
import pbl2011.common.CommonConst;
import pbl2011.common.FileUtil;
import pbl2011.common.JavaCodeGenerator;
import pbl2011.common.Util;
import pbl2011.model.AssociationArc;
import pbl2011.model.Attribute;
import pbl2011.model.ClassModel;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;
import pbl2011.model.NodeArcSet;
import pbl2011.model.PackageManager;
import pbl2011.model.Parameter;
import pbl2011.model.UndoRedoModel;
import pbl2011.mvc.CurrentManager;
import pbl2011.mvc.Observer;

public class Model
implements CommonConst {
    public UndoRedoModel undoredoModel;
    private Set<Observer> registry;
    private boolean isModified = false;
    private List<ClassNode> classList = Collections.synchronizedList(new ArrayList());
    private List<AssociationArc> arcList;
    CurrentManager cuMgr;
    private int maxClassId = 0;
    private int maxAssocId = 0;

    public void attach(Observer observer) {
        if (this.registry == null) {
            this.registry = new HashSet<Observer>();
        }
        this.registry.add(observer);
    }

    public void detach(Observer observer) {
        if (this.registry == null) {
            this.registry = new HashSet<Observer>();
        }
        this.registry.remove(observer);
    }

    public boolean isModified() {
        return this.isModified;
    }

    protected void notifyAllObj() {
        this.isModified = true;
        for (Observer observer : this.registry) {
            observer.update();
        }
    }

    public Model() {
        this.classList.addAll(this.getBuiltinClassNodeList());
        this.arcList = Collections.synchronizedList(new ArrayList());
        this.undoredoModel = new UndoRedoModel();
    }

    protected List<ClassNode> getBuiltinClassNodeList() {
        return BuiltInClass.getBuiltinClassNodeList();
    }

    public CurrentManager getCurrentManager() {
        if (this.cuMgr == null) {
            this.cuMgr = new CurrentManager(this);
        }
        return this.cuMgr;
    }

    public void clearData() {
        this.cuMgr.clear();
        PackageManager.clear();
        this.classList.clear();
        this.classList.addAll(this.getBuiltinClassNodeList());
        this.arcList.clear();
        this.undoredoModel.initializeUndoRedoModel();
        this.maxClassId = 0;
        this.notifyAllObj();
    }

    public void delClassData(ClassNode classNode) {
        this.classList.remove(classNode);
        this.notifyAllObj();
    }

    public void addClass(ArrayList<ClassNode> arrayList) {
        this.classList.addAll(arrayList);
        this.notifyAllObj();
    }

    public void addClass(ClassNode classNode) {
        this.classList.add(classNode);
        this.notifyAllObj();
    }

    public void changeModel() {
        this.notifyAllObj();
    }

    public ArrayList<ClassNode> getAllActiveClassData() {
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        for (ClassNode classNode : this.classList) {
            if (classNode.delFlag || classNode.isBuiltInClass || classNode.p == null) continue;
            arrayList.add(classNode);
        }
        return arrayList;
    }

    public ArrayList<ClassNode> getAllClassData() {
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        for (ClassNode classNode : this.classList) {
            if (classNode.delFlag) continue;
            arrayList.add(classNode);
        }
        return arrayList;
    }

    public ClassNode getClassData(int n) {
        for (ClassNode classNode : this.classList) {
            if (classNode.classId != n) continue;
            return classNode;
        }
        return null;
    }

    public int getClassIdByClassName(String string) {
        for (ClassNode classNode : this.classList) {
            if (!classNode.className.equals(string)) continue;
            return classNode.classId;
        }
        return 0;
    }

    public void removeClassById(ClassNode classNode) {
        for (int i = 0; i < this.classList.size(); ++i) {
            if (classNode.classId != this.classList.get((int)i).classId) continue;
            this.classList.remove(i);
            return;
        }
    }

    public void removeArcById(AssociationArc associationArc) {
        for (int i = 0; i < this.arcList.size(); ++i) {
            if (associationArc.assocId != this.arcList.get((int)i).assocId) continue;
            this.arcList.remove(i);
            return;
        }
    }

    public void setClassDataById(ClassNode classNode) {
        for (int i = 0; i < this.classList.size(); ++i) {
            if (classNode.classId != this.classList.get((int)i).classId) continue;
            this.classList.set(i, classNode.clone());
            return;
        }
    }

    public void setArcDataById(AssociationArc associationArc) {
        for (int i = 0; i < this.arcList.size(); ++i) {
            if (associationArc.assocId != this.arcList.get((int)i).assocId) continue;
            this.arcList.set(i, associationArc.clone());
            return;
        }
    }

    public ArrayList<AssociationArc> getAllActiveAssociationArc() {
        ArrayList<AssociationArc> arrayList = new ArrayList<AssociationArc>();
        for (AssociationArc associationArc : this.arcList) {
            if (associationArc.delFlag) continue;
            arrayList.add(associationArc);
        }
        return arrayList;
    }

    public AssociationArc getAssocData(int n) {
        for (AssociationArc associationArc : this.arcList) {
            if (associationArc.assocId != n) continue;
            return associationArc;
        }
        return null;
    }

    public void addAssociation(ArrayList<AssociationArc> arrayList) {
        this.arcList.addAll(arrayList);
        this.notifyAllObj();
    }

    public void addAssociation(AssociationArc associationArc) {
        this.arcList.add(associationArc);
        this.notifyAllObj();
    }

    public List<AssociationArc> getTargetAssocList(ClassNode classNode) {
        ArrayList<AssociationArc> arrayList = new ArrayList<AssociationArc>();
        if (classNode == null) {
            return arrayList;
        }
        for (AssociationArc associationArc : this.arcList) {
            if (classNode.classId != associationArc.classIdTarget) continue;
            arrayList.add(associationArc);
        }
        return arrayList;
    }

    public List<AssociationArc> getSourceAssocList(ClassNode classNode) {
        ArrayList<AssociationArc> arrayList = new ArrayList<AssociationArc>();
        if (classNode == null) {
            return arrayList;
        }
        for (AssociationArc associationArc : this.arcList) {
            if (classNode.classId != associationArc.classIdSource) continue;
            arrayList.add(associationArc);
        }
        return arrayList;
    }

    public boolean read(BufferedReader bufferedReader, File file) {
        this.clearData();
        ArrayList<ClassNode> arrayList = new ArrayList<ClassNode>();
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        ArrayList<AssociationArc> arrayList2 = new ArrayList<AssociationArc>();
        ClassNode classNode = null;
        Attribute attribute = null;
        Method method = null;
        Parameter parameter = null;
        AssociationArc associationArc = null;
        String string = "";
        try {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            while ((string = bufferedReader.readLine()) != null) {
                arrayList3.add(string);
            }
            Map<String, Integer> map = FileUtil.getUserDefClass(arrayList3);
            Set<String> set = FileUtil.getAllTypeSet(arrayList3);
            int n = FileUtil.getMaxClassId(map);
            for (String string2 : set) {
                if (this.getClassIdByClassName(string2) != 0 || map.containsKey(string2)) continue;
                this.classList.add(this.createClassNode(++n, string2));
                assert (Util.debug("##########  \u672a\u5b9a\u7fa9\u306e\u578b\u3092\u8a2d\u5b9a  ########## className=" + string2 + ",classId=" + n));
            }
            for (String string2 : arrayList3) {
                Object object;
                if (FileUtil.isClass(string2)) {
                    classNode = this.createClassNode(string2);
                    arrayList.add(classNode);
                    continue;
                }
                if (FileUtil.isPackage(string2)) {
                    object = string2.split("\t");
                    hashMap.put(Integer.valueOf(object[1]), object[2]);
                    continue;
                }
                if (FileUtil.isAttrib(string2)) {
                    attribute = this.makeAttribute(string2, map);
                    classNode.attributeList.add(attribute);
                    continue;
                }
                if (FileUtil.isMethod(string2)) {
                    method = this.makeMethod(string2, map);
                    classNode.methodList.add(method);
                    continue;
                }
                if (FileUtil.isParam(string2)) {
                    parameter = this.makeParameter(string2, map);
                    object = classNode.methodList.get(classNode.methodList.size() - 1);
                    object.parameterList.add(parameter);
                    continue;
                }
                if (!FileUtil.isArc(string2)) continue;
                associationArc = new AssociationArc(string2);
                if (associationArc.assocId < 0) {
                    associationArc.assocId = this.getNewAssocId();
                }
                arrayList2.add(associationArc);
            }
            PackageManager.add(hashMap);
            this.addClass(arrayList);
            this.addAssociation(arrayList2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    protected ClassNode createClassNode(String string) {
        return new ClassModel(string);
    }

    protected ClassNode createClassNode(int n, String string) {
        return new ClassModel(n, string);
    }

    public Attribute makeAttribute(String string, Map<String, Integer> map) {
        String[] stringArray = string.split("\t");
        int n = 1;
        String string2 = stringArray[n++];
        String string3 = stringArray[n++];
        String string4 = this.getTypeIdByTypeName(string3, map);
        assert (string4 != null) : string;
        CommonConst.VisibilityType visibilityType = CommonConst.VisibilityType.aliasOf(stringArray[n++]);
        return new Attribute(string2, string4, visibilityType);
    }

    public Method makeMethod(String string, Map<String, Integer> map) {
        String string2;
        String[] stringArray = string.split("\t");
        int n = 1;
        String string3 = stringArray[n++];
        if ((string2 = stringArray[n++]) == null || "null".equals(string2)) {
            string2 = "";
        }
        String string4 = this.getTypeIdByTypeName(string2, map);
        assert (string4 != null) : string;
        CommonConst.VisibilityType visibilityType = CommonConst.VisibilityType.aliasOf(stringArray[n++]);
        return new Method(string3, string4, visibilityType);
    }

    public Parameter makeParameter(String string, Map<String, Integer> map) {
        String[] stringArray = string.split("\t");
        int n = 1;
        String string2 = stringArray[n++];
        String string3 = stringArray[n++];
        String string4 = this.getTypeIdByTypeName(string3, map);
        assert (string4 != null) : string;
        return new Parameter(string2, string4);
    }

    public String getTypeIdByTypeName(String string) {
        if (Util.hasSymbol(string)) {
            String string2 = string.replace(" ", "");
            List<String> list = Util.getTypeList(string2);
            for (String string3 : list) {
                this.addNoDefClass(string3);
                string2 = string2.replace(string3, String.valueOf(this.getClassIdByClassName(string3)));
            }
            return string2;
        }
        this.addNoDefClass(string);
        return String.valueOf(this.getClassIdByClassName(string));
    }

    private void addNoDefClass(String string) {
        if (this.getClassIdByClassName(string) == 0) {
            this.classList.add(this.createClassNode(this.getNextClassId(), string));
            assert (Util.debug("##########  \u672a\u5b9a\u7fa9\u306e\u578b\u3092\u8a2d\u5b9a  ########## typeName=" + string + ",classId=" + this.maxClassId));
        }
    }

    public String getTypeIdByTypeName(String string, Map<String, Integer> map) {
        if (Util.hasSymbol(string)) {
            String string2 = string.replace(" ", "");
            List<String> list = Util.getTypeList(string2);
            for (String string3 : list) {
                if (this.getClassIdByClassName(string3) != 0) {
                    string2 = string2.replace(string3, String.valueOf(this.getClassIdByClassName(string3)));
                    continue;
                }
                string2 = string2.replace(string3, String.valueOf(map.get(string3)));
            }
            return string2;
        }
        if (this.getClassIdByClassName(string) != 0) {
            return String.valueOf(this.getClassIdByClassName(string));
        }
        return String.valueOf(map.get(string));
    }

    public String getTypeNameByTypeId(String string) {
        if (Util.hasSymbol(string)) {
            String string2 = string.replace(" ", "");
            List<String> list = Util.getTypeList(string2);
            for (String string3 : list) {
                string2 = string2.replace(string3, this.getClassData((int)Integer.valueOf((String)string3).intValue()).className);
            }
            return string2;
        }
        return this.getClassData((int)Integer.valueOf((String)string).intValue()).className;
    }

    public ClassNode getTypeByTypeId(String string) {
        if (Util.hasSymbol(string)) {
            return this.getClassData(Util.removeSymbol(string));
        }
        return this.getClassData(Integer.valueOf(string));
    }

    public boolean save(BufferedWriter bufferedWriter, File file) {
        assert (Util.debug("executeSave"));
        try {
            this.writeLine(bufferedWriter, PackageManager.write());
            for (ClassNode commonConst : this.getAllActiveClassData()) {
                int n = commonConst.classId;
                if (!commonConst.isBuiltInClass) {
                    this.writeLine(bufferedWriter, commonConst.toString());
                }
                for (Attribute attribute : commonConst.attributeList) {
                    this.writeLine(bufferedWriter, this.replaceIdToName(attribute.toString(n)));
                }
                for (Method method : commonConst.methodList) {
                    this.writeLine(bufferedWriter, this.replaceIdToName(method.toString(n)));
                    for (Parameter parameter : method.parameterList) {
                        this.writeLine(bufferedWriter, this.replaceIdToName(parameter.toString(n)));
                    }
                }
            }
            bufferedWriter.newLine();
            for (AssociationArc associationArc : this.getAllActiveAssociationArc()) {
                this.writeLine(bufferedWriter, associationArc.toString());
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void writeLine(BufferedWriter bufferedWriter, String string) throws IOException {
        bufferedWriter.write(string);
        bufferedWriter.newLine();
    }

    public int getNextClassId() {
        if (this.maxClassId < 1) {
            this.calcMaxClassId();
        }
        return ++this.maxClassId;
    }

    private void calcMaxClassId() {
        for (ClassNode classNode : this.classList) {
            if (classNode.isBuiltInClass || this.maxClassId >= classNode.classId) continue;
            this.maxClassId = classNode.classId;
        }
    }

    public int getNewAssocId() {
        if (this.maxAssocId < 1) {
            this.calcMaxAssocId();
        }
        return ++this.maxAssocId;
    }

    private void calcMaxAssocId() {
        for (AssociationArc associationArc : this.arcList) {
            if (this.maxAssocId >= associationArc.assocId) continue;
            this.maxAssocId = associationArc.assocId;
        }
    }

    private String replaceIdToName(String string) {
        String[] stringArray = string.split("\t");
        String string2 = stringArray[2];
        String string3 = this.getTypeNameByTypeId(string2);
        return string.replace(string2, string3);
    }

    public void changeAssociationArc(String string, AssociationArc associationArc, String string2, Boolean bl, String string3) {
        if ("t".equals(string)) {
            associationArc.changeT(string2, bl, string3);
        } else if ("s".equals(string)) {
            associationArc.changeS(string2, bl, string3);
        }
        this.notifyAllObj();
    }

    public void changeAssociationArc(String string, AssociationArc associationArc, String string2, Boolean bl, String string3, int n) {
        this.changeAssociationArc(string, associationArc, string2, bl, string3);
    }

    public void deleteClass() {
        NodeArcSet nodeArcSet = new NodeArcSet();
        ArrayList<ClassNode> arrayList = this.cuMgr.getCurrentNodeList();
        for (ClassNode classNode : arrayList) {
            classNode.delFlag = true;
            nodeArcSet.add(classNode);
            ArrayList<AssociationArc> arrayList2 = this.getAllActiveAssociationArc();
            for (AssociationArc associationArc : arrayList2) {
                if (associationArc.classIdTarget != classNode.classId && associationArc.classIdSource != classNode.classId) continue;
                associationArc.delFlag = true;
                nodeArcSet.add(associationArc);
            }
        }
        this.undoredoModel.tryPush(nodeArcSet);
        this.cuMgr.clear();
        this.notifyAllObj();
    }

    public String[] getReturnTypeList() {
        return this.toStringArray(this.getAllTypeList());
    }

    public String[] getTypeList() {
        List<String> list = this.getAllTypeList();
        list.remove("void");
        list.remove("");
        return this.toStringArray(list);
    }

    private List<String> getAllTypeList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ClassNode classNode : this.getAllClassData()) {
            arrayList.add(classNode.className);
        }
        return arrayList;
    }

    private String[] toStringArray(List<String> list) {
        String[] stringArray = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            stringArray[i] = list.get(i);
        }
        return stringArray;
    }

    public void outputJavaCode(File file) throws IOException {
        ArrayList<ClassNode> arrayList = this.getAllActiveClassData();
        if (arrayList.size() < 1) {
            JOptionPane.showMessageDialog(null, "\u51fa\u529b\u5bfe\u8c61\u3068\u306a\u308b\u30af\u30e9\u30b9\u304c\u5b58\u5728\u3057\u307e\u305b\u3093\u3002");
        }
        JavaCodeGenerator.generate(file, this.classList);
    }

    public void updateClass(ClassNode classNode) {
        classNode.autoAdjust();
        ClassNode classNode2 = this.getClassData(classNode.classId);
        int n = this.classList.indexOf(classNode2);
        this.classList.remove(n);
        this.classList.add(n, classNode);
        this.notifyAllObj();
    }

    public void checkMultiInherit() {
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        HashSet<ClassNode> hashSet = new HashSet<ClassNode>();
        for (AssociationArc object : this.arcList) {
            if (!object.getKind().isEXTENDS() || object.delFlag || this.getClassData((int)object.classIdTarget).classType.isINTERFACE()) continue;
            if (hashMap.containsKey(object.classIdSource)) {
                hashSet.add(this.getClassData(object.classIdSource));
            }
            hashMap.put(object.classIdSource, object.classIdTarget);
        }
        if (hashSet.size() < 1) {
            JOptionPane.showMessageDialog(null, "\u591a\u91cd\u7d99\u627f\u3057\u3066\u3044\u308b\u30af\u30e9\u30b9\u306f\u3042\u308a\u307e\u305b\u3093\u3002");
        } else {
            StringBuffer stringBuffer = new StringBuffer(System.getProperty("line.separator"));
            for (ClassNode classNode : hashSet) {
                stringBuffer.append(classNode.className + System.getProperty("line.separator"));
            }
            JOptionPane.showMessageDialog(null, "\u4ee5\u4e0b\u306e\u30af\u30e9\u30b9\u304c\u591a\u91cd\u7d99\u627f\u3057\u3066\u3044\u307e\u3059\u3002" + stringBuffer.toString());
        }
    }
}

