/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.model;

import java.util.HashMap;
import java.util.Map;
import pbl2011.common.CommonConst;

public class PackageManager
implements CommonConst {
    private static Map<Integer, String> packageMap = new HashMap<Integer, String>();
    private static int maxPackageId;

    private static int getNextPackageId() {
        if (maxPackageId < 1) {
            PackageManager.calcMaxPackageId();
        }
        return ++maxPackageId;
    }

    private static void calcMaxPackageId() {
        for (Integer n : packageMap.keySet()) {
            if (!PackageManager.isUserDefinitionPackage(n) || maxPackageId >= n) continue;
            maxPackageId = n;
        }
    }

    private static void init() {
        packageMap.clear();
        packageMap.put(PACKAGE_DEFAULT_ID, "(default)");
        packageMap.put(PACKAGE_JAVA_LANG_ID, "java.lang");
    }

    public static void clear() {
        PackageManager.init();
    }

    public static Integer add(String string) {
        if (packageMap.containsValue(string)) {
            return PackageManager.getPackageId(string);
        }
        Integer n = PackageManager.getNextPackageId();
        packageMap.put(n, string);
        return n;
    }

    public static void add(Map<Integer, String> map) {
        packageMap.putAll(map);
    }

    public static Integer getPackageId(String string) {
        for (Map.Entry<Integer, String> entry : packageMap.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getPackageName(Integer n) {
        return packageMap.get(n);
    }

    public static String write() {
        StringBuffer stringBuffer = new StringBuffer();
        for (Integer n : packageMap.keySet()) {
            if (!PackageManager.isUserDefinitionPackage(n)) continue;
            stringBuffer.append(CommonConst.PackageType.PACKAGE.alias());
            stringBuffer.append("\t");
            stringBuffer.append(n);
            stringBuffer.append("\t");
            stringBuffer.append(packageMap.get(n));
            stringBuffer.append(System.getProperty("line.separator"));
        }
        return stringBuffer.toString();
    }

    public static boolean isUserDefinitionPackage(int n) {
        return n < PACKAGE_DEFAULT_ID;
    }

    public static boolean isNeedImport(int n) {
        return PACKAGE_DEFAULT_ID != n && PACKAGE_JAVA_LANG_ID != n;
    }

    static {
        PackageManager.init();
        maxPackageId = 0;
    }
}

