/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.model;

import java.awt.Point;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;
import pbl2011.model.Attribute;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;

public class ClassModel
extends ClassNode {
    public ClassModel(String string) {
        String[] stringArray = string.split("\t");
        int n = 0;
        this.classType = CommonConst.ClassType.aliasOf(stringArray[n++]);
        this.classId = Integer.parseInt(stringArray[n++]);
        this.className = stringArray[n++];
        this.visibility = CommonConst.VisibilityType.aliasOf(stringArray[n++]);
        this.p = Util.adjust(new Point(Integer.parseInt(stringArray[n++]), Integer.parseInt(stringArray[n++])));
        this.height1 = Util.adjust(Integer.parseInt(stringArray[n++]));
        this.height2 = Util.adjust(Integer.parseInt(stringArray[n++]));
        this.height3 = Util.adjust(Integer.parseInt(stringArray[n++]));
        this.width = Util.adjust(Integer.parseInt(stringArray[n++]));
        try {
            this.packageId = Integer.parseInt(stringArray[n++]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.packageId = PACKAGE_DEFAULT_ID;
        }
        try {
            this.colorRed = Integer.parseInt(stringArray[n++]);
            this.colorGreen = Integer.parseInt(stringArray[n++]);
            this.colorBlue = Integer.parseInt(stringArray[n++]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.colorRed = 204;
            this.colorGreen = 255;
            this.colorBlue = 255;
        }
    }

    public ClassModel(int n, Point point) {
        this.classId = n;
        this.packageId = 0;
        this.delFlag = false;
        this.className = "";
        this.visibility = CommonConst.VisibilityType.PUBLIC;
        this.p = point;
        this.height1 = 24;
        this.height2 = 8;
        this.height3 = 8;
        this.width = 80;
        this.colorRed = 204;
        this.colorGreen = 255;
        this.colorBlue = 255;
    }

    public ClassModel(ClassModel classModel) {
        CommonConst commonConst;
        this.classType = classModel.classType;
        this.classId = classModel.classId;
        this.className = classModel.className;
        this.visibility = classModel.visibility;
        this.p = new Point(classModel.p.x, classModel.p.y);
        this.height1 = classModel.height1;
        this.height2 = classModel.height2;
        this.height3 = classModel.height3;
        this.width = classModel.width;
        this.colorRed = classModel.colorRed;
        this.colorGreen = classModel.colorGreen;
        this.colorBlue = classModel.colorBlue;
        this.packageId = classModel.packageId;
        this.delFlag = classModel.delFlag;
        for (CommonConst commonConst2 : classModel.methodList) {
            commonConst = ((Method)commonConst2).clone();
            this.methodList.add(commonConst);
        }
        for (CommonConst commonConst2 : classModel.attributeList) {
            commonConst = ((Attribute)commonConst2).clone();
            this.attributeList.add(commonConst);
        }
        this.undoredoModel = classModel.undoredoModel;
    }

    public ClassModel(int n, int n2, String string) {
        this.classId = n;
        this.packageId = n2;
        this.classType = CommonConst.ClassType.CLASS;
        this.className = string;
        this.visibility = CommonConst.VisibilityType.PUBLIC;
        this.delFlag = false;
        this.isBuiltInClass = true;
    }

    public ClassModel(int n, String string) {
        this.classId = n;
        this.packageId = PACKAGE_DEFAULT_ID;
        this.classType = CommonConst.ClassType.CLASS;
        this.className = string;
        this.visibility = CommonConst.VisibilityType.PUBLIC;
        this.delFlag = false;
        this.p = null;
        this.height1 = 24;
        this.height2 = 8;
        this.height3 = 8;
    }

    @Override
    public String toString() {
        return this.classType.alias() + "\t" + this.classId + "\t" + this.className + "\t" + this.visibility.alias() + "\t" + this.p.x + "\t" + this.p.y + "\t" + this.height1 + "\t" + this.height2 + "\t" + this.height3 + "\t" + this.width + "\t" + this.packageId + "\t" + this.colorRed + "\t" + this.colorGreen + "\t" + this.colorBlue;
    }

    @Override
    public ClassModel clone() {
        return new ClassModel((ClassModel)super.clone());
    }
}

