/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;
import pbl2011.gui.State;
import pbl2011.gui.UMLCanvasController;
import pbl2011.model.AssociationArc;
import pbl2011.model.Attribute;
import pbl2011.model.ClassModel;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;
import pbl2011.mvc.Controller;
import pbl2011.mvc.Model;
import pbl2011.mvc.View;

public class UMLCanvas
extends View {
    int scale;
    BufferedImage img = null;
    boolean mainCanvas;
    protected Point startPt;
    protected Point endPt;

    public UMLCanvas(int n, Model model) {
        super(model);
        this.scale = n;
        if (n == 1) {
            this.mainCanvas = true;
        }
        this.addMouseListener((UMLCanvasController)this.myController);
        this.addMouseMotionListener(this.myController);
        this.initialize();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.img == null) {
            this.img = (BufferedImage)this.createImage(this.scaledown(State.width), this.scaledown(State.height));
        }
        Graphics2D graphics2D = this.img.createGraphics();
        Graphics2D graphics2D2 = (Graphics2D)graphics;
        if (State.font != null) {
            graphics2D.setFont(State.font);
        }
        State.fm = graphics2D.getFontMetrics(graphics2D.getFont());
        graphics2D.setColor(Color.WHITE);
        graphics2D.fillRect(0, 0, this.scaledown(State.width), this.scaledown(State.height));
        if (State.gridlineFlag) {
            this.grawGridLine(graphics2D);
        }
        ArrayList<ClassNode> arrayList = this.myModel.getAllActiveClassData();
        ArrayList<AssociationArc> arrayList2 = this.myModel.getAllActiveAssociationArc();
        ClassNode classNode = this.cuMgr.getCurrentNode();
        ArrayList<ClassNode> arrayList3 = this.cuMgr.getCurrentNodeList();
        if (classNode != null && State.gridFlag) {
            this.drawCurrentGridLine(graphics2D, classNode);
        }
        BasicStroke basicStroke = new BasicStroke(this.getLineSize());
        graphics2D.setStroke(basicStroke);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (AssociationArc commonConst : arrayList2) {
            this.drawArcLine(graphics2D, commonConst);
        }
        for (ClassNode classNode2 : arrayList) {
            if (classNode2.equals(classNode) || arrayList3.contains(classNode2)) continue;
            this.drawClass(graphics2D, classNode2);
        }
        if (State.arcSelect != null) {
            this.dragNewArc(graphics2D);
        }
        if (arrayList3.size() > 0) {
            for (ClassNode classNode3 : arrayList3) {
                this.drawClass(graphics2D, classNode3);
                this.drawKnobs(graphics2D, classNode3);
            }
        }
        this.drowArcPoint(graphics2D);
        graphics2D.setColor(Color.magenta);
        Rectangle rectangle = this.cuMgr.getSelectRect();
        if (rectangle != null) {
            this.drawRect(graphics2D, rectangle);
        }
        graphics2D2.drawImage((Image)this.img, 0, 0, null);
    }

    public BufferedImage getCanvasImg() {
        return this.img;
    }

    @Override
    protected Controller makeController() {
        return new UMLCanvasController(this);
    }

    @Override
    protected void initialize() {
        assert (Util.debug("initialize"));
        this.setPreferredSize(new Dimension(this.scaledown(State.width), this.scaledown(State.height)));
        this.img = (BufferedImage)this.createImage(this.scaledown(State.width), this.scaledown(State.height));
        this.revalidate();
    }

    @Override
    protected void draw() {
        this.repaint();
    }

    protected void grawGridLine(Graphics graphics) {
        int n;
        int n2 = 8 * this.scale;
        graphics.setColor(Color.YELLOW);
        for (n = n2; n < State.width; n += n2) {
            this.drawLine(graphics, n, 0, n, State.height);
        }
        for (n = n2; n < State.height; n += n2) {
            this.drawLine(graphics, 0, n, State.width, n);
        }
    }

    protected void drawCurrentGridLine(Graphics2D graphics2D, ClassNode classNode) {
        float[] fArray = new float[]{3.0f, 2.0f};
        BasicStroke basicStroke = new BasicStroke(this.getLineSize(), 0, 1, 2.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        graphics2D.setColor(Color.GREEN);
        this.drawLine(graphics2D, classNode.p.x, 0, classNode.p.x, State.height);
        this.drawLine(graphics2D, classNode.p.x + classNode.width, 0, classNode.p.x + classNode.width, State.height);
        this.drawLine(graphics2D, 0, classNode.p.y, State.width, classNode.p.y);
        this.drawLine(graphics2D, 0, classNode.p.y + classNode.height(), State.width, classNode.p.y + classNode.height());
    }

    protected void drawClass(Graphics graphics, ClassNode classNode) {
        if (!classNode.isBuiltInClass) {
            int n = classNode.p.x;
            int n2 = classNode.p.y;
            graphics.setColor(new Color(classNode.colorRed, classNode.colorGreen, classNode.colorBlue));
            this.fillRect(graphics, n, n2, classNode.width, classNode.height());
            graphics.setColor(Color.BLACK);
            this.drawRect(graphics, n, n2, classNode.width, classNode.height());
            this.drawLine(graphics, n, n2 + classNode.height1, n + classNode.width, n2 + classNode.height1);
            this.drawLine(graphics, n, n2 + classNode.height1 + classNode.height2, n + classNode.width, n2 + classNode.height1 + classNode.height2);
            graphics.setColor(Color.BLACK);
            if (this.mainCanvas) {
                graphics.drawString(classNode.visibilityMark() + classNode.typeMark() + " " + classNode.className, classNode.p.x + 8, classNode.p.y + this.getLineHight());
                int n3 = 0;
                for (Attribute commonConst : classNode.attributeList) {
                    if (commonConst.visibility.level() > State.attributeVisibility) continue;
                    graphics.drawString(commonConst.visibilityMark() + commonConst.attributeName, classNode.p.x + 8, classNode.p.y + classNode.height1 + n3 * this.getLineHight() + this.getLineHight());
                    ++n3;
                }
                n3 = 0;
                for (Method method : classNode.methodList) {
                    if (method.visibility.level() > State.methodVisibility) continue;
                    graphics.drawString(method.visibilityMark() + method.methodName, classNode.p.x + 8, classNode.p.y + classNode.height1 + classNode.height2 + n3 * this.getLineHight() + this.getLineHight());
                    ++n3;
                }
            }
        }
    }

    private int getLineHight() {
        return State.fm.getHeight() + 2;
    }

    protected void drawArcLine(Graphics graphics, AssociationArc associationArc) {
        Point[] pointArray = this.getArcPointList(associationArc);
        this.drawArcLine(graphics, pointArray, associationArc);
    }

    private void drawArcLine(Graphics graphics, Point[] pointArray, AssociationArc associationArc) {
        ClassNode classNode = this.myModel.getClassData(associationArc.classIdTarget);
        ClassNode classNode2 = this.myModel.getClassData(associationArc.classIdSource);
        if (pointArray != null) {
            int n = pointArray.length;
            graphics.setColor(this.getArcColor(associationArc));
            if (this.isBrokenLine(classNode, classNode2, associationArc)) {
                for (int i = 0; i < n - 1; ++i) {
                    this.drawBrokenLine(graphics, pointArray[i], pointArray[i + 1]);
                }
            } else {
                for (int i = 0; i < n - 1; ++i) {
                    this.drawLine(graphics, pointArray[i], pointArray[i + 1]);
                }
            }
            if (associationArc.getKind().isASSOC() || associationArc.getKind().isDEPENDS()) {
                if (associationArc.naviTarget) {
                    this.drawArrow(graphics, pointArray[0], pointArray[1]);
                }
                if (associationArc.naviSource) {
                    this.drawArrow(graphics, pointArray[n - 1], pointArray[n - 2]);
                }
            } else if (associationArc.getKind().isEXTENDS()) {
                if (associationArc.naviTarget) {
                    this.drawExtendArrow(graphics, this.getArcColor(associationArc), pointArray[0], pointArray[1]);
                }
                if (associationArc.naviSource) {
                    this.drawExtendArrow(graphics, this.getArcColor(associationArc), pointArray[n - 1], pointArray[n - 2]);
                }
            } else if (associationArc.getKind().isINNER()) {
                this.drawInner(graphics, this.getArcColor(associationArc), pointArray[0], pointArray[1]);
            }
            this.drawMultiplicity(graphics, associationArc, pointArray[0], pointArray[1]);
        }
    }

    protected void drowArcPoint(Graphics graphics) {
        if (this.cuMgr.getCurrentArc() != null && this.mainCanvas && this.cuMgr.getCurrentArc().lineStyle.isFREE_LINE()) {
            this.drowPoint(graphics, this.getArcPointList(this.cuMgr.getCurrentArc()));
        }
    }

    private void drowPoint(Graphics graphics, Point[] pointArray) {
        for (Point point : pointArray) {
            graphics.setColor(Color.RED);
            this.fillOval(graphics, point.x, point.y, 8);
        }
    }

    private boolean isBrokenLine(ClassNode classNode, ClassNode classNode2, AssociationArc associationArc) {
        if (associationArc.getKind().isEXTENDS()) {
            return classNode.isInterfaceNode() && classNode2.isClassNode();
        }
        return associationArc.getKind().isDEPENDS();
    }

    private void drawInner(Graphics graphics, Color color, Point point, Point point2) {
        double d = Math.atan2(point2.y - point.y, point2.x - point.x);
        int n = point.x + (int)(6.0 * Math.cos(d));
        int n2 = point.y + (int)(6.0 * Math.sin(d));
        int n3 = 4;
        int n4 = 8;
        graphics.setColor(Color.WHITE);
        this.fillOval(graphics, n, n2, n4);
        graphics.setColor(color);
        this.drawOval(graphics, n, n2, n4);
        this.drawLine(graphics, n - n3, n2, n + n3, n2);
        this.drawLine(graphics, n, n2 - n3, n, n2 + n3);
    }

    private void drawMultiplicity(Graphics graphics, AssociationArc associationArc, Point point, Point point2) {
        if (!this.mainCanvas) {
            return;
        }
        String string = associationArc.multiplTarget;
        if (string.equals("null")) {
            return;
        }
        if (string.equals("0..1")) {
            string = "1";
        }
        double d = Math.atan2(point2.y - point.y, point2.x - point.x) + 0.5235987755982988;
        int n = point.x + (int)(16.0 * Math.cos(d));
        int n2 = point.y + (int)(16.0 * Math.sin(d));
        graphics.drawString(string, n - 3, n2 + 6);
    }

    private void drawArrow(Graphics graphics, Point point, Point point2) {
        int[] nArray = Util.calcArrowPoint(point, point2);
        this.drawLine(graphics, point.x, point.y, nArray[0], nArray[1]);
        this.drawLine(graphics, point.x, point.y, nArray[2], nArray[3]);
    }

    private void drawExtendArrow(Graphics graphics, Color color, Point point, Point point2) {
        int[] nArray = Util.calcTrianglePoint(point, point2);
        int[] nArray2 = new int[]{point.x, nArray[0], nArray[2], point.y, nArray[1], nArray[3]};
        graphics.setColor(Color.WHITE);
        this.fillPolygon(graphics, nArray2);
        graphics.setColor(color);
        this.drawPolygon(graphics, nArray2);
    }

    private void drawBrokenLine(Graphics graphics, Point point, Point point2) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Stroke stroke = graphics2D.getStroke();
        float[] fArray = new float[]{5.0f, 3.0f};
        BasicStroke basicStroke = new BasicStroke(this.getLineSize(), 0, 1, 3.0f, fArray, 0.0f);
        graphics2D.setStroke(basicStroke);
        this.drawLine(graphics, point, point2);
        graphics2D.setStroke(stroke);
    }

    protected float getLineSize() {
        if (this.mainCanvas) {
            return 1.5f;
        }
        return 1.0f;
    }

    protected Color getArcColor(AssociationArc associationArc) {
        if (associationArc == this.cuMgr.getCurrentArc()) {
            return Color.MAGENTA;
        }
        return Color.BLACK;
    }

    protected void dragNewArc(Graphics graphics) {
        if (this.startPt == null || this.endPt == null) {
            return;
        }
        graphics.setColor(Color.MAGENTA);
        this.drawLine(graphics, this.startPt, this.endPt);
    }

    protected void drawKnobs(Graphics graphics, ClassNode classNode) {
        int n = classNode.p.x;
        int n2 = classNode.p.y;
        if (this.mainCanvas) {
            graphics.setColor(Color.BLACK);
            this.drawKnob(graphics, n, n2);
            this.drawKnob(graphics, n, n2 + classNode.height1);
            this.drawKnob(graphics, n + classNode.width, n2);
            this.drawKnob(graphics, n + classNode.width, n2 + classNode.height1);
            this.drawKnob(graphics, n, n2 + classNode.height1 + classNode.height2);
            this.drawKnob(graphics, n, n2 + classNode.height());
            this.drawKnob(graphics, n + classNode.width, n2 + classNode.height1 + classNode.height2);
            this.drawKnob(graphics, n + classNode.width, n2 + classNode.height());
        } else {
            graphics.setColor(Color.MAGENTA);
            this.drawRect(graphics, n, n2, classNode.width, classNode.height());
            this.drawLine(graphics, n, n2 + classNode.height1, n + classNode.width, n2 + classNode.height1);
            this.drawLine(graphics, n, n2 + classNode.height1 + classNode.height2, n + classNode.width, n2 + classNode.height1 + classNode.height2);
        }
    }

    void moveFrame(int n, int n2) {
        assert (Util.debug("moveFrame"));
        n = this.multiply(n);
        n2 = this.multiply(n2);
        int n3 = this.multiply(State.width);
        int n4 = this.multiply(State.height);
        ArrayList<ClassNode> arrayList = this.cuMgr.getCurrentNodeList();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (ClassNode commonConst : arrayList) {
            arrayList2.add(commonConst.classId);
            commonConst.moveDelta(n, n2, n3, n4);
        }
        for (AssociationArc associationArc : this.myModel.getAllActiveAssociationArc()) {
            if (!associationArc.lineStyle.isFREE_LINE()) continue;
            if (arrayList2.contains(associationArc.classIdSource) && arrayList2.contains(associationArc.classIdTarget)) {
                for (Point point : associationArc.pointList) {
                    point.x += n;
                    point.y += n2;
                }
                continue;
            }
            if (arrayList2.contains(associationArc.classIdSource)) {
                associationArc.pointList[associationArc.pointList.length - 1].x += n;
                associationArc.pointList[associationArc.pointList.length - 1].y += n2;
                continue;
            }
            if (!arrayList2.contains(associationArc.classIdTarget)) continue;
            associationArc.pointList[0].x += n;
            associationArc.pointList[0].y += n2;
        }
        this.repaint();
    }

    void dragFrame(Point point, Point point2, Point point3, int n, int n2) {
        ClassNode classNode = this.cuMgr.getCurrentNode();
        if (classNode == null) {
            return;
        }
        int n3 = classNode.p.x;
        int n4 = classNode.p.y;
        int n5 = classNode.calcMinWidth();
        if (n2 == 2 && point3.x - point.x > n5) {
            n5 = point3.x - point.x;
        } else if (n2 == 1 && point.x - point3.x > n5) {
            n3 = point3.x;
            n5 = point.x - point3.x;
        }
        int n6 = classNode.height1;
        int n7 = classNode.height2;
        int n8 = classNode.height3;
        switch (n) {
            case 1: {
                n6 = classNode.calcMinHeigh1();
                if (point3.y > point.y && point3.y - point.y > n6) {
                    n6 = point3.y - point.y;
                    break;
                }
                if (point.y <= point3.y || point.y - point3.y <= n6) break;
                n4 = point3.y;
                n6 = point.y - point3.y;
                break;
            }
            case 2: {
                n7 = classNode.calcMinHeigh2();
                if (point3.y - point.y <= n7) break;
                n7 = point3.y - point.y;
                break;
            }
            case 3: {
                n8 = classNode.calcMinHeigh3();
                if (point3.y - point.y <= n8) break;
                n8 = point3.y - point.y;
            }
        }
        classNode.resize(n3, n4, n5, n6, n7, n8);
        this.moveFreeArc(classNode);
        this.repaint();
    }

    private void moveFreeArc(ClassNode classNode) {
        for (AssociationArc associationArc : this.myModel.getAllActiveAssociationArc()) {
            Point point;
            if (!associationArc.lineStyle.isFREE_LINE()) continue;
            if (classNode.classId == associationArc.classIdSource) {
                point = Util.calcCrossPoint(classNode.getRectangle(), associationArc.pointList[associationArc.pointList.length - 2]);
                if (point != null) {
                    associationArc.pointList[associationArc.pointList.length - 1] = point;
                    continue;
                }
                associationArc.delPoint(associationArc.pointList.length - 1);
                continue;
            }
            if (classNode.classId != associationArc.classIdTarget) continue;
            point = Util.calcCrossPoint(classNode.getRectangle(), associationArc.pointList[1]);
            if (point != null) {
                associationArc.pointList[0] = point;
                continue;
            }
            associationArc.delPoint(0);
        }
    }

    void moveArcPoint(Point point, int n) {
        if (this.cuMgr.getCurrentArc() != null) {
            Point[] pointArray = this.cuMgr.getCurrentArc().pointList;
            if (n == 0) {
                this.calcPoint(point, this.myModel.getClassData(this.cuMgr.getCurrentArc().classIdTarget));
            } else if (n == pointArray.length - 1) {
                this.calcPoint(point, this.myModel.getClassData(this.cuMgr.getCurrentArc().classIdSource));
            }
            pointArray[n] = point;
        }
        this.repaint();
    }

    protected void calcPoint(Point point, ClassNode classNode) {
        if (point.x < classNode.p.x) {
            point.x = classNode.p.x;
        } else if (point.x > classNode.p.x + classNode.width) {
            point.x = classNode.p.x + classNode.width;
        }
        if (point.y < classNode.p.y) {
            point.y = classNode.p.y;
        } else if (point.y > classNode.p.y + classNode.height()) {
            point.y = classNode.p.y + classNode.height();
        }
    }

    ClassNode selectClass(Point point) {
        ArrayList arrayList = (ArrayList)this.myModel.getAllActiveClassData().clone();
        Collections.reverse(arrayList);
        if (this.cuMgr.getCurrentNode() != null) {
            arrayList.add(0, this.cuMgr.getCurrentNode());
        }
        return this.selectClass(point, arrayList);
    }

    ClassNode selectClass(Point point, ArrayList<ClassNode> arrayList) {
        int n = 3;
        for (ClassNode classNode : arrayList) {
            if (classNode.isBuiltInClass) continue;
            int n2 = this.multiply(point.x);
            int n3 = this.multiply(point.y);
            if (n2 <= classNode.p.x - n || classNode.p.x + classNode.width + n <= n2 || n3 <= classNode.p.y - n || classNode.p.y + classNode.height() + n <= n3) continue;
            assert (Util.debug("in"));
            return classNode;
        }
        assert (Util.debug("out"));
        return null;
    }

    AssociationArc selectArc(Point point) {
        ArrayList<AssociationArc> arrayList = this.myModel.getAllActiveAssociationArc();
        for (AssociationArc associationArc : arrayList) {
            Point[] pointArray = this.getArcPointList(associationArc);
            if (pointArray == null) continue;
            int n = pointArray.length;
            BasicStroke basicStroke = new BasicStroke(8.0f);
            for (int i = 0; i < n - 1; ++i) {
                Line2D.Double double_ = new Line2D.Double(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i + 1].y);
                Shape shape = basicStroke.createStrokedShape(double_);
                if (!shape.contains(point)) continue;
                return associationArc;
            }
        }
        return null;
    }

    void addArcPoint(Point point) {
        AssociationArc associationArc = this.cuMgr.getCurrentArc();
        Point[] pointArray = this.getArcPointList(associationArc);
        int n = this.getArcClickPoint(pointArray, point);
        if (n > -1) {
            associationArc.addPoint(n + 1, point);
        }
    }

    protected int getArcClickPoint(Point[] pointArray, Point point) {
        if (pointArray != null) {
            int n = pointArray.length;
            BasicStroke basicStroke = new BasicStroke(8.0f);
            for (int i = 0; i < n - 1; ++i) {
                Line2D.Double double_ = new Line2D.Double(pointArray[i].x, pointArray[i].y, pointArray[i + 1].x, pointArray[i + 1].y);
                Shape shape = basicStroke.createStrokedShape(double_);
                if (!shape.contains(point)) continue;
                return i;
            }
        }
        return -1;
    }

    void delArcPoint(int n) {
        AssociationArc associationArc = this.cuMgr.getCurrentArc();
        associationArc.delPoint(n);
    }

    protected Point[] getArcPointList(AssociationArc associationArc) {
        ClassNode classNode = this.myModel.getClassData(associationArc.classIdTarget);
        ClassNode classNode2 = this.myModel.getClassData(associationArc.classIdSource);
        Point[] pointArray = null;
        if (associationArc.lineStyle.isSTRAIGHT_LINE()) {
            Point point = Util.calcCrossPoint(classNode.getRectangle(), classNode2.getCenter());
            Point point2 = Util.calcCrossPoint(classNode2.getRectangle(), classNode.getCenter());
            if (point != null && point2 != null) {
                pointArray = new Point[]{point, point2};
            }
        } else if (associationArc.lineStyle.isRIGHT_ANGLE()) {
            pointArray = Util.calcRightAngleVPoint(classNode.getRectangle(), classNode2.getRectangle());
        } else if (associationArc.lineStyle.isRIGHT_ANGLE_H()) {
            pointArray = Util.calcRightAngleHPoint(classNode.getRectangle(), classNode2.getRectangle());
        } else if (associationArc.lineStyle.isFREE_LINE()) {
            pointArray = associationArc.pointList;
        }
        return pointArray;
    }

    ClassNode addNewClass(Point point) {
        int n = this.myModel.getNextClassId();
        ClassModel classModel = new ClassModel(n, point);
        this.myModel.addClass(classModel);
        return classModel;
    }

    AssociationArc addNewArc(ClassNode classNode, ClassNode classNode2, CommonConst.AssocType assocType) {
        int n = this.myModel.getNewAssocId();
        AssociationArc associationArc = new AssociationArc(n, classNode.classId, classNode2.classId, assocType);
        this.myModel.addAssociation(associationArc);
        return associationArc;
    }

    void setCurrPoint(Point point, Point point2) {
        this.startPt = point;
        this.endPt = point2;
        this.myModel.changeModel();
    }

    protected void drawLine(Graphics graphics, Point point, Point point2) {
        this.drawLine(graphics, point.x, point.y, point2.x, point2.y);
    }

    protected void drawLine(Graphics graphics, int n, int n2, int n3, int n4) {
        graphics.drawLine(this.scaledown(n), this.scaledown(n2), this.scaledown(n3), this.scaledown(n4));
    }

    protected void drawRect(Graphics graphics, Rectangle rectangle) {
        this.drawRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    protected void drawRect(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this.scaledown(n);
        n2 = this.scaledown(n2);
        n3 = this.scaledown(n3);
        n4 = this.scaledown(n4);
        graphics.drawRect(n, n2, n3, n4);
    }

    private void fillRect(Graphics graphics, int n, int n2, int n3, int n4) {
        n = this.scaledown(n);
        n2 = this.scaledown(n2);
        n3 = this.scaledown(n3);
        n4 = this.scaledown(n4);
        graphics.fillRect(n, n2, n3, n4);
    }

    protected void drawKnob(Graphics graphics, int n, int n2) {
        n = this.scaledown(n);
        n2 = this.scaledown(n2);
        int n3 = 6;
        graphics.fillRect(n - n3 / 2, n2 - n3 / 2, n3, n3);
    }

    private void fillOval(Graphics graphics, int n, int n2, int n3) {
        n = this.scaledown(n);
        n2 = this.scaledown(n2);
        n3 = this.scaledown(n3);
        graphics.fillOval(n - n3 / 2, n2 - n3 / 2, n3, n3);
    }

    private void drawOval(Graphics graphics, int n, int n2, int n3) {
        n = this.scaledown(n);
        n2 = this.scaledown(n2);
        n3 = this.scaledown(n3);
        graphics.drawOval(n - n3 / 2, n2 - n3 / 2, n3, n3);
    }

    private void fillPolygon(Graphics graphics, int[] nArray) {
        graphics.fillPolygon(new int[]{this.scaledown(nArray[0]), this.scaledown(nArray[1]), this.scaledown(nArray[2])}, new int[]{this.scaledown(nArray[3]), this.scaledown(nArray[4]), this.scaledown(nArray[5])}, 3);
    }

    private void drawPolygon(Graphics graphics, int[] nArray) {
        graphics.drawPolygon(new int[]{this.scaledown(nArray[0]), this.scaledown(nArray[1]), this.scaledown(nArray[2])}, new int[]{this.scaledown(nArray[3]), this.scaledown(nArray[4]), this.scaledown(nArray[5])}, 3);
    }

    protected int scaledown(int n) {
        return n / this.scale;
    }

    protected int multiply(int n) {
        return n * this.scale;
    }

    public void autoAdjust() {
        for (ClassNode commonConst : this.myModel.getAllActiveClassData()) {
            commonConst.autoAdjust();
        }
        for (AssociationArc associationArc : this.myModel.getAllActiveAssociationArc()) {
            if (!associationArc.lineStyle.isFREE_LINE()) continue;
            associationArc.lineStyle = CommonConst.AssocLineType.STRAIGHT_LINE;
            associationArc.pointList = null;
        }
    }

    public void setStartPoint(Point point) {
        point.x = this.multiply(point.x);
        point.y = this.multiply(point.y);
        this.cuMgr.setStartPoint(point);
    }

    public void setEndPoint(Point point) {
        point.x = this.multiply(point.x);
        point.y = this.multiply(point.y);
        this.cuMgr.setEndPoint(point);
    }
}

