/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import ash.gui.core.AshMenu;
import ash.gui.editor.core.AshEditorFrame;
import ash.reverse.uml.UMLTool;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileNameExtensionFilter;
import pbl2011.common.CommonConst;
import pbl2011.common.Util;
import pbl2011.gui.CanvasSizePanel;
import pbl2011.gui.ClassEditorArea;
import pbl2011.gui.State;
import pbl2011.gui.UMLCanvas;
import pbl2011.mvc.Model;

public class ClassEditorFrame
extends AshEditorFrame
implements CommonConst {
    ClassEditorArea editArea;
    JComboBox attributeJcb;
    JComboBox methodJcb;
    JToolBar bar;
    private static final String FILE_OPEN_TOOLTIP = "\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f";
    private static final String FILE_SAVE_TOOLTIP = "\u30d5\u30a1\u30a4\u30eb\u306b\u4fdd\u5b58";
    private static final String EDIT_COMMAND = ClassEditorFrame.actionName();
    private static final String MOD_SELECT = ClassEditorFrame.actionName();
    private static final String MOD_SELECT_TOOLTIP = "\u9078\u629e\u30e2\u30fc\u30c9";
    private static final String ADD_CLASS = ClassEditorFrame.actionName();
    private static final String ADD_CLASS_TOOLTIP = "\u30af\u30e9\u30b9";
    private static final String ADD_ASSOC = ClassEditorFrame.actionName();
    private static final String ADD_ASSOC_TOOLTIP = "\u95a2\u9023";
    private static final String ADD_EXTENDS = ClassEditorFrame.actionName();
    private static final String ADD_EXTENDS_TOOLTIP = "\u6c4e\u5316";
    private static final String ADD_DEPENDS = ClassEditorFrame.actionName();
    private static final String ADD_DEPENDS_TOOLTIP = "\u4f9d\u5b58";
    private static final String OUTPUT_JAVA = ClassEditorFrame.actionName();
    private static final String OUTPUT_IMAGE = ClassEditorFrame.actionName();
    private static final String MOD_GRID = ClassEditorFrame.actionName();
    private static final String MOD_GRID_TOOLTIP = "\u88dc\u52a9\u7dda ON/OFF";
    private static final String MOD_GRIDLINE = ClassEditorFrame.actionName();
    private static final String MOD_GRIDLINE_TOOLTIP = "\u30b0\u30ea\u30c3\u30c9 ON/OFF";
    private static final String VISIBILITY_ATTRIBUTE = ClassEditorFrame.actionName();
    private static final String VISIBILITY_METHOD = ClassEditorFrame.actionName();
    private static final String LABEL_ATTRIBUTE = "\u3000\u5c5e\u6027\uff1a";
    private static final String LABEL_METHOD = "\u3000\u64cd\u4f5c\uff1a";
    private static final String LABEL_ATTRIBUTE_TOOLTIP = "\u5c5e\u6027 ON/OFF";
    private static final String LABEL_METHOD_TOOLTIP = "\u64cd\u4f5c ON/OFF";
    protected static final String AUTO_ADJUST = ClassEditorFrame.actionName();
    protected static final String CANVAS_SIZE = ClassEditorFrame.actionName();
    protected static final String IMPORT_PUBLIC = ClassEditorFrame.actionName();
    protected static final String IMPORT_PROTECTED = ClassEditorFrame.actionName();
    protected static final String IMPORT_PACKAGE = ClassEditorFrame.actionName();
    protected static final String IMPORT_PRIVATE = ClassEditorFrame.actionName();
    protected static final String IMPORT_CLASS = ClassEditorFrame.actionName();
    protected static final String IMPORT_P = ClassEditorFrame.actionName();
    protected static final String IMPORT_PR = ClassEditorFrame.actionName();
    protected static final String IMPORT_PD = ClassEditorFrame.actionName();
    protected static final String IMPORT_PRD = ClassEditorFrame.actionName();
    protected static final String MULTI_INHERIT = ClassEditorFrame.actionName();
    protected Model m;
    protected UMLCanvas mainCanvas;
    protected UMLCanvas subCanvas;
    JFileChooser filechooser = new JFileChooser(".");
    JFileChooser imgChooser = null;
    JFileChooser outputFileChooser = null;

    public static void main(String[] stringArray) {
        ClassEditorFrame classEditorFrame = new ClassEditorFrame("Class Diagrams Editer");
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle rectangle = graphicsEnvironment.getMaximumWindowBounds();
        classEditorFrame.setBounds(rectangle);
        ClassLoader classLoader = Util.getClassLoader(ClassEditorFrame.class);
        classEditorFrame.setIconImage(Toolkit.getDefaultToolkit().createImage(classLoader.getResource("img/ICON.png")));
        classEditorFrame.setVisible(true);
    }

    ClassEditorFrame(String string) {
        super(string);
        this.setSize(1600, 1000);
        this.setDefaultCloseOperation(0);
    }

    protected Component createWorkArea() {
        this.editArea = this.createEditArea();
        this.setEditArea(this.editArea);
        this.createPopupMenu(this.editArea.getEditArea());
        return this.editArea.getEditArea();
    }

    protected ClassEditorArea createEditArea() {
        return new ClassEditorArea(this);
    }

    protected JToolBar createToolBar() {
        this.bar = new JToolBar();
        this.createJButton("CREATE", FILE_OPEN, FILE_OPEN_TOOLTIP);
        this.createJButton("SAVE", FILE_SAVEAS, FILE_SAVE_TOOLTIP);
        State.selectJtg = this.createJToggleButton("SELECT", MOD_SELECT, MOD_SELECT_TOOLTIP, true);
        JToggleButton jToggleButton = this.createJToggleButton(CommonConst.ClassType.CLASS.alias(), ADD_CLASS, ADD_CLASS_TOOLTIP, false);
        JToggleButton jToggleButton2 = this.createJToggleButton(CommonConst.AssocType.ASSOC.alias(), ADD_ASSOC, ADD_ASSOC_TOOLTIP, false);
        JToggleButton jToggleButton3 = this.createJToggleButton(CommonConst.AssocType.EXTENDS.alias(), ADD_EXTENDS, ADD_EXTENDS_TOOLTIP, false);
        JToggleButton jToggleButton4 = this.createJToggleButton(CommonConst.AssocType.DEPENDS.alias(), ADD_DEPENDS, ADD_DEPENDS_TOOLTIP, false);
        this.createJToggleButton("GRID", MOD_GRID, MOD_GRID_TOOLTIP, true);
        this.createJToggleButton("GRIDLINE", MOD_GRIDLINE, MOD_GRIDLINE_TOOLTIP, true);
        State.toggleBtnList = new ArrayList();
        State.toggleBtnList.add(State.selectJtg);
        State.toggleBtnList.add(jToggleButton);
        State.toggleBtnList.add(jToggleButton2);
        State.toggleBtnList.add(jToggleButton3);
        State.toggleBtnList.add(jToggleButton4);
        this.createJLabel(LABEL_ATTRIBUTE, LABEL_ATTRIBUTE_TOOLTIP);
        this.attributeJcb = this.createJComboBox(VISIBILITY_LIST, 3, VISIBILITY_ATTRIBUTE, new Dimension(120, 30));
        this.createJLabel(LABEL_METHOD, LABEL_METHOD_TOOLTIP);
        this.methodJcb = this.createJComboBox(VISIBILITY_LIST, 3, VISIBILITY_METHOD, new Dimension(120, 30));
        return this.bar;
    }

    private JButton createJButton(String string, String string2, String string3) {
        JButton jButton = new JButton(this.makeImageIcon(string));
        jButton.addActionListener((ActionListener)((Object)this));
        jButton.setActionCommand(string2);
        jButton.setToolTipText(string3);
        this.bar.add(jButton);
        return jButton;
    }

    private JToggleButton createJToggleButton(String string, String string2, String string3, boolean bl) {
        JToggleButton jToggleButton = new JToggleButton(this.makeImageIcon(string), bl);
        jToggleButton.addActionListener((ActionListener)((Object)this));
        jToggleButton.setActionCommand(string2);
        jToggleButton.setToolTipText(string3);
        this.bar.add(jToggleButton);
        return jToggleButton;
    }

    private ImageIcon makeImageIcon(String string) {
        ClassLoader classLoader = Util.getClassLoader(this.getClass());
        return new ImageIcon(classLoader.getResource("img/" + string + ".png"));
    }

    private JLabel createJLabel(String string, String string2) {
        JLabel jLabel = new JLabel(string);
        jLabel.setToolTipText(string2);
        this.bar.add(jLabel);
        return jLabel;
    }

    private JComboBox createJComboBox(String[] stringArray, int n, String string, Dimension dimension) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedIndex(n);
        jComboBox.addActionListener((ActionListener)((Object)this));
        jComboBox.setActionCommand(string);
        jComboBox.setMaximumSize(dimension);
        this.bar.add(jComboBox);
        return jComboBox;
    }

    protected JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add((JMenu)new AshEditorFrame.FileMenu((AshEditorFrame)this));
        jMenuBar.add((JMenu)((Object)new EditMenu()));
        jMenuBar.add((JMenu)((Object)new ViewMenu()));
        jMenuBar.add((JMenu)((Object)new SrcMenu()));
        return jMenuBar;
    }

    protected void disposeFrame() {
        if (this.confirmDispose()) {
            this.disposeEditorResource();
            this.dispose();
            System.exit(0);
        }
    }

    protected boolean confirmDispose() {
        this.editArea.setModified(this.m.isModified());
        return super.confirmDispose();
    }

    protected Model getModel() {
        if (this.m == null) {
            this.m = new Model();
        }
        return this.m;
    }

    protected UMLCanvas getMainCanvas() {
        if (this.mainCanvas == null) {
            this.mainCanvas = new UMLCanvas(1, this.getModel());
        }
        return this.mainCanvas;
    }

    protected UMLCanvas getSubCanvas() {
        if (this.subCanvas == null) {
            this.subCanvas = new UMLCanvas(4, this.getModel());
        }
        return this.subCanvas;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (MOD_SELECT.equals(string) || ADD_CLASS.equals(string) || ADD_ASSOC.equals(string) || ADD_EXTENDS.equals(string) || ADD_DEPENDS.equals(string)) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            State.classSelect = false;
            State.arcSelect = null;
            if (string.equals(MOD_SELECT)) {
                jToggleButton.setSelected(true);
            } else if (string.equals(ADD_CLASS)) {
                State.classSelect = jToggleButton.isSelected();
            } else if (string.equals(ADD_ASSOC)) {
                State.arcSelect = jToggleButton.isSelected() ? CommonConst.AssocType.ASSOC : null;
            } else if (string.equals(ADD_EXTENDS)) {
                State.arcSelect = jToggleButton.isSelected() ? CommonConst.AssocType.EXTENDS : null;
            } else if (string.equals(ADD_DEPENDS)) {
                State.arcSelect = jToggleButton.isSelected() ? CommonConst.AssocType.DEPENDS : null;
            }
            this.changeButtonSattus(jToggleButton);
        } else if (MOD_GRID.equals(string)) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            State.gridFlag = jToggleButton.isSelected();
            this.getModel().changeModel();
        } else if (MOD_GRIDLINE.equals(string)) {
            JToggleButton jToggleButton = (JToggleButton)actionEvent.getSource();
            State.gridlineFlag = jToggleButton.isSelected();
            this.getModel().changeModel();
        } else if (VISIBILITY_ATTRIBUTE.equals(string)) {
            State.attributeVisibility = CommonConst.VisibilityType.level(this.attributeJcb.getSelectedItem().toString());
            this.getModel().changeModel();
        } else if (VISIBILITY_METHOD.equals(string)) {
            State.methodVisibility = CommonConst.VisibilityType.level(this.methodJcb.getSelectedItem().toString());
            this.getModel().changeModel();
        } else if (IMPORT_PUBLIC.equals(string)) {
            this.excuteImport("c1");
        } else if (IMPORT_PROTECTED.equals(string)) {
            this.excuteImport("c2");
        } else if (IMPORT_PACKAGE.equals(string)) {
            this.excuteImport("c3");
        } else if (IMPORT_PRIVATE.equals(string)) {
            this.excuteImport("c4");
        } else if (IMPORT_CLASS.equals(string)) {
            this.excuteImport("c");
        } else if (IMPORT_P.equals(string)) {
            this.excuteImport("p");
        } else if (IMPORT_PR.equals(string)) {
            this.excuteImport("pr");
        } else if (IMPORT_PD.equals(string)) {
            this.excuteImport("pd");
        } else if (IMPORT_PRD.equals(string)) {
            this.excuteImport("prd");
        } else if (AUTO_ADJUST.equals(string)) {
            this.mainCanvas.autoAdjust();
            this.getModel().changeModel();
        } else if (CANVAS_SIZE.equals(string)) {
            Rectangle rectangle = CanvasSizePanel.updateSize((JFrame)((Object)this), new Rectangle(State.width, State.height));
            State.width = rectangle.width;
            State.height = rectangle.height;
            this.mainCanvas.initialize();
            this.subCanvas.initialize();
            this.getModel().changeModel();
        } else if (OUTPUT_JAVA.equals(string)) {
            try {
                this.getOutputFileChooser();
                int n = this.outputFileChooser.showDialog((Component)((Object)this), "\u9078\u629e");
                if (n == 0) {
                    File file = this.outputFileChooser.getSelectedFile();
                    this.getModel().outputJavaCode(file);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (OUTPUT_IMAGE.equals(string)) {
            this.getSaveImgChooser();
            if (this.imgChooser.showSaveDialog((Component)((Object)this)) == 0) {
                File file = this.imgChooser.getSelectedFile();
                try {
                    ImageIO.write((RenderedImage)this.mainCanvas.getCanvasImg(), "png", file);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        } else if (MULTI_INHERIT.equals(string)) {
            this.getModel().checkMultiInherit();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    private void getSaveImgChooser() {
        if (this.imgChooser == null) {
            this.imgChooser = new JFileChooser(".");
            this.imgChooser.setSelectedFile(new File("image.png"));
            FileNameExtensionFilter fileNameExtensionFilter = new FileNameExtensionFilter("PNG\u30d5\u30a1\u30a4\u30eb(*.png)", "png");
            this.imgChooser.setFileFilter(fileNameExtensionFilter);
        }
    }

    private void getOutputFileChooser() {
        if (this.outputFileChooser == null) {
            this.outputFileChooser = new JFileChooser(".");
            this.outputFileChooser.setFileSelectionMode(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void excuteImport(String string) {
        PrintStream printStream = null;
        try {
            this.filechooser.setFileSelectionMode(1);
            int n = this.filechooser.showDialog((Component)((Object)this), "\u9078\u629e");
            if (n == 0) {
                File file = File.createTempFile("classde", null);
                file.deleteOnExit();
                printStream = new PrintStream(file);
                UMLTool uMLTool = new UMLTool();
                uMLTool.setFont(State.font);
                uMLTool.setParams(string);
                uMLTool.parse(this.filechooser.getSelectedFile().getCanonicalPath());
                uMLTool.generateUML(printStream);
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                this.getModel().read(bufferedReader, file);
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "\u30bd\u30fc\u30b9\u306e\u53d6\u8fbc\u306b\u5931\u6557\u3057\u307e\u3057\u305f", "\u30a8\u30e9\u30fc", 0);
        }
        finally {
            if (printStream != null) {
                printStream.close();
            }
        }
    }

    private void changeButtonSattus(JToggleButton jToggleButton) {
        for (JToggleButton jToggleButton2 : State.toggleBtnList) {
            if (jToggleButton == jToggleButton2) continue;
            jToggleButton2.setSelected(false);
        }
        this.isSelectState();
    }

    private void isSelectState() {
        for (JToggleButton jToggleButton : State.toggleBtnList) {
            if (!jToggleButton.isSelected()) continue;
            return;
        }
        State.selectJtg.setSelected(true);
    }

    protected class CheckMenu
    extends AshMenu {
        CheckMenu() {
            this.setup("\u8a2d\u8a08\u30c1\u30a7\u30c3\u30af(D)");
            this.setActionListener((ActionListener)((Object)ClassEditorFrame.this));
            this.add("\u591a\u91cd\u7d99\u627f\u30c1\u30a7\u30c3\u30af", MULTI_INHERIT);
        }
    }

    protected class PackgeMenu
    extends AshMenu {
        PackgeMenu() {
            this.setup("\u30d1\u30c3\u30b1\u30fc\u30b8\u56f3\u751f\u6210(P)");
            this.setActionListener((ActionListener)((Object)ClassEditorFrame.this));
            this.add("\u30d1\u30c3\u30b1\u30fc\u30b8\u306e\u307f", IMPORT_P);
            this.add("\u53c2\u7167\u3092\u542b\u3080", IMPORT_PR);
            this.add("\u30af\u30e9\u30b9\u3092\u542b\u3080", IMPORT_PD);
            this.add("\u53c2\u7167\u30fb\u30af\u30e9\u30b9\u3092\u542b\u3080", IMPORT_PRD);
        }
    }

    protected class ClassMenu
    extends AshMenu {
        ClassMenu() {
            this.setup("\u30af\u30e9\u30b9\u56f3\u751f\u6210(C)");
            this.setActionListener((ActionListener)((Object)ClassEditorFrame.this));
            this.add("\u30af\u30e9\u30b9\u306e\u307f", IMPORT_CLASS);
            this.add("public", IMPORT_PUBLIC);
            this.add("protected", IMPORT_PROTECTED);
            this.add("package", IMPORT_PACKAGE);
            this.add("private", IMPORT_PRIVATE);
        }
    }

    protected class SrcMenu
    extends AshMenu {
        SrcMenu() {
            this.setup("\u30c4\u30fc\u30eb(T)");
            this.setActionListener((ActionListener)((Object)ClassEditorFrame.this));
            this.add("\u30bd\u30fc\u30b9\u30b3\u30fc\u30c9\u751f\u6210(J)", OUTPUT_JAVA);
            this.add((JMenuItem)((Object)new ClassMenu()));
            this.add((JMenuItem)((Object)new PackgeMenu()));
            this.add("\u753b\u50cf\u751f\u6210(I)", OUTPUT_IMAGE);
            this.add((JMenuItem)((Object)new CheckMenu()));
        }
    }

    protected class ViewMenu
    extends AshMenu {
        ViewMenu() {
            this.setup("\u8868\u793a(V)");
            this.setActionListener((ActionListener)((Object)ClassEditorFrame.this));
            this.add("\u30d5\u30a9\u30f3\u30c8(F)", VIEW_FONT);
            this.add("\u30b5\u30a4\u30ba\u81ea\u52d5\u8abf\u6574(A)", AUTO_ADJUST);
            this.add("\u63cf\u753b\u30b5\u30a4\u30ba\u5909\u66f4(C)", CANVAS_SIZE);
            this.addSeparator();
            this.add(ClassEditorFrame.this.makeStatusMenuItem());
        }
    }

    protected class EditMenu
    extends AshEditorFrame.EditMenu {
        EditMenu() {
            super((AshEditorFrame)ClassEditorFrame.this);
            this.setup("\u7de8\u96c6(E)");
            this.setActionListener((ActionListener)((Object)ClassEditorFrame.this));
            this.constructBasics();
            this.addSeparator();
            this.add("\u7de8\u96c6\u30b3\u30de\u30f3\u30c9", EDIT_COMMAND);
            this.constructUndo();
        }
    }
}

