/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pbl2011.common.CommonConst;
import pbl2011.gui.AttributeForm;
import pbl2011.gui.ClassDetailController;
import pbl2011.gui.MethodForm;
import pbl2011.gui.ParameterEditor;
import pbl2011.gui.RelationForm;
import pbl2011.model.ClassNode;
import pbl2011.model.PackageManager;
import pbl2011.mvc.Controller;
import pbl2011.mvc.Model;
import pbl2011.mvc.View;

public class ClassDetailEditor
extends View {
    ParameterEditor paramEditor;
    MethodForm methodForm;
    AttributeForm attributeForm;
    RelationForm relationForm;
    private JTabbedPane formTabbed;
    private int tabIndex = 0;
    protected ClassNode clone = null;
    private JTextField text1;
    private JTextField text2;
    private JButton boUp;
    private JButton boDown;
    private JButton boUpdate;
    JComboBox com;
    JButton bo1;
    JButton bo2;

    public ClassDetailEditor(Model model, ParameterEditor parameterEditor) {
        super(model);
        this.methodForm = new MethodForm(model, parameterEditor);
        this.attributeForm = new AttributeForm(model);
        this.relationForm = new RelationForm(model);
        this.paramEditor = parameterEditor;
        this.initialize();
    }

    @Override
    protected void draw() {
        if (this.cuMgr.getCurrentNode() != null && (this.clone == null || this.clone.classId != this.cuMgr.getCurrentNode().classId)) {
            this.clone = this.cuMgr.getCurrentNode().clone();
            this.setClassNode();
        } else if (this.cuMgr.getCurrentNode() == null) {
            this.clone = null;
            this.setClassNode();
        }
        String string = "";
        String string2 = "";
        CommonConst.VisibilityType visibilityType = CommonConst.VisibilityType.PUBLIC;
        if (this.clone != null) {
            string = this.clone.getPackageName();
            string2 = this.clone.className;
            visibilityType = this.clone.visibility;
        }
        this.text1.setText(string);
        this.text2.setText(string2);
        this.com.setSelectedItem(visibilityType.alias());
        this.drawOne();
    }

    private void drawOne() {
        switch (this.tabIndex) {
            case 0: {
                this.methodForm.drawOne();
                break;
            }
            case 1: {
                this.attributeForm.drawOne();
                break;
            }
            case 2: {
                this.relationForm.drawOne();
            }
        }
        this.paramEditor.drawOne();
    }

    private void setClassNode() {
        this.methodForm.setClassNode(this.clone);
        this.attributeForm.setClassNode(this.clone);
        this.relationForm.setClassNode(this.clone);
        this.paramEditor.setClassNode(this.clone);
    }

    private void changeBtnState() {
        this.tabIndex = this.formTabbed.getSelectedIndex();
        switch (this.tabIndex) {
            case 0: {
                this.setBtnEnabled(true);
                this.paramEditor.setShowFlg(true);
                break;
            }
            case 1: {
                this.setBtnEnabled(true);
                this.paramEditor.setShowFlg(false);
                break;
            }
            case 2: {
                this.setBtnEnabled(false);
                this.paramEditor.setShowFlg(false);
            }
        }
        this.drawOne();
    }

    private void setBtnEnabled(boolean bl) {
        this.bo1.setEnabled(bl);
        this.bo2.setEnabled(bl);
        this.boUp.setEnabled(bl);
        this.boDown.setEnabled(bl);
    }

    @Override
    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.removeAll();
        this.add(this.getTopPanel(), "North");
        this.formTabbed = new JTabbedPane();
        this.formTabbed.addTab("\u64cd\u4f5c", new JScrollPane(this.methodForm));
        this.formTabbed.addTab("\u5c5e\u6027", new JScrollPane(this.attributeForm));
        this.formTabbed.addTab("\u95a2\u9023", new JScrollPane(this.relationForm));
        this.formTabbed.setSelectedIndex(this.tabIndex);
        this.formTabbed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ClassDetailEditor.this.changeBtnState();
            }
        });
        this.add((Component)this.formTabbed, "Center");
        this.add(this.getButton(), "South");
        this.changeBtnState();
        this.validate();
        this.draw();
        this.setVisible(true);
    }

    private Component getTopPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(3, 3));
        JLabel jLabel = new JLabel("\u30d1\u30c3\u30b1\u30fc\u30b8\u540d");
        JLabel jLabel2 = new JLabel("\u30af\u30e9\u30b9\u540d");
        JLabel jLabel3 = new JLabel("\u53ef\u8996\u6027");
        this.text1 = new JTextField();
        this.text2 = new JTextField();
        this.com = new JComboBox<String>(VISIBILITY_LIST);
        this.com.setSelectedItem(CommonConst.VisibilityType.PUBLIC.alias());
        this.boUp = new JButton("\u2191");
        this.boUp.setActionCommand("UP");
        this.boUp.addActionListener(this.myController);
        this.boDown = new JButton("\u2193");
        this.boDown.setActionCommand("DOWN");
        this.boDown.addActionListener(this.myController);
        this.boUpdate = new JButton("\u66f4 \u65b0");
        this.boUpdate.setActionCommand("UPDATE");
        this.boUpdate.addActionListener(this.myController);
        jPanel.add(jLabel);
        jPanel.add(this.text1);
        jPanel.add(this.boUp);
        jPanel.add(jLabel2);
        jPanel.add(this.text2);
        jPanel.add(this.boDown);
        jPanel.add(jLabel3);
        jPanel.add(this.com);
        jPanel.add(this.boUpdate);
        return jPanel;
    }

    private Component getButton() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4));
        this.bo1 = new JButton("\u8ffd\u52a0");
        this.bo1.setActionCommand("ADD");
        this.bo1.addActionListener(this.myController);
        this.bo2 = new JButton("\u524a\u9664");
        this.bo2.setActionCommand("DELETE");
        this.bo2.addActionListener(this.myController);
        jPanel.add(this.bo1);
        jPanel.add(this.bo2);
        return jPanel;
    }

    @Override
    protected Controller makeController() {
        return new ClassDetailController(this);
    }

    public void addModel() {
        if (this.tabIndex == 0) {
            this.clone.addMethod();
            this.methodForm.tableModel.addRow(new String[]{"new method", "void", "public"});
        } else if (this.tabIndex == 1) {
            this.clone.addAttribute();
            this.attributeForm.tableModel.addRow(new String[]{"new Attribute", "String", "private"});
        }
    }

    public void deleteModel() {
        if (this.isMethodSelect()) {
            this.clone.delMethod(this.methodForm.getSelectedRow());
            this.methodForm.tableModel.removeRow(this.methodForm.getSelectedRow());
        } else if (this.isAttributeSelect()) {
            this.clone.delAttribute(this.attributeForm.getSelectedRow());
            this.attributeForm.tableModel.removeRow(this.attributeForm.getSelectedRow());
        }
    }

    public void up() {
        if (this.isMethodSelect() && this.methodForm.getSelectedRow() > 0) {
            int n = this.methodForm.getSelectedRow();
            this.clone.changeMethodSeq(n, true);
            this.methodForm.tableModel.moveRow(n, n, n - 1);
            this.methodForm.table.setRowSelectionInterval(n - 1, n - 1);
        } else if (this.isAttributeSelect() && this.attributeForm.getSelectedRow() > 0) {
            int n = this.attributeForm.getSelectedRow();
            this.clone.changeAttributeSeq(n, true);
            this.attributeForm.tableModel.moveRow(n, n, n - 1);
            this.attributeForm.table.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    public void down() {
        if (this.isMethodSelect() && this.methodForm.getSelectedRow() > -1 && this.methodForm.getSelectedRow() < this.methodForm.getRowNum() - 1) {
            int n = this.methodForm.getSelectedRow();
            this.clone.changeMethodSeq(this.methodForm.getSelectedRow(), false);
            this.methodForm.tableModel.moveRow(n, n, n + 1);
            this.methodForm.table.setRowSelectionInterval(n + 1, n + 1);
        } else if (this.isAttributeSelect() && this.attributeForm.getSelectedRow() > -1 && this.attributeForm.getSelectedRow() < this.attributeForm.getRowNum() - 1) {
            int n = this.attributeForm.getSelectedRow();
            this.clone.changeAttributeSeq(this.attributeForm.getSelectedRow(), false);
            this.attributeForm.tableModel.moveRow(n, n, n + 1);
            this.attributeForm.table.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    private boolean isMethodSelect() {
        return this.tabIndex == 0 && this.methodForm.getSelectedRow() > -1;
    }

    private boolean isAttributeSelect() {
        return this.tabIndex == 1 && this.attributeForm.getSelectedRow() > -1;
    }

    public void changeLine() {
        if (this.tabIndex == 0) {
            this.methodForm.changeLine();
        }
    }

    public void updateDetail() {
        this.clone.packageId = PackageManager.add(this.text1.getText());
        this.clone.className = this.text2.getText();
        this.clone.visibility = CommonConst.VisibilityType.aliasOf((String)this.com.getSelectedItem());
        this.myModel.updateClass(this.clone);
    }
}

