/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.common;

public interface CommonConst {
    public static final String FRAME_TITLE = "Class Diagrams Editer";
    public static final int CANVAS_WIDTH = 2048;
    public static final int CANVAS_HEIGHT = 1280;
    public static final String[] VISIBILITY_LIST = new String[]{VisibilityType.PUBLIC.alias(), VisibilityType.PROTECTED.alias(), VisibilityType.PACKAGE.alias(), VisibilityType.PRIVATE.alias()};
    public static final String[] MULTIPLE_LIST = new String[]{"0...*", "*", "1", "n"};
    public static final String[] NAVIGABLE_LIST = new String[]{"true", "false"};
    public static final String CREATE = "CREATE";
    public static final String READ = "READ";
    public static final String SAVE = "SAVE";
    public static final String SELECT = "SELECT";
    public static final String GRID = "GRID";
    public static final String GRIDLINE = "GRIDLINE";
    public static final String ADD = "ADD";
    public static final String DELETE = "DELETE";
    public static final String UP = "UP";
    public static final String DOWN = "DOWN";
    public static final String UPDATE = "UPDATE";
    public static final String PACKAGE_DEFAULT = "(default)";
    public static final Integer PACKAGE_DEFAULT_ID = 90000;
    public static final String PACKAGE_JAVA_LANG = "java.lang";
    public static final Integer PACKAGE_JAVA_LANG_ID = 90001;
    public static final String DELIMITER = "\t";
    public static final String DELIMITER_P = ":";
    public static final String DELIMITER_PACKAGE = ".";
    public static final int GRID_SIZE = 8;
    public static final int ARROW_SIZE_A = 10;
    public static final double ARROW_ANGLE_A = 0.39269908169872414;
    public static final int ARROW_SIZE_E = 12;
    public static final double ARROW_ANGLE_E = 0.5235987755982988;
    public static final int KNOB_SIZE = 6;
    public static final int INNER_SIZE = 4;
    public static final int POINT_SIZE = 8;
    public static final int CLASS_HEIGHT1 = 24;
    public static final int CLASS_HEIGHT2 = 8;
    public static final int CLASS_HEIGHT3 = 8;
    public static final int CLASS_WIDTH = 80;
    public static final int CLASS_COLOR_RED = 204;
    public static final int CLASS_COLOR_GREEN = 255;
    public static final int CLASS_COLOR_BLUE = 255;
    public static final float MAIN_LINE_SIZE = 1.5f;
    public static final float SUB_LINE_SIZE = 1.0f;
    public static final int LINE_SPACE = 2;
    public static final int LINE_MARGINE = 2;
    public static final int SIDE_MARGINE = 8;
    public static final int SYSTESM_USE_MIN_ID = 90000;
    public static final int DEFAULT_RETURN_TYPE_ID = 90000;
    public static final String DEFAULT_RETURN_TYPE_NAME = "void";
    public static final int DEFAULT_DATA_TYPE_ID = 90001;
    public static final String CONSTRACTOR_RETURN_TYPE_NAME = "";
    public static final int CONSTRACTOR_DATA_TYPE_ID = 90009;
    public static final String DEFAULT_DATA_TYPE_NAME = "boolean";
    public static final String SPACE = " ";
    public static final String NULL = "null";
    public static final String SEMI_COLON = ";";

    public static enum AssocLineType {
        STRAIGHT_LINE,
        RIGHT_ANGLE,
        RIGHT_ANGLE_H,
        FREE_LINE;


        public boolean isSTRAIGHT_LINE() {
            return STRAIGHT_LINE == this;
        }

        public boolean isRIGHT_ANGLE() {
            return RIGHT_ANGLE == this;
        }

        public boolean isRIGHT_ANGLE_H() {
            return RIGHT_ANGLE_H == this;
        }

        public boolean isFREE_LINE() {
            return FREE_LINE == this;
        }
    }

    public static enum TreeType {
        ROOT,
        CLASS,
        ATTR,
        METHOD,
        PACKAGE;


        public boolean isCLASS() {
            return CLASS == this;
        }
    }

    public static enum AssocType {
        ASSOC("ASSOC", ""),
        INNER("INNER", ""),
        EXTENDS("EXTENDS", "extends"),
        DEPENDS("DEPENDS", "");

        private String alias;
        private String code;

        private AssocType(String string2, String string3) {
            this.alias = string2;
            this.code = string3;
        }

        public String alias() {
            return this.alias;
        }

        public String code() {
            return this.code;
        }

        public boolean isASSOC() {
            return ASSOC == this;
        }

        public boolean isINNER() {
            return INNER == this;
        }

        public boolean isEXTENDS() {
            return EXTENDS == this;
        }

        public boolean isDEPENDS() {
            return DEPENDS == this;
        }

        public static AssocType aliasOf(String string) {
            for (AssocType assocType : AssocType.values()) {
                if (!assocType.alias.equals(string)) continue;
                return assocType;
            }
            return null;
        }
    }

    public static enum MethodAndAttrType {
        METHOD("METHOD"),
        ABSTRACT_METHOD("@METHOD"),
        ATTRIB("ATTRIB"),
        PARAM("PARAM");

        private String alias;

        private MethodAndAttrType(String string2) {
            this.alias = string2;
        }

        public String alias() {
            return this.alias;
        }
    }

    public static enum ClassType {
        CLASS("CLASS", "class", ""),
        ABSTRACT_CLASS("@CLASS", "abstract class", "@"),
        INTERFACE("INTERFACE", "interface", "!"),
        ENUM("ENUM", "enum", "%");

        private String alias;
        private String code;
        private String mark;

        private ClassType(String string2, String string3, String string4) {
            this.alias = string2;
            this.code = string3;
            this.mark = string4;
        }

        public String alias() {
            return this.alias;
        }

        public String code() {
            return this.code;
        }

        public String mark() {
            return this.mark;
        }

        public static ClassType aliasOf(String string) {
            for (ClassType classType : ClassType.values()) {
                if (!classType.alias.equals(string)) continue;
                return classType;
            }
            return null;
        }

        public boolean isINTERFACE() {
            return INTERFACE == this;
        }
    }

    public static enum PackageType {
        PACKAGE("PACKAGE", "package");

        private String alias;
        private String code;

        private PackageType(String string2, String string3) {
            this.alias = string2;
            this.code = string3;
        }

        public String alias() {
            return this.alias;
        }

        public String code() {
            return this.code;
        }
    }

    public static enum VisibilityType {
        PUBLIC("public", "public", "+", 1),
        PROTECTED("protected", "protected", "#", 2),
        PACKAGE("package", "", "~", 3),
        PRIVATE("private", "private", "-", 4),
        UNDEF("", "", "", 0);

        private String alias;
        private String code;
        private String mark;
        private int level;

        private VisibilityType(String string2, String string3, String string4, int n2) {
            this.alias = string2;
            this.code = string3;
            this.mark = string4;
            this.level = n2;
        }

        public String alias() {
            return this.alias;
        }

        public String code() {
            return this.code;
        }

        public String mark() {
            return this.mark;
        }

        public int level() {
            return this.level;
        }

        public static int level(String string) {
            VisibilityType visibilityType = VisibilityType.aliasOf(string);
            if (visibilityType != null) {
                return visibilityType.level;
            }
            return 0;
        }

        public static VisibilityType aliasOf(String string) {
            for (VisibilityType visibilityType : VisibilityType.values()) {
                if (!visibilityType.alias.equals(string)) continue;
                return visibilityType;
            }
            return UNDEF;
        }
    }
}

