/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pbl2011.common.CommonConst;
import pbl2011.model.ClassNode;
import pbl2011.mvc.Model;

public abstract class DetailForm
extends JComponent
implements CommonConst {
    Model myModel;
    protected JTable table = new JTable();
    protected JTableHeader tableHeader;
    protected ClassNode clone;
    protected DefaultTableModel tableModel;

    public DetailForm(Model model) {
        this.myModel = model;
        this.setLayout(new BorderLayout());
        this.initialize();
    }

    protected void drawOne() {
        Object[][] objectArray = this.getTableData();
        Object[] objectArray2 = this.getTableCol();
        this.tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                DetailForm.this.updateModel(tableModelEvent.getFirstRow());
            }
        });
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(0);
        int n = 0;
        for (String[] stringArray : this.getComboData()) {
            if (stringArray != null) {
                this.createCombo(stringArray, n);
            }
            ++n;
        }
    }

    abstract List<String[]> getComboData();

    private void createCombo(String[] stringArray, int n) {
        JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setEditable(true);
        jComboBox.setBorder(BorderFactory.createEmptyBorder());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(n);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
    }

    abstract void updateModel(int var1);

    abstract String[] getTableCol();

    protected void changeLine() {
    }

    abstract String[][] getTableData();

    protected void initialize() {
        this.removeAll();
        this.drawOne();
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                DetailForm.this.changeLine();
            }
        });
        this.tableHeader = this.table.getTableHeader();
        this.add((Component)this.tableHeader, "North");
        this.add((Component)this.table, "Center");
        this.validate();
    }

    int getSelectedRow() {
        return this.table.getSelectedRow();
    }

    int getRowNum() {
        return this.table.getRowCount();
    }

    protected void setClassNode(ClassNode classNode) {
        this.clone = classNode;
    }
}

