/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Util {
    static final String DATE_FORMAT = "%tY/%<tm/%<td(%<ta) %<tH:%<tM:%<tS";
    public static final String DATE_FMT1 = "yyMMddHHmmss";
    public static final String DATE_FMT2 = "yy/MM/dd HH:mm:ss";
    private static SimpleDateFormat dformat1 = new SimpleDateFormat("yyMMddHHmmss");
    private static SimpleDateFormat dformat2 = new SimpleDateFormat("yy/MM/dd HH:mm:ss");
    static final String DATEPAT = "((\\d+)([/-]\\d+)?([/-]\\d+)?)((\\s+|_)((\\d+)(:\\d+)?(:\\d+)?))?";
    private static Pattern datePat = Pattern.compile("((\\d+)([/-]\\d+)?([/-]\\d+)?)((\\s+|_)((\\d+)(:\\d+)?(:\\d+)?))?");
    static final String TIMEPAT = "(((\\d+):)?(\\d+):)?(\\d+)";
    private static Pattern timePat = Pattern.compile("(((\\d+):)?(\\d+):)?(\\d+)");
    static final String[] timeUnits = new String[]{" sec", " msec", " usec", " nsec"};
    static final String[] sizeUnits = new String[]{" GB", " MB", " KB", " B "};

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static String toString(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        return Util.toString(stringArray, 0, stringArray.length);
    }

    public static String toString(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n2; ++i) {
            if (i > n) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String join(String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            if (object == null) continue;
            stringBuilder.append(object.toString());
        }
        return stringBuilder.toString();
    }

    public static String[] shiftTokens(String[] stringArray) {
        return Util.shiftTokens(stringArray, 1);
    }

    public static String[] shiftTokens(String[] stringArray, int n) {
        if (n == 0) {
            return stringArray;
        }
        int n2 = stringArray.length;
        if (n2 < n) {
            return null;
        }
        return Util.copyTokens(stringArray, n, n2 - n);
    }

    public static String[] addToken(String string, String[] stringArray) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n + 1];
        stringArray2[0] = string;
        System.arraycopy(stringArray, 0, stringArray2, 1, n);
        return stringArray2;
    }

    public static String[] addTokens(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        int n = stringArray.length;
        int n2 = stringArray2.length;
        String[] stringArray3 = new String[n + n2];
        System.arraycopy(stringArray, 0, stringArray3, 0, n);
        System.arraycopy(stringArray2, 0, stringArray3, n, n2);
        return stringArray3;
    }

    public static String[] removeTokens(String[] stringArray, int n, int n2) {
        int n3;
        int n4 = stringArray.length;
        String[] stringArray2 = new String[n4 - n2];
        for (n3 = 0; n3 < n; ++n3) {
            stringArray2[n3] = stringArray[n3];
        }
        for (n3 = n + n2; n3 < n4; ++n3) {
            stringArray2[n3 - n2] = stringArray[n3];
        }
        return stringArray2;
    }

    public static String[] copyTokens(String[] stringArray, int n, int n2) {
        assert (stringArray.length >= n + n2);
        String[] stringArray2 = new String[n2];
        System.arraycopy(stringArray, n, stringArray2, 0, n2);
        return stringArray2;
    }

    public static String[] toArray(List<String> list) {
        return list == null ? null : list.toArray(new String[list.size()]);
    }

    public static String formatDate(String string, Date date) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                stringBuilder.append(String.format("%t" + c, date));
                bl = false;
                continue;
            }
            if (c == '%') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String formatDate(Date date) {
        if (date == null) {
            date = new Date();
        }
        return String.format(DATE_FORMAT, date);
    }

    public static String formatDate() {
        return Util.formatDate(new Date());
    }

    public static String formatDate(String string) {
        return Util.formatDate(string, new Date());
    }

    public static Date parseDate(String string) {
        Date date = Util.parseDate(string, dformat1);
        if (date == null) {
            date = Util.parseDate(string, dformat2);
        }
        if (date == null) {
            date = Util.parseRelaxedDate(string);
        }
        return date;
    }

    private static Date parseRelaxedDate(String string) {
        Matcher matcher = datePat.matcher(string);
        if (!matcher.find()) {
            return null;
        }
        String string2 = matcher.group(1);
        if (string2 == null) {
            string2 = Util.formatDate("%y/%m/%d", new Date());
        } else if (matcher.group(3) == null) {
            string2 = Util.formatDate("%y/%m/", new Date()) + string2;
        } else if (matcher.group(4) == null) {
            string2 = Util.formatDate("%y/", new Date()) + string2;
        }
        String string3 = matcher.group(7);
        if (string3 == null) {
            string3 = "00:00:00";
        } else if (matcher.group(9) == null) {
            string3 = string3 + ":00:00";
        } else if (matcher.group(10) == null) {
            string3 = string3 + ":00";
        }
        return Util.parseDate(string2 + " " + string3, dformat2);
    }

    private static Date parseDate(String string, SimpleDateFormat simpleDateFormat) {
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static int parseTime(String string) {
        Matcher matcher = timePat.matcher(string);
        if (!matcher.find()) {
            return -1;
        }
        int n = Util.parseInt(matcher.group(3));
        int n2 = Util.parseInt(matcher.group(4));
        int n3 = Util.parseInt(matcher.group(5));
        return (n * 60 + n2) * 60 + n3;
    }

    private static int parseInt(String string) {
        return string != null ? Integer.parseInt(string) : 0;
    }

    public static String elapsedTime(long l) {
        return Util.time(System.nanoTime() - l);
    }

    public static String time(long l) {
        int n;
        double d = l;
        for (n = timeUnits.length - 1; 1000.0 <= d && 0 < n; d /= 1000.0, --n) {
        }
        d = (double)((long)(d * 100.0 + 0.5)) / 100.0;
        return "" + d + timeUnits[n];
    }

    public static String fileSize(long l) {
        int n;
        double d = l;
        for (n = sizeUnits.length - 1; 1024.0 <= d && 0 < n; d /= 1024.0, --n) {
        }
        d = (double)((long)(d * 10.0 + 0.5)) / 10.0;
        return "" + d + sizeUnits[n];
    }

    public static String fileSizeKB(long l) {
        return "" + (double)((long)((double)(l * 100L) / 1024.0 + 0.5)) / 100.0 + " KB";
    }
}

