/*
 * Decompiled with CFR 0.152.
 */
package ash.util;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;

public class ImageUtil {
    private static float[] blurKernel = new float[]{0.1f, 0.1f, 0.1f, 0.1f, 0.2f, 0.1f, 0.1f, 0.1f, 0.1f};
    private static ConvolveOp cop = new ConvolveOp(new Kernel(3, 3, blurKernel));

    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2) {
        return ImageUtil.getScaledImage(bufferedImage, n, n2, true);
    }

    public static BufferedImage getScaledImage(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        boolean bl2 = bufferedImage.getTransparency() != 1;
        int n3 = bl2 ? 2 : 1;
        BufferedImage bufferedImage2 = null;
        Graphics2D graphics2D = null;
        if (bl) {
            int n4 = bufferedImage.getWidth();
            int n5 = bufferedImage.getHeight();
            int n6 = n4;
            int n7 = n5;
            do {
                int n8 = n6;
                int n9 = n7;
                if (n6 > n) {
                    n6 = Math.max(n6 / 2, n);
                }
                if (n7 > n2) {
                    n7 = Math.max(n7 / 2, n2);
                }
                if (bufferedImage2 == null || bl2) {
                    bufferedImage2 = new BufferedImage(n6, n7, n3);
                    if (graphics2D != null) {
                        graphics2D.dispose();
                    }
                    graphics2D = bufferedImage2.createGraphics();
                }
                graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                graphics2D.drawImage(bufferedImage, 0, 0, n6, n7, 0, 0, n8, n9, null);
                bufferedImage = bufferedImage2;
            } while (n6 != n || n7 != n2);
            graphics2D.dispose();
            if (n == n4 && n2 == n5) {
                bufferedImage2 = bufferedImage;
            } else {
                bufferedImage2 = new BufferedImage(n, n2, n3);
                graphics2D = bufferedImage2.createGraphics();
                graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
                graphics2D.dispose();
            }
        } else {
            bufferedImage2 = new BufferedImage(n, n2, n3);
            graphics2D = bufferedImage2.createGraphics();
            graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
            graphics2D.dispose();
        }
        return bufferedImage2;
    }

    public static BufferedImage getFramedImage(BufferedImage bufferedImage, Rectangle rectangle, int n, int n2, boolean bl) {
        if (rectangle.width > n || rectangle.height > n2) {
            int n3;
            int n4;
            if (rectangle.width * n2 < rectangle.height * n) {
                n4 = rectangle.width * n2 / rectangle.height;
                n3 = n2;
            } else {
                n3 = rectangle.height * n / rectangle.width;
                n4 = n;
            }
            BufferedImage bufferedImage2 = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return ImageUtil.getScaledImage(bufferedImage2, n4, n3, bl);
        }
        return bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void blurFaceImage(BufferedImage bufferedImage, Rectangle rectangle) {
        if (rectangle == null) {
            return;
        }
        BufferedImage bufferedImage2 = bufferedImage.getSubimage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        BufferedImage bufferedImage3 = new BufferedImage(rectangle.width, rectangle.height, bufferedImage2.getType());
        cop.filter(bufferedImage2, bufferedImage3);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(bufferedImage3.getSubimage(1, 1, rectangle.width - 2, rectangle.height - 2), rectangle.x + 1, rectangle.y + 1, null);
        graphics.dispose();
    }
}

