/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.uml;

import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.uml.ClassNode;
import ash.reverse.uml.Depends;
import ash.reverse.uml.PackageRec;
import ash.reverse.uml.UMLDiagram;
import java.awt.Font;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PkgGenerator
extends UMLDiagram {
    private boolean rflag;
    private boolean dflag;
    private static final String DEFAULTPKG = "*default*";
    private static final String ON_DEMAND = "  *  ";
    private int pkgseq = 0;
    private int refseq = 0;
    private Map<String, PackageRec> packageMap = new LinkedHashMap<String, PackageRec>();
    private Set<String> dependsSet = new HashSet<String>();

    public static void generate(PrintStream printStream, List<FileRecord> list, Font font, boolean bl, boolean bl2) {
        PkgGenerator pkgGenerator = new PkgGenerator();
        pkgGenerator.setFont(font);
        pkgGenerator.setParams(bl, bl2);
        pkgGenerator.generatePkgInfo(list);
        pkgGenerator.generateDiagram(printStream);
    }

    public static void generateRep(PrintStream printStream, List<FileRecord> list) {
        PkgGenerator pkgGenerator = new PkgGenerator();
        pkgGenerator.setParams(true, true);
        pkgGenerator.generatePkgInfo(list);
        pkgGenerator.generateReport(printStream);
    }

    void setParams(boolean bl, boolean bl2) {
        this.rflag = bl;
        this.dflag = bl2;
    }

    void generatePkgInfo(List<FileRecord> list) {
        Object object;
        for (FileRecord object2 : list) {
            object = this.findPackage(object2.pkgname());
            ((PackageRec)object).defined = true;
            for (ObjectRecord objectRecord : object2.members()) {
                this.registerClass((PackageRec)object, (ClassRecord)objectRecord);
            }
        }
        for (FileRecord fileRecord : list) {
            for (String string : fileRecord.onDemandSet()) {
                this.findPackage((String)string).referedOnDemand = true;
            }
            object = this.findPackage(fileRecord.pkgname());
            for (Map.Entry<String, String> entry : fileRecord.typePkgMap().entrySet()) {
                String string = entry.getKey();
                String string2 = entry.getValue();
                ((PackageRec)object).addReference(this.findPackage(string2), string);
            }
        }
        for (PackageRec packageRec : this.packageMap.values()) {
            packageRec.appendRef();
            if (!packageRec.defined && !this.rflag) continue;
            this.generateGraphInfo(packageRec);
        }
    }

    private PackageRec findPackage(String string) {
        PackageRec packageRec;
        if (string == null || string.isEmpty()) {
            string = DEFAULTPKG;
        }
        if ((packageRec = this.packageMap.get(string)) == null) {
            packageRec = new PackageRec(++this.pkgseq, string);
            this.packageMap.put(string, packageRec);
        }
        return packageRec;
    }

    private void registerClass(PackageRec packageRec, ClassRecord classRecord) {
        packageRec.addType(classRecord);
        for (ObjectRecord objectRecord : classRecord.members()) {
            if (!(objectRecord instanceof ClassRecord)) continue;
            this.registerClass(packageRec, (ClassRecord)objectRecord);
        }
    }

    private void generateGraphInfo(PackageRec packageRec) {
        String string;
        Object object;
        String string2 = "CLASS\t" + packageRec.id + "\t" + packageRec.name + "\t" + "null";
        ClassNode classNode = new ClassNode(packageRec.name, string2, 0);
        this.nodeList.add(classNode);
        classNode.setFontMetrics(this.fm);
        for (PackageRec object2 : packageRec.references) {
            if (!object2.defined && !this.rflag || this.dependsSet.contains(object = "" + packageRec.id + "," + object2.id)) continue;
            this.dependsSet.add((String)object);
            string = "ref" + ++this.refseq;
            this.relList.add(new Depends(packageRec.id, object2.id, string));
        }
        if (this.dflag) {
            for (ClassRecord classRecord : packageRec.typeList) {
                object = classRecord.visibility();
                string = classRecord.symbol() + classRecord.qcn();
                String string3 = "ATTRIB\t" + string + "\t" + "Class" + "\t" + (Object)object;
                classNode.addAttribute(string, string3, 0);
            }
            if (packageRec.referedOnDemand) {
                String string4 = "ATTRIB\t  *  \tClass\tnull";
                classNode.addAttribute(ON_DEMAND, string4, 0);
            }
        }
    }

    void generateReport(PrintStream printStream) {
        for (PackageRec packageRec : this.packageMap.values()) {
            printStream.println(packageRec.name);
            for (ClassRecord classRecord : packageRec.typeList) {
                String string = classRecord.visibility().symbol() + " " + classRecord.symbol();
                printStream.println("\t" + string + "\t" + classRecord.qcn());
            }
            if (packageRec.referedOnDemand) {
                printStream.println("\t\t*");
            }
            for (PackageRec packageRec2 : packageRec.references) {
                printStream.println("\t-->\t" + packageRec2.name);
            }
        }
    }
}

