/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.editor.core;

import ash.gui.core.AshGUIFrame;
import ash.gui.core.AshMenu;
import ash.gui.core.AshPopupMenu;
import ash.gui.core.GUIAdapter;
import ash.gui.editor.core.AshEditorArea;
import ash.util.FileUtil;
import ash.util.Log;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.filechooser.FileFilter;

public abstract class AshEditorFrame
extends AshGUIFrame {
    static final String UNTITLED = "Untitled";
    protected static final String FILE_NEW = AshEditorFrame.actionName();
    protected static final String FILE_OPEN = AshEditorFrame.actionName();
    protected static final String FILE_SAVE = AshEditorFrame.actionName();
    protected static final String FILE_SAVEAS = AshEditorFrame.actionName();
    protected static final String FILE_REVERT = AshEditorFrame.actionName();
    protected static final String FILE_CLOSE = AshEditorFrame.actionName();
    protected static final String FILE_EXIT = AshEditorFrame.actionName();
    protected static final String EDIT_UNDO = AshEditorFrame.actionName();
    protected static final String EDIT_REDO = AshEditorFrame.actionName();
    protected static final String EDIT_COPY = AshEditorFrame.actionName();
    protected static final String EDIT_CUT = AshEditorFrame.actionName();
    protected static final String EDIT_PASTE = AshEditorFrame.actionName();
    protected static final String EDIT_DELETE = AshEditorFrame.actionName();
    protected static final String EDIT_SELALL = AshEditorFrame.actionName();
    protected static final String EDIT_SEARCH = AshEditorFrame.actionName();
    protected static final String EDIT_NEXT = AshEditorFrame.actionName();
    protected static final String EDIT_PREV = AshEditorFrame.actionName();
    protected static final String EDIT_REGEX = AshEditorFrame.actionName();
    protected static final String EDIT_REPLACE = AshEditorFrame.actionName();
    protected static final String EDIT_GOTO = AshEditorFrame.actionName();
    protected static final String VIEW_FONT = AshEditorFrame.actionName();
    protected static final String VIEW_STATUS = AshEditorFrame.actionName();
    private AshEditorArea editArea;
    private JTabbedPane tabbedPane;
    private AshScrollPane scrollPane;
    static int scrollBarPolicy = 30;
    private AshFileFilter fileFilter = null;

    public AshEditorFrame(String string) {
        super(string);
        this.showUntitled();
        this.showCursorPos(1, 0);
    }

    private void showUntitled() {
        this.setMessage(UNTITLED);
    }

    private void showFileName(String string) {
        this.setMessage(FileUtil.normalPath(string));
    }

    protected AshPopupMenu createPopupMenu(Component component) {
        return new EditAreaPopup(component);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(FILE_NEW)) {
            this.newFile();
        } else if (string.equals(FILE_OPEN)) {
            this.openFile();
        } else if (string.equals(FILE_SAVE)) {
            this.saveFile(this.editArea);
        } else if (string.equals(FILE_SAVEAS)) {
            this.saveAsFile(this.editArea);
        } else if (string.equals(FILE_REVERT)) {
            this.revertFile(this.editArea);
        } else if (string.equals(FILE_CLOSE)) {
            this.closeFile();
        } else if (string.equals(FILE_EXIT)) {
            this.disposeFrame();
        } else if (string.equals(EDIT_UNDO)) {
            this.editArea.undo();
        } else if (string.equals(EDIT_REDO)) {
            this.editArea.redo();
        } else if (string.equals(EDIT_COPY)) {
            this.editArea.copy();
        } else if (string.equals(EDIT_CUT)) {
            this.editArea.cut();
        } else if (string.equals(EDIT_PASTE)) {
            this.editArea.paste();
        } else if (string.equals(EDIT_DELETE)) {
            this.editArea.delete();
        } else if (string.equals(EDIT_GOTO)) {
            this.editArea.gotoLine();
        } else if (string.equals(EDIT_SELALL)) {
            this.editArea.selectAll();
        } else if (string.equals(VIEW_FONT)) {
            this.editArea.setFont();
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    protected abstract AshEditorArea createEditArea();

    protected void setEditArea(AshEditorArea ashEditorArea) {
        this.editArea = ashEditorArea;
    }

    private boolean isMultiEditor() {
        return this.tabbedPane != null;
    }

    private int findTabIndex(AshEditorArea ashEditorArea) {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            AshScrollPane ashScrollPane = (AshScrollPane)this.tabbedPane.getComponentAt(i);
            if (ashScrollPane.editArea != ashEditorArea) continue;
            return i;
        }
        return -1;
    }

    private String getTabTitle(AshEditorArea ashEditorArea) {
        if (this.tabbedPane == null) {
            return UNTITLED;
        }
        return this.tabbedPane.getTitleAt(this.findTabIndex(ashEditorArea));
    }

    private void setTabTitle(AshEditorArea ashEditorArea, String string) {
        this.tabbedPane.setTitleAt(this.findTabIndex(ashEditorArea), string);
    }

    public final int getViewHeight() {
        return this.scrollPane.getHeight();
    }

    public final int getTopPixel() {
        return this.scrollPane.getVScrollBar().getValue();
    }

    public final void setTopPixel(int n) {
        this.scrollPane.getVScrollBar().setValue(n);
    }

    void notifyUpdate(AshEditorArea ashEditorArea, String string) {
        if (this.isMultiEditor()) {
            String string2;
            Log.debug(55, string);
            int n = this.findTabIndex(ashEditorArea);
            if (ashEditorArea != this.editArea) {
                this.resetEditArea(ashEditorArea);
                this.tabbedPane.setSelectedIndex(n);
                this.scrollPane = (AshScrollPane)this.tabbedPane.getComponentAt(n);
            }
            if (ashEditorArea.isModified() && !(string2 = this.getTabTitle(ashEditorArea)).endsWith("*")) {
                this.setTabTitle(ashEditorArea, string2 + "*");
            }
        } else {
            super.setTitle(string);
        }
    }

    @Override
    protected Component createWorkArea() {
        return this.createEditor();
    }

    private AshScrollPane createEditor() {
        Log.debug(-55, "==> createEditor(): ");
        this.editArea = this.createEditArea();
        this.createPopupMenu(this.editArea.getEditArea());
        this.scrollPane = new AshScrollPane(this.editArea);
        return this.scrollPane;
    }

    protected Component createMultiWorkArea() {
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.addChangeListener(new TabChangeListener());
        this.addEditorTab("*scratch*");
        return this.tabbedPane;
    }

    private void addEditorTab(String string) {
        AshScrollPane ashScrollPane = this.createEditor();
        this.tabbedPane.addTab(string, ashScrollPane);
        this.tabbedPane.setSelectedComponent(ashScrollPane);
    }

    private void resetEditArea(AshEditorArea ashEditorArea) {
        this.setEditArea(ashEditorArea);
        File file = ashEditorArea.getCurrentFile();
        if (file != null) {
            this.showFileName(file.getPath());
        }
    }

    public void findAndOpenFile(File file) {
        AshScrollPane ashScrollPane = this.findEditorTab(file);
        if (ashScrollPane == null) {
            Log.debug(55, "open: " + file.getPath());
            this.addEditorTab(file.getName());
            this.openFileSub(file);
        } else {
            Log.debug(55, "already opened: " + file.getPath());
            this.resetEditArea(ashScrollPane.editArea);
            this.tabbedPane.setSelectedComponent(ashScrollPane);
            if (!this.editArea.isModified() || this.confirmCancel(file)) {
                this.openFileSub(file);
                this.updateTab(this.editArea);
            }
        }
    }

    private AshScrollPane findEditorTab(File file) {
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            AshScrollPane ashScrollPane = (AshScrollPane)this.tabbedPane.getComponentAt(i);
            File file2 = ashScrollPane.editArea.getCurrentFile();
            if (!file.equals(file2)) continue;
            return ashScrollPane;
        }
        return null;
    }

    @Override
    protected String cursorPosDisplay(int n, int n2) {
        int n3 = this.editArea.getLineCount();
        int n4 = n3 == 0 ? 0 : (n * 100 + n3 / 2) / n3;
        return "--L" + n + "--C" + n2 + "--" + n4 + "%--";
    }

    public void newFile() {
        if (this.isMultiEditor()) {
            this.addEditorTab(UNTITLED);
            this.editArea.newFile();
            this.showCursorPos(1, 0);
        } else if (this.confirmWriteBack(this.editArea)) {
            this.editArea.newFile();
            this.showUntitled();
            this.showCursorPos(1, 0);
        }
    }

    private void openFile() {
        JFileChooser jFileChooser;
        int n;
        if ((this.isMultiEditor() || this.confirmWriteBack(this.editArea)) && (n = (jFileChooser = this.getFileChooser(this.editArea)).showOpenDialog(this.getContentPane())) == 0) {
            this.openFile(jFileChooser.getSelectedFile());
        }
    }

    private boolean saveFile(AshEditorArea ashEditorArea) {
        if (ashEditorArea.getCurrentFile() == null) {
            return this.saveAsFile(ashEditorArea);
        }
        if (ashEditorArea.isEditable()) {
            ashEditorArea.writeFile();
            this.updateTab(ashEditorArea);
            return true;
        }
        this.showMessage("\u8aad\u307f\u8fbc\u307f\u5c02\u7528\u3067\u3059\u3002\u4fdd\u5b58\u3067\u304d\u307e\u305b\u3093\u3002");
        return false;
    }

    private boolean saveAsFile(AshEditorArea ashEditorArea) {
        block1: {
            File file;
            JFileChooser jFileChooser = this.getFileChooser(ashEditorArea);
            do {
                int n;
                if ((n = jFileChooser.showSaveDialog(this.getContentPane())) == 0) continue;
                return false;
            } while ((file = jFileChooser.getSelectedFile()).exists() && !this.canOverride(file));
            if (!ashEditorArea.writeFile(file)) break block1;
            this.showFileName(file.getPath());
            this.updateTab(ashEditorArea);
        }
        return true;
    }

    private void revertFile(AshEditorArea ashEditorArea) {
        File file;
        if (ashEditorArea.isModified() && (file = ashEditorArea.getCurrentFile()) != null && this.confirmCancel(file)) {
            this.openFileSub(file);
            this.updateTab(ashEditorArea);
        }
    }

    private boolean canOverride(File file) {
        int n = this.showConfirm("\u4e0b\u8a18\u30d5\u30a1\u30a4\u30eb\u306f\u65e2\u306b\u5b58\u5728\u3057\u3066\u3044\u307e\u3059\u3002\u4e0a\u66f8\u304d\u3057\u3066\u826f\u3044\u3067\u3059\u304b?\n" + this.findFileName(file), "\u4e0a\u66f8\u304d\u4fdd\u5b58\u306e\u78ba\u8a8d");
        return n == 0;
    }

    private boolean confirmCancel(File file) {
        int n = this.showConfirm("\u4e0b\u8a18\u30d5\u30a1\u30a4\u30eb\u306e\u30d0\u30c3\u30d5\u30a1\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5909\u66f4\u3092\u53d6\u308a\u6d88\u3057\u3066\u826f\u3044\u3067\u3059\u304b?\n" + this.findFileName(file), "\u5909\u66f4\u53d6\u6d88\u3057\u306e\u78ba\u8a8d");
        return n == 0;
    }

    private String findFileName(File file) {
        return file != null ? FileUtil.getPath(file) : "****";
    }

    private void updateTab(AshEditorArea ashEditorArea) {
        File file = ashEditorArea.getCurrentFile();
        if (this.isMultiEditor()) {
            this.setTabTitle(ashEditorArea, file.getName());
        }
    }

    @Override
    protected void disposeFrame() {
        if (this.confirmDispose()) {
            Log.debug(1, "==> AshEditorFrame#disposeFrame()");
            this.disposeEditorResource();
            this.dispose();
        }
    }

    @Override
    protected boolean confirmDispose() {
        if (!this.isMultiEditor()) {
            return this.confirmWriteBack(this.editArea);
        }
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            AshScrollPane ashScrollPane = (AshScrollPane)this.tabbedPane.getComponentAt(i);
            if (this.confirmWriteBack(ashScrollPane.editArea)) continue;
            return false;
        }
        return true;
    }

    protected boolean confirmWriteBack(AshEditorArea ashEditorArea) {
        if (ashEditorArea.isModified()) {
            File file = ashEditorArea.getCurrentFile();
            String string = file != null ? this.findFileName(file) : this.getTabTitle(ashEditorArea);
            int n = this.showConfirm("\u4e0b\u8a18\u306e\u30d0\u30c3\u30d5\u30a1\u306f\u5909\u66f4\u3055\u308c\u3066\u3044\u307e\u3059\u3002\u5909\u66f4\u3092\u4fdd\u5b58\u3057\u307e\u3059\u304b?\n" + string);
            switch (n) {
                case 0: {
                    return this.saveFile(ashEditorArea);
                }
                case 1: {
                    return true;
                }
                case 2: {
                    return false;
                }
            }
        }
        return true;
    }

    protected void disposeEditorResource() {
    }

    private JFileChooser getFileChooser(AshEditorArea ashEditorArea) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(ashEditorArea.getCurrentDirectory());
        File file = ashEditorArea.getCurrentFile();
        if (file == null) {
            file = new File(this.getTabTitle(ashEditorArea));
        }
        jFileChooser.setSelectedFile(file);
        if (this.fileFilter != null) {
            jFileChooser.setFileFilter(this.fileFilter);
        }
        return jFileChooser;
    }

    public void setFileFilter(String string) {
        this.fileFilter = new AshFileFilter();
        this.fileFilter.description = string;
    }

    public void setFileFilter(String string, String[] stringArray) {
        this.setFileFilter(string);
        for (String string2 : stringArray) {
            this.fileFilter.addSuffix(string2);
        }
    }

    public void addFileFilterSuffix(String string) {
        if (this.fileFilter == null) {
            this.fileFilter = new AshFileFilter();
        }
        this.fileFilter.addSuffix(string);
    }

    public void openFile(String string) {
        this.openFile(GUIAdapter.findFile(string));
    }

    protected void closeFile() {
        if (this.isMultiEditor()) {
            if (this.tabbedPane.getSelectedIndex() > 0 && this.confirmWriteBack(this.editArea)) {
                this.tabbedPane.remove(this.scrollPane);
            }
        } else {
            this.disposeFrame();
        }
    }

    public void openFile(File file) {
        if (this.isMultiEditor()) {
            this.findAndOpenFile(file);
        } else {
            this.openFileSub(file);
        }
    }

    private void openFileSub(File file) {
        this.editArea.openFile(file);
        this.showCursorPos(1, 0);
        this.showFileName(file.getPath());
    }

    public void setTextData(String string, String string2) {
        if (string == null) {
            string = UNTITLED;
        }
        if (this.isMultiEditor()) {
            this.addEditorTab(string);
        }
        Log.debug(-55, "==> setTextData: " + string2);
        this.editArea.setTextData(string2);
    }

    public void setFileName(String string) {
        this.showFileName(string);
        this.editArea.setFileName(string);
        if (this.isMultiEditor()) {
            this.setTabTitle(this.editArea, string);
        }
    }

    public void setEditable(boolean bl) {
        this.editArea.setEditable(bl);
    }

    public void setEditFont(Font font) {
        this.editArea.setFont(font);
    }

    public void setRowColumn(int n, int n2) {
        this.editArea.setRowColumn(n, n2);
    }

    public void showLine(int n) {
        this.editArea.showLine(n - 1);
    }

    private static class AshFileFilter
    extends FileFilter {
        private List<String> suffixArray = new ArrayList<String>();
        String description = "Ash file";

        private AshFileFilter() {
        }

        void addSuffix(String string) {
            this.suffixArray.add(string);
        }

        @Override
        public boolean accept(File file) {
            if (this.suffixArray == null) {
                return true;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            int n = string.lastIndexOf(46);
            String string2 = n < 0 ? "" : string.substring(n + 1);
            for (String string3 : this.suffixArray) {
                if (!string2.equalsIgnoreCase(string3)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            AshEditorFrame.this.scrollPane = (AshScrollPane)AshEditorFrame.this.tabbedPane.getSelectedComponent();
            AshEditorFrame.this.resetEditArea(((AshEditorFrame)AshEditorFrame.this).scrollPane.editArea);
        }
    }

    private static class AshScrollPane
    extends JScrollPane {
        AshEditorArea editArea;

        AshScrollPane(AshEditorArea ashEditorArea) {
            this.editArea = ashEditorArea;
            this.setViewportView(ashEditorArea.getEditArea());
            this.setEnabled(true);
            this.setHorizontalScrollBarPolicy(scrollBarPolicy);
        }

        JScrollBar getVScrollBar() {
            return this.verticalScrollBar;
        }
    }

    protected class EditAreaPopup
    extends AshPopupMenu {
        private JMenuItem cut;
        private JMenuItem copy;
        private JMenuItem delete;
        private JMenuItem selAll;

        protected EditAreaPopup(Component component) {
            super(component);
        }

        @Override
        protected void construct() {
            this.setActionListener(AshEditorFrame.this);
            this.cut = this.add("\u5207\u308a\u53d6\u308a", EDIT_CUT);
            this.copy = this.add("\u30b3\u30d4\u30fc", EDIT_COPY);
            this.add("\u8cbc\u308a\u4ed8\u3051", EDIT_PASTE);
            this.delete = this.add("\u524a\u9664", EDIT_DELETE);
            this.addSeparator();
            this.selAll = this.add("\u3059\u3079\u3066\u9078\u629e", EDIT_SELALL);
            this.addSeparator();
            this.add("\u9589\u3058\u308b", FILE_CLOSE);
        }

        @Override
        protected void popupSelected(MouseEvent mouseEvent) {
            boolean bl = AshEditorFrame.this.editArea.isSelected();
            this.cut.setEnabled(bl);
            this.copy.setEnabled(bl);
            this.delete.setEnabled(bl);
            this.selAll.setEnabled(AshEditorFrame.this.editArea.isSelectable());
        }
    }

    protected class EditMenu
    extends AshMenu {
        private JMenuItem cut;
        private JMenuItem copy;
        private JMenuItem delete;
        private JMenuItem selAll;

        protected EditMenu() {
        }

        protected void constructUndo() {
            this.add("\u5143\u306b\u623b\u3059(U)", EDIT_UNDO, 90);
            this.add("\u3084\u308a\u76f4\u3057(R)", EDIT_REDO, 89);
        }

        protected void constructBasics() {
            this.cut = this.add("\u5207\u308a\u53d6\u308a(T)", EDIT_CUT, 88);
            this.copy = this.add("\u30b3\u30d4\u30fc(C)", EDIT_COPY, 67);
            this.add("\u8cbc\u308a\u4ed8\u3051(P)", EDIT_PASTE, 86);
            this.delete = this.add("\u524a\u9664(D)", EDIT_DELETE, 127, 0);
            this.selAll = this.add("\u3059\u3079\u3066\u9078\u629e(A)", EDIT_SELALL, 65);
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            if (this.cut == null) {
                return;
            }
            boolean bl = AshEditorFrame.this.editArea.isSelected();
            this.cut.setEnabled(bl);
            this.copy.setEnabled(bl);
            this.delete.setEnabled(bl);
            this.selAll.setEnabled(AshEditorFrame.this.editArea.isSelectable());
        }
    }

    protected class FileMenu
    extends AshMenu {
        public FileMenu() {
            this.construct();
        }

        protected void construct() {
            this.setup("\u30d5\u30a1\u30a4\u30eb(F)");
            this.setActionListener(AshEditorFrame.this);
            this.add("\u65b0\u898f(N)", FILE_NEW, 78);
            this.add("\u958b\u304f(O)", FILE_OPEN, 79);
            this.add("\u4fdd\u5b58(S)", FILE_SAVE, 83);
            this.add("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58(A)", FILE_SAVEAS);
            this.add("\u5fa9\u5e30(R)", FILE_REVERT);
            this.addSeparator();
            this.add("\u7d42\u4e86(X)", FILE_EXIT, 87);
        }
    }
}

