/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pbl2011.common.CommonConst;
import pbl2011.gui.OriginalTreeNode;
import pbl2011.gui.TreeCellRenderer;
import pbl2011.model.Attribute;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;
import pbl2011.model.PackageManager;
import pbl2011.mvc.Controller;
import pbl2011.mvc.Model;
import pbl2011.mvc.View;

public class TreeInfo
extends View {
    protected JTree tree;
    DefaultMutableTreeNode rootNode;
    protected DefaultTreeModel treeModel;
    protected ArrayList<ClassNode> currClassNodeList;
    OriginalTreeNode selectNode = null;
    ClassNode currNodeCopy = null;
    OriginalTreeNode selectPackage = null;

    TreeInfo(Model model) {
        super(model);
        this.setLayout(new GridLayout());
        this.initialize();
    }

    @Override
    protected void draw() {
        ArrayList<ClassNode> arrayList = this.myModel.getAllActiveClassData();
        if (!this.needDraw(arrayList)) {
            return;
        }
        this.changeTreeModel(arrayList);
        this.changeSelectionPath();
    }

    private boolean needDraw(ArrayList<ClassNode> arrayList) {
        if (arrayList.equals(this.currClassNodeList)) {
            ClassNode classNode = this.cuMgr.getCurrentNode();
            if (classNode == null) {
                if (this.currNodeCopy == null) {
                    return false;
                }
                this.currNodeCopy = null;
                return true;
            }
            return !classNode.equals(this.currNodeCopy);
        }
        this.currClassNodeList = arrayList;
        return true;
    }

    private void changeTreeModel(ArrayList<ClassNode> arrayList) {
        HashMap<Integer, DefaultMutableTreeNode> hashMap = new HashMap<Integer, DefaultMutableTreeNode>();
        this.rootNode.removeAllChildren();
        for (ClassNode classNode : arrayList) {
            OriginalTreeNode originalTreeNode;
            if (classNode.isBuiltInClass) continue;
            OriginalTreeNode originalTreeNode2 = new OriginalTreeNode(classNode.className, classNode.classId, CommonConst.TreeType.CLASS);
            DefaultMutableTreeNode defaultMutableTreeNode = this.getPackageNode(this.rootNode, hashMap, classNode.packageId);
            defaultMutableTreeNode.add(originalTreeNode2);
            this.checkSelected(classNode.className, originalTreeNode2);
            for (Attribute attribute : classNode.attributeList) {
                originalTreeNode = new OriginalTreeNode(attribute.attributeName, classNode.classId, CommonConst.TreeType.ATTR);
                originalTreeNode2.add(originalTreeNode);
                this.checkSelected(attribute.attributeName, originalTreeNode2);
            }
            for (Method method : classNode.methodList) {
                originalTreeNode = new OriginalTreeNode(method.methodName, classNode.classId, CommonConst.TreeType.METHOD);
                originalTreeNode2.add(originalTreeNode);
                this.checkSelected(method.methodName, originalTreeNode2);
            }
        }
        this.treeModel.reload();
    }

    private void changeSelectionPath() {
        ArrayList<ClassNode> arrayList = this.cuMgr.getCurrentNodeList();
        ClassNode classNode = this.cuMgr.getCurrentNode();
        if (arrayList != null && arrayList.size() == 1 && classNode != null) {
            OriginalTreeNode originalTreeNode;
            if (this.selectNode != null) {
                if (this.selectNode.getClassId() == classNode.classId) {
                    return;
                }
                this.selectPackage = (OriginalTreeNode)this.selectNode.getParent();
            }
            if ((originalTreeNode = this.trySelectTreeNode(classNode)) != null && originalTreeNode.getPath() != null) {
                OriginalTreeNode originalTreeNode2 = (OriginalTreeNode)originalTreeNode.getParent();
                this.expandSelectPackage(originalTreeNode2);
                TreePath treePath = new TreePath(originalTreeNode.getPath());
                this.tree.setSelectionPath(treePath);
                this.selectNode = originalTreeNode;
                this.currNodeCopy = classNode.clone();
            }
        } else {
            this.tree.clearSelection();
            this.collapseAll();
        }
    }

    private OriginalTreeNode trySelectTreeNode(ClassNode classNode) {
        if (classNode == null) {
            return null;
        }
        OriginalTreeNode originalTreeNode = null;
        Enumeration<TreeNode> enumeration = this.rootNode.breadthFirstEnumeration();
        while (enumeration.hasMoreElements()) {
            originalTreeNode = (OriginalTreeNode)enumeration.nextElement();
            if (!originalTreeNode.getKind().isCLASS() || classNode.classId != originalTreeNode.getClassId()) continue;
            return originalTreeNode;
        }
        return null;
    }

    private void collapseAll() {
        for (int i = this.tree.getRowCount() - 1; i >= 0; --i) {
            this.tree.collapseRow(i);
        }
    }

    private void expandSelectPackage(OriginalTreeNode originalTreeNode) {
        if (this.selectPackage != originalTreeNode) {
            this.collapseAll();
            this.tree.expandPath(new TreePath(originalTreeNode.getPath()));
        }
    }

    protected DefaultMutableTreeNode getPackageNode(DefaultMutableTreeNode defaultMutableTreeNode, Map<Integer, DefaultMutableTreeNode> map, int n) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = map.get(n);
        if (defaultMutableTreeNode2 == null) {
            String string = PackageManager.getPackageName(n);
            defaultMutableTreeNode2 = new OriginalTreeNode(string, n, CommonConst.TreeType.PACKAGE);
            map.put(n, defaultMutableTreeNode2);
        }
        defaultMutableTreeNode.add(defaultMutableTreeNode2);
        return defaultMutableTreeNode2;
    }

    protected void checkSelected(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (this.selectNode == null) {
            return;
        }
        if (string.equals((String)this.selectNode.getUserObject())) {
            this.selectNode = (OriginalTreeNode)defaultMutableTreeNode;
        }
    }

    protected void checkSelectedNode() {
        if (this.selectNode == null || this.cuMgr.getCurrentNode() == null) {
            return;
        }
        if (this.selectNode.getClassId() != this.cuMgr.getCurrentNode().classId) {
            this.selectNode = null;
        }
    }

    @Override
    protected void initialize() {
        this.rootNode = new OriginalTreeNode("", -1, CommonConst.TreeType.ROOT);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setCellRenderer(new TreeCellRenderer());
        this.tree.setRootVisible(false);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                TreeInfo.this.selectNode = (OriginalTreeNode)TreeInfo.this.tree.getLastSelectedPathComponent();
                if (TreeInfo.this.selectNode == null || !TreeInfo.this.selectNode.getKind().isCLASS()) {
                    return;
                }
                ClassNode classNode = TreeInfo.this.myModel.getClassData(TreeInfo.this.selectNode.getClassId());
                if (classNode == null || classNode == TreeInfo.this.cuMgr.getCurrentNode()) {
                    return;
                }
                TreeInfo.this.cuMgr.setCurrentNode(classNode);
                TreeInfo.this.currNodeCopy = classNode.clone();
            }
        });
        this.add(this.tree);
        this.validate();
        this.draw();
    }

    @Override
    protected Controller makeController() {
        return null;
    }
}

