/*
 * Decompiled with CFR 0.152.
 */
package pbl2011.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import pbl2011.common.CommonConst;
import pbl2011.gui.ParameterController;
import pbl2011.model.ClassNode;
import pbl2011.model.Method;
import pbl2011.model.Parameter;
import pbl2011.mvc.Model;

public class ParameterEditor
extends JComponent
implements CommonConst {
    private Model myModel;
    protected ParameterController myController;
    private JTextField methodText;
    private JTextField visiText;
    private JTextField returnText;
    private JButton boUp;
    private JButton boDown;
    private JTable table;
    private JTableHeader tableHeader;
    private int methodNo;
    private boolean showFlg = true;
    private ClassNode clone;
    DefaultTableModel tableModel;
    JButton bo1;
    JButton bo2;

    public ParameterEditor(Model model) {
        this.myModel = model;
        this.myController = this.makeController();
        this.initialize();
    }

    protected void drawOne() {
        JPanel jPanel = new JPanel();
        this.removeAll();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.getTopPanel(), "North");
        jPanel.add((Component)new JScrollPane(this.getParamTable()), "Center");
        jPanel.add(this.getButton(), "South");
        JComboBox<String> jComboBox = new JComboBox<String>(this.myModel.getTypeList());
        jComboBox.setEditable(true);
        jComboBox.setBorder(BorderFactory.createEmptyBorder());
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(1);
        tableColumn.setCellEditor(new DefaultCellEditor(jComboBox));
        this.add(jPanel);
        this.setBtnEnabled();
        this.validate();
    }

    private Component getParamTable() {
        Object[][] objectArray;
        Object[] objectArray2;
        JPanel jPanel = new JPanel();
        if (this.isMethodSelect()) {
            objectArray2 = this.clone.methodList.get((int)this.methodNo).parameterList;
            objectArray = new String[objectArray2.size()][3];
            int n = 0;
            for (Parameter parameter : this.clone.methodList.get((int)this.methodNo).parameterList) {
                objectArray[n][0] = parameter.parameterName;
                objectArray[n][1] = this.myModel.getTypeNameByTypeId(parameter.dataTypeId);
                ++n;
            }
        } else {
            objectArray = new String[0][2];
        }
        objectArray2 = new String[]{"\u5f15\u6570\u540d", "\u5f15\u6570\u578b"};
        this.removeAll();
        this.tableModel = new DefaultTableModel(objectArray, objectArray2);
        this.tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
                int n = ParameterEditor.this.table.getSelectedRow();
                if (n > -1) {
                    ParameterEditor.this.clone.changeParameter(ParameterEditor.this.methodNo, n, (String)ParameterEditor.this.table.getValueAt(n, 0), ParameterEditor.this.myModel.getTypeIdByTypeName((String)ParameterEditor.this.table.getValueAt(n, 1)));
                }
            }
        });
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        this.tableHeader = this.table.getTableHeader();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.tableHeader, "North");
        jPanel.add((Component)this.table, "Center");
        this.validate();
        return jPanel;
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        this.drawOne();
        this.setVisible(true);
    }

    private Component getTopPanel() {
        Object object;
        String string = "";
        String string2 = "";
        CommonConst.VisibilityType visibilityType = CommonConst.VisibilityType.UNDEF;
        if (this.isMethodSelect()) {
            object = this.clone.methodList.get(this.methodNo);
            string = ((Method)object).methodName;
            string2 = this.myModel.getTypeNameByTypeId(((Method)object).dataTypeId);
            visibilityType = ((Method)object).visibility;
        }
        object = new JPanel();
        ((Container)object).setLayout(new GridLayout(3, 3));
        JLabel jLabel = new JLabel("\u540d\u524d");
        JLabel jLabel2 = new JLabel("\u8fd4\u308a\u5024");
        JLabel jLabel3 = new JLabel("\u53ef\u8996\u6027");
        this.methodText = new JTextField(string);
        this.methodText.setEditable(false);
        this.returnText = new JTextField(string2);
        this.returnText.setEditable(false);
        this.visiText = new JTextField(visibilityType.alias());
        this.visiText.setEditable(false);
        this.boUp = new JButton("\u2191");
        this.boUp.setActionCommand("UP");
        this.boUp.addActionListener(this.myController);
        this.boDown = new JButton("\u2193");
        this.boDown.setActionCommand("DOWN");
        this.boDown.addActionListener(this.myController);
        ((Container)object).add(jLabel);
        ((Container)object).add(this.methodText);
        ((Container)object).add(this.boUp);
        ((Container)object).add(jLabel2);
        ((Container)object).add(this.returnText);
        ((Container)object).add(this.boDown);
        ((Container)object).add(jLabel3);
        ((Container)object).add(this.visiText);
        return object;
    }

    private boolean isMethodSelect() {
        return this.clone != null && this.showFlg && this.clone.methodList.size() > this.methodNo && this.methodNo > -1;
    }

    private Component getButton() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 4));
        this.bo1 = new JButton("\u8ffd\u52a0");
        this.bo1.setActionCommand("ADD");
        this.bo1.addActionListener(this.myController);
        this.bo2 = new JButton("\u524a\u9664");
        this.bo2.setActionCommand("DELETE");
        this.bo2.addActionListener(this.myController);
        jPanel.add(this.bo1);
        jPanel.add(this.bo2);
        return jPanel;
    }

    protected ParameterController makeController() {
        return new ParameterController(this);
    }

    void setSelectLine(int n) {
        this.methodNo = n;
        this.drawOne();
    }

    public void setBtnEnabled() {
        this.bo1.setEnabled(this.showFlg);
        this.bo2.setEnabled(this.showFlg);
        this.boUp.setEnabled(this.showFlg);
        this.boDown.setEnabled(this.showFlg);
    }

    public void addModel() {
        this.clone.addParameter(this.methodNo);
        this.tableModel.addRow(new String[]{"new parameter", "String"});
    }

    public void deleteModel() {
        if (this.table.getSelectedRow() > -1) {
            this.clone.deleteParameter(this.methodNo, this.table.getSelectedRow());
            this.tableModel.removeRow(this.table.getSelectedRow());
        }
    }

    public void up() {
        int n = this.table.getSelectedRow();
        if (n > 0) {
            this.clone.changeParameterSeq(this.methodNo, this.table.getSelectedRow(), true);
            this.tableModel.moveRow(n, n, n - 1);
            this.table.setRowSelectionInterval(n - 1, n - 1);
        }
    }

    public void down() {
        int n = this.table.getSelectedRow();
        if (n > -1 && n < this.table.getRowCount() - 1) {
            this.clone.changeParameterSeq(this.methodNo, this.table.getSelectedRow(), false);
            this.tableModel.moveRow(n, n, n + 1);
            this.table.setRowSelectionInterval(n + 1, n + 1);
        }
    }

    public void setShowFlg(boolean bl) {
        this.showFlg = bl;
    }

    protected void setClassNode(ClassNode classNode) {
        this.clone = classNode;
    }
}

