/*
 * Decompiled with CFR 0.152.
 */
package ash.reverse.struct;

import ash.reverse.struct.ClassRecord;
import ash.reverse.struct.FieldRecord;
import ash.reverse.struct.FileRecord;
import ash.reverse.struct.MethodRecord;
import ash.reverse.struct.ObjectRecord;
import ash.reverse.struct.ObjectVisitor;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ClassVisitor
implements ObjectVisitor {
    private Map<String, ClassRecord> classMap = new LinkedHashMap<String, ClassRecord>();
    private Map<String, ClassRecord> fqcnMap = new LinkedHashMap<String, ClassRecord>();
    private int classID = 0;

    public static Map<String, ClassRecord> createClassMap(List<FileRecord> list) {
        return new ClassVisitor(list).classMap;
    }

    public ClassVisitor(List<FileRecord> list) {
        for (FileRecord fileRecord : list) {
            this.visit(fileRecord);
        }
    }

    public Map<String, ClassRecord> classMap() {
        return this.classMap;
    }

    public Map<String, ClassRecord> fqcnMap() {
        return this.fqcnMap;
    }

    @Override
    public void visit(FileRecord fileRecord) {
        for (ObjectRecord objectRecord : fileRecord.members) {
            objectRecord.accept(this);
        }
    }

    @Override
    public void visit(ClassRecord classRecord) {
        classRecord.id(++this.classID);
        this.classMap.put(classRecord.name, classRecord);
        this.fqcnMap.put(classRecord.fqcn(), classRecord);
        for (ObjectRecord objectRecord : classRecord.members) {
            objectRecord.accept(this);
        }
    }

    @Override
    public void visit(MethodRecord methodRecord) {
    }

    @Override
    public void visit(FieldRecord fieldRecord) {
    }
}

