/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.core;

import ash.gui.core.AshIMenu;
import ash.gui.core.GUIAdapter;
import ash.util.Log;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class AshPopupMenu
extends JPopupMenu
implements AshIMenu {
    private ActionListener listener = GUIAdapter.getListener();
    private Component popupArea;
    private PupupMouseAdapter popupLauncher = new PupupMouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isRightMouseButton(mouseEvent) && AshPopupMenu.this.getComponentCount() != 0) {
                AshPopupMenu.this.popupSelected(mouseEvent);
                AshPopupMenu.this.show(AshPopupMenu.this.popupArea, mouseEvent.getX() + 4, mouseEvent.getY() - 4);
            }
        }
    };

    public static AshPopupMenu create(ActionListener actionListener) {
        AshPopupMenu ashPopupMenu = new AshPopupMenu();
        ashPopupMenu.setActionListener(actionListener);
        return ashPopupMenu;
    }

    public static AshPopupMenu create(Component component, ActionListener actionListener) {
        AshPopupMenu ashPopupMenu = AshPopupMenu.create(actionListener);
        ashPopupMenu.setPopupListener(component);
        return ashPopupMenu;
    }

    public AshPopupMenu() {
        this.construct();
    }

    public AshPopupMenu(Component component) {
        this.construct();
        this.setPopupListener(component);
    }

    protected void construct() {
    }

    public void setPopupListener(Component component) {
        this.popupArea = component;
        for (MouseListener mouseListener : component.getMouseListeners()) {
            if (!(mouseListener instanceof PupupMouseAdapter)) continue;
            if (mouseListener == this.popupLauncher) {
                return;
            }
            Log.debug(101, "AshPopupMenu#setPopupListener(): " + mouseListener);
            component.removeMouseListener(mouseListener);
        }
        component.addMouseListener(this.popupLauncher);
    }

    public void setActionListener(ActionListener actionListener) {
        this.listener = actionListener;
    }

    protected void popupSelected(MouseEvent mouseEvent) {
    }

    @Override
    public JMenuItem add(String string, String string2) {
        return this.add(string, string2, this.listener);
    }

    protected JMenuItem add(String string, String string2, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem();
        jMenuItem.setText(string);
        jMenuItem.setActionCommand(string2);
        jMenuItem.addActionListener(actionListener);
        this.add(jMenuItem);
        return jMenuItem;
    }

    class PupupMouseAdapter
    extends MouseAdapter {
        PupupMouseAdapter() {
        }
    }
}

