/*
 * Decompiled with CFR 0.152.
 */
package ash.gui.core;

import ash.gui.core.AshPanel;
import ash.gui.core.GUIAdapter;
import ash.util.FileUtil;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JTextField;

public class AshFileChooser
extends AshPanel
implements ActionListener {
    private JTextField field;
    private JButton rootButton = new JButton("\u25bc");
    private int mode = 0;

    public JTextField getField() {
        return this.field;
    }

    public AshFileChooser(String string, int n, char c) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.rootButton.addActionListener(this);
        this.field = this.field(string, n);
        this.add((Component)this.field);
        this.add((Component)this.rootButton);
        switch (c) {
            case 'f': {
                this.mode = 0;
                break;
            }
            case 'd': {
                this.mode = 1;
                break;
            }
            case 'b': {
                this.mode = 2;
            }
        }
    }

    public String getText() {
        return this.field.getText();
    }

    public void setText(String string) {
        this.field.setText(string);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file;
        File file2 = GUIAdapter.findFile(this.getText());
        if (file2 == null) {
            file2 = new File(".");
        }
        if ((file = this.chooseDirectory(file2)) != null) {
            this.setText(FileUtil.getPath(file));
        }
    }

    private File chooseDirectory(File file) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setSelectedFile(file);
        jFileChooser.setFileSelectionMode(this.mode);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            return jFileChooser.getSelectedFile();
        }
        return null;
    }
}

